/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ACL;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AclEntry;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.Field;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.FieldIterator;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.runtime.CommonMetadata;
import com.ibm.es.nuvo.crawler.runtime.FieldMap;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DeleteCrawlerDocument;
import com.ibm.es.nuvo.documentqueue.DeleteDocument;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.QueuedDocument;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import com.ibm.es.nuvo.util.url.URLEncoderDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;
import java.util.logging.Level;

public class QueueWriter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = QueueWriter.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private final DocumentQueueInterface documentQueue;
    private final String collectionId;
    private final boolean aclNormalization;
    private static final String URL_ENCODING = "UTF-8";

    public QueueWriter(String colId, boolean isACLNormalized, QueueType queueType) {
        this.collectionId = colId;
        this.aclNormalization = isACLNormalized;
        switch (queueType) {
            case STDOUT: {
                this.documentQueue = new PrintStreamDocumentQueue(System.out);
                break;
            }
            case NULL: {
                this.documentQueue = new PrintStreamDocumentQueue(null);
                break;
            }
            default: {
                this.documentQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
            }
        }
    }

    public QueueWriter(String colId, boolean isACLNormalized, DocumentQueueInterface docQueue) {
        this.collectionId = colId;
        this.aclNormalization = isACLNormalized;
        this.documentQueue = docQueue;
    }

    public void writeDocument(String crawlspaceId, String uri, String securityUri, String docTitle, CommonMetadata common, FieldMap fieldMap, Content content, long maxPageLength) throws DocumentStreamCreateException, DocumentQueueInsertException, AdapterException {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.entering(className, "writeDocument", new Object[]{this.collectionId, crawlspaceId, uri});
        }
        if (content == null) {
            return;
        }
        long remain = maxPageLength;
        Metadata metadata = new Metadata();
        Acl crawlerAcl = content.getAcl();
        if (crawlerAcl != null) {
            String domain = crawlerAcl.getDomianID();
            ACL acl = new ACL(domain);
            Iterator<AclEntry> entries = crawlerAcl.getEntries();
            while (entries.hasNext()) {
                AclEntry entry = entries.next();
                if (this.aclNormalization) {
                    acl.addACLToken(entry.getNormalizedPrincipal(), entry.getLevel(), entry.isPartial());
                    continue;
                }
                acl.addACLToken(entry.getPrincipal(), entry.getLevel(), entry.isPartial());
            }
            metadata.setACL(acl);
        }
        FieldIterator fields = content.getFields();
        block25: while (fields.hasNext()) {
            Field field = fields.next();
            String name = fieldMap.map(field.getName());
            if (field.isNull() || name == null || name.length() == 0) continue;
            FieldDefinition def = fieldMap.getFieldDefinition(field.getName());
            Metadata.Type type = def.isSystemField() ? Metadata.Type.CrawlerImplicit : Metadata.Type.CrawlerFields;
            try {
                switch (field.getType()) {
                    case BOOLEAN: {
                        metadata.add(type, name, field.getBoolean(), field.getString());
                        continue block25;
                    }
                    case DATE: {
                        Date d = field.getDate();
                        if (d == null) break;
                        metadata.add(type, name, d, field.getString());
                        continue block25;
                    }
                    case DOUBLE: {
                        metadata.add(type, name, field.getDouble(), field.getString());
                        continue block25;
                    }
                    case LONG: {
                        metadata.add(type, name, field.getLong(), field.getString());
                        continue block25;
                    }
                    case READER: 
                    case STRING: {
                        metadata.add(type, name, field.getString());
                        continue block25;
                    }
                }
            }
            catch (AdapterException w) {
                if (!tracer.isLoggable(Level.FINE)) continue;
                tracer.fine("Cannot get '" + field.getName() + "' field value of " + uri);
            }
        }
        DataBufferStreamDocument document = null;
        if (content.hasBody()) {
            ContentBody body = content.getBody();
            if (body instanceof SimpleContent.ContentBodyImpl && content.getBody().getLength() < maxPageLength) {
                document = new DataBufferStreamDocument(uri, ((SimpleContent.ContentBodyImpl)body).getDataBuffer());
            } else {
                InputStream is = null;
                DataBufferOutputStream dbos = null;
                try {
                    int len;
                    is = content.getBody().getStream();
                    dbos = new DataBufferOutputStream();
                    byte[] buffer = new byte[4096];
                    while ((len = is.read(buffer)) > 0) {
                        if ((remain -= (long)len) < 0L) {
                            if (!logger.isLoggable(Level.WARNING)) break;
                            Message msg = new Message("C3510W.CFW_CONTENT_TRUNCATED");
                            msg.addArgument(URLEncoderDecoder.decode(uri));
                            msg.addArgument(maxPageLength);
                            logger.log(Level.WARNING, msg);
                            break;
                        }
                        dbos.write(buffer, 0, len);
                    }
                    dbos.flush();
                    dbos.close();
                    document = new DataBufferStreamDocument(uri, dbos);
                }
                catch (IOException ioe) {
                    throw new AdapterException(ioe);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException ignored) {}
                    }
                    if (dbos != null) {
                        try {
                            dbos.close();
                        }
                        catch (IOException ignored) {}
                    }
                }
            }
            if (body.getMimetype() != null) {
                metadata.set(body.isKnownMimetype() ? "KnownContentType" : "ContentType", body.getMimetype());
            }
            if (body.getEncoding() != null) {
                metadata.set(body.isKnownEncoding() ? "KnownCharset" : "Charset", body.getEncoding());
            }
            if (body.getFilename() != null) {
                metadata.set("Filename", body.getFilename());
            }
            if (body.getLength() >= 0L) {
                metadata.set("Length", Long.toString(body.getLength()));
            }
        } else {
            document = new DataBufferStreamDocument(uri, null);
        }
        metadata.set("CrawlSpaceID", crawlspaceId);
        String url = uri;
        try {
            url = URLDecoder.decode(url, URL_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        metadata.set("URL", url);
        Date date = content.getDate();
        if (date == null) {
            date = new Date(System.currentTimeMillis());
        }
        metadata.set("Date", Long.toString(date.getTime()));
        if (common.getLanguage() != null) {
            metadata.set(common.isKnownLanguage() ? "KnownLanguage" : "Language", common.getLanguage());
        }
        if (common.getCharset() != null) {
            metadata.set(common.isKnownCharset() ? "KnownCharset" : "Charset", common.getCharset());
        }
        if (securityUri != null) {
            metadata.set("securityuri", securityUri);
        }
        if (docTitle != null) {
            metadata.getMetadataPart(Metadata.Type.CrawlerFields).set("title", docTitle);
        }
        if (document != null) {
            document.setMetadata(metadata);
            this.documentQueue.addDocument(this.collectionId, document);
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.exiting(className, "writeDocument");
        }
    }

    public void removeByHash(String crawlspaceId, Long id) {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.entering(className, "removeByHash", new Object[]{this.collectionId, crawlspaceId, id});
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.exiting(className, "removeByHash");
        }
    }

    public void removeByURI(String crawlspaceId, String uri) throws DocumentQueueInsertException {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.entering(className, "removeByURI", new Object[]{this.collectionId, crawlspaceId, uri});
        }
        DeleteDocument document = new DeleteDocument(uri);
        this.documentQueue.addDocument(this.collectionId, document);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.exiting(className, "removeByURI");
        }
    }

    public void removeByCrawlSpace(String crawlspaceId) throws DocumentQueueInsertException {
        if (tracer.isLoggable(Level.FINER)) {
            tracer.entering(className, "removeByCrawlSpace", new Object[]{this.collectionId, crawlspaceId});
        }
        DeleteCrawlerDocument document = new DeleteCrawlerDocument(crawlspaceId);
        this.documentQueue.addDocument(this.collectionId, document);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.exiting(className, "removeByCrawlSpace");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PrintStreamDocumentQueue
    implements DocumentQueueInterface {
        private final PrintStream out;
        private long totalDocs = 0L;

        private PrintStreamDocumentQueue(PrintStream out) {
            this.out = out;
            this.totalDocs = 0L;
        }

        @Override
        public void getAllCollections(Vector<String> allCollections) {
        }

        @Override
        public void addDocument(String colId, BaseDocument document) throws DocumentQueueInsertException {
            ++this.totalDocs;
            if (this.out != null) {
                if (document instanceof StreamedDocument) {
                    StreamedDocument doc = (StreamedDocument)document;
                    this.out.println(this.totalDocs + " : Crawled " + colId + " " + doc.getUri());
                    this.out.println("        Metadata " + doc.getMetadata());
                    doc.dispose();
                } else if (document instanceof DeleteDocument) {
                    this.out.println(this.totalDocs + " : Crawled(Removed) " + colId + " " + document.getUri());
                } else if (document instanceof DeleteCrawlerDocument) {
                    this.out.println(this.totalDocs + " : CrawlSpace(Removed) " + colId + " " + ((DeleteCrawlerDocument)document).getCrawlspace());
                } else {
                    this.out.println(this.totalDocs + " : Crawled(Other) " + colId + " " + document.getUri());
                }
                this.out.flush();
            }
        }

        @Override
        public void addDocumentStream(String colId, BaseDocument document) throws DocumentQueueInsertException {
            this.addDocument(colId, document);
        }

        @Override
        public long getTotalDocsProcessed() {
            return this.totalDocs;
        }

        @Override
        public void getDocuments(String collectionId, LinkedList<QueuedDocument> documentList) {
        }

        @Override
        public void drainTo(Hashtable<String, LinkedList<QueuedDocument>> collection) {
        }

        @Override
        public void removeDocuments(String collectionId, LinkedList<QueuedDocument> queuedDocuments) {
        }

        @Override
        public void getStatus(Vector<String> collectionIds, Vector<Boolean> docInBatchList, Vector<String> documentURIs, Vector<String> documentTypes, Vector<String> dataFileNames) {
        }

        @Override
        public int getCounter() {
            return 0;
        }

        @Override
        public void renameCollection(String oldCollectionId, String newCollectionId) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum QueueType {
        SYSTEM,
        STDOUT,
        NULL;

    }
}

