/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.admin.NotesCrawlMode;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.dataio.ingest.IngestException;
import com.ibm.es.nuvo.dataio.ingest.IngestManager;
import com.ibm.es.nuvo.dataio.ingest.IngestResult;
import com.ibm.es.nuvo.dataio.util.fenced.FencedErrorMessage;
import com.ibm.es.nuvo.documentqueue.BaseDocument;
import com.ibm.es.nuvo.documentqueue.CompoundDocument;
import com.ibm.es.nuvo.documentqueue.DataBufferStreamDocument;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.documentqueue.StreamedDocument;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.databuffer.DataBufferOutputStream;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import com.ibm.es.nuvo.util.url.URLEncoderDecoder;
import com.ibm.supa.config.AnalysisScopeConfig;
import com.ibm.supa.config.ConfigurationLoader;
import com.ibm.supa.notes.NotesConfigManager;
import com.ibm.supa.notes.NotesFilters;
import com.ibm.supa.notes.NotesNSFConfig;
import com.ibm.supa.notes.db.NotesDBPreCrawlInfo;
import com.ibm.supa.notes.replication.ReplicationInfoManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotesContentSet
extends ContentSet {
    private static final String FIELD_DATE = "Date";
    private String collectionId;
    private List<DocUriTuple> entries;
    private Iterator<DocUriTuple> entriesIt;
    private DocUriTuple entry;
    private IngestResult result;
    private Acl acl;
    private List<String> metaDataViewableFields;
    private NotesFilters notesFilters;
    private List<String> subjectFieldPriority;
    private String uri;
    private String dirName;
    private String notesReplicaServerName;
    private String shortenServerName;
    private NotesCrawlMode notesCrawlMode;
    private boolean definitelyAllCrawled;
    private Map<String, String> urlsModifiedDate;
    private Long lastDBModifiedDate;
    private boolean quickModeDoc;
    private Set<String> allNotCrawledUrls;
    private Iterator<String> notCrawledUrlsIt;
    private String notCrawledUrlEntry;
    private static final String className = NotesContentSet.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    public static final String ATTR_NOTES_ENTRY = "NotesEntry=";
    public static final String NOTES_URI_PREFIX = "Notes://";

    public static NotesContentSet getNotesContentSet(NotesDBPreCrawlInfo notesDBPreCrawlInfo, String uri, Date baseDate, Content content, String collectionId, NotesCrawlMode notesCrawlMode) {
        if (!NotesConfigManager.isNotesSupported() || notesDBPreCrawlInfo == null || !notesDBPreCrawlInfo.canConnect()) {
            return null;
        }
        if (content.hasBody() && DataIOType.isExtNSF(uri)) {
            String decUri = URLEncoderDecoder.decode(uri);
            int fileNamePos = decUri.lastIndexOf("/") + 1;
            String nsfFileName = null;
            nsfFileName = fileNamePos >= 0 ? decUri.substring(fileNamePos) : decUri;
            NotesContentSet set = new NotesContentSet(notesDBPreCrawlInfo, nsfFileName, baseDate, uri, content, collectionId, notesCrawlMode);
            if (set.getResult() != null) {
                return set;
            }
            return null;
        }
        return null;
    }

    private NotesContentSet(NotesDBPreCrawlInfo notesDBPreCrawlInfo, String nsfFileName, Date baseDate, String uri, Content content, String collectionId, NotesCrawlMode notesCrawlMode) {
        block17: {
            this.definitelyAllCrawled = false;
            this.collectionId = collectionId;
            this.notesCrawlMode = notesCrawlMode;
            if (this.notesCrawlMode == null) {
                this.notesCrawlMode = NotesCrawlMode.NORMAL;
            }
            this.urlsModifiedDate = null;
            this.definitelyAllCrawled = false;
            this.lastDBModifiedDate = null;
            this.quickModeDoc = false;
            this.allNotCrawledUrls = null;
            this.notCrawledUrlsIt = null;
            this.notCrawledUrlEntry = null;
            AnalysisScopeConfig config = ConfigurationLoader.getAnalysisScopeConfig(this.collectionId);
            NotesNSFConfig notesNSFConfig = config.getNotesConfig().getNotesNSFConfig(nsfFileName);
            this.subjectFieldPriority = notesNSFConfig.getSubjectPossibleFields();
            this.notesFilters = notesNSFConfig.getFilters();
            this.metaDataViewableFields = notesNSFConfig.getMetaDataView();
            this.uri = uri;
            this.dirName = FSURIUtil.getFileObject(uri).getParentFile().getAbsolutePath();
            File dbp = FSURIUtil.getFileObject(this.uri);
            String dbFullPath = null;
            try {
                dbFullPath = dbp.getCanonicalPath();
            }
            catch (IOException e) {
                dbFullPath = null;
            }
            this.notesReplicaServerName = ReplicationInfoManager.getInstance().getServerName(dbFullPath);
            this.shortenServerName = null;
            if (this.notesReplicaServerName != null) {
                this.shortenServerName = this.notesReplicaServerName.indexOf("/") != -1 ? this.notesReplicaServerName.substring(0, this.notesReplicaServerName.indexOf("/")) : this.notesReplicaServerName;
            }
            if (this.shortenServerName == null) {
                this.shortenServerName = "";
            }
            this.acl = content.getAcl();
            try {
                String userIdPath = NotesConfigManager.getInstance().getUserIdPathInfo();
                String userPass = null;
                try {
                    userPass = NotesConfigManager.getInstance().getEncryptedUserPassWordInfo();
                }
                catch (Exception e) {
                    userPass = null;
                }
                this.lastDBModifiedDate = notesDBPreCrawlInfo.getLastDBModifiedDate();
                this.urlsModifiedDate = notesDBPreCrawlInfo.getUrlsModifiedDate();
                this.result = IngestManager.instance().execute(uri, baseDate, userIdPath, userPass);
                if (this.result != null) {
                    this.entries = new ArrayList<DocUriTuple>();
                    if (this.result.hasNext()) {
                        BaseDocument curDoc = this.result.nextDocument();
                        String docUri = curDoc.getUri();
                        this.entries.clear();
                        this.extractAllDocEntries((StreamedDocument)curDoc, docUri, true);
                    } else {
                        this.definitelyAllCrawled = true;
                    }
                }
            }
            catch (IngestException e) {
                if (e.getMessage().equals(FencedErrorMessage.ingestMessageMap.get(1065))) {
                    this.definitelyAllCrawled = true;
                } else {
                    e.printStackTrace();
                }
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(new IllegalNoteFormatException(uri, e));
                }
                if (this.result == null) break block17;
                try {
                    this.result.close();
                }
                catch (IngestException ie) {
                    ie.printStackTrace();
                }
                this.result = null;
            }
        }
    }

    public IngestResult getResult() {
        return this.result;
    }

    private void extractAllDocEntries(StreamedDocument doc, String docUri, boolean isHighLevel) {
        Iterable<StreamedDocument> parts = null;
        boolean filterHighLevel = false;
        if (doc instanceof CompoundDocument) {
            CompoundDocument parent = (CompoundDocument)doc;
            parts = parent.getParts();
            if (isHighLevel && doc.getMetadata() != null && !this.notesFilters.isEssentialDocument(doc).booleanValue()) {
                filterHighLevel = true;
            }
            if (!(parts == null || this.notesFilters.getFilterAttachments().booleanValue() || filterHighLevel && this.notesFilters.getFilterAttachmentForFilteredDocs().booleanValue())) {
                for (StreamedDocument attachment : parts) {
                    String encodedAttachUri;
                    try {
                        encodedAttachUri = URLEncoder.encode(attachment.getUri(), "utf-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        encodedAttachUri = attachment.getUri();
                    }
                    this.extractAllDocEntries(attachment, docUri + "/?" + ATTR_NOTES_ENTRY + encodedAttachUri, false);
                }
            }
        }
        if (!filterHighLevel) {
            this.addEntry(doc, docUri, isHighLevel, parts);
        }
        this.entriesIt = this.entries.iterator();
    }

    private void addEntry(StreamedDocument doc, String docUri, boolean isHighLevel, Iterable<StreamedDocument> parts) {
        if (doc != null && docUri != null) {
            String replicaId = doc.getMetadata().get("ReplicaId");
            if (replicaId == null) {
                replicaId = "";
            }
            if (doc.getInputStream() != null || parts != null || doc.getMetadata() != null) {
                this.addDocument(doc, replicaId, isHighLevel, parts, docUri);
            }
        }
    }

    private void addDocument(StreamedDocument doc, String replicaId, boolean isHighLevel, Iterable<StreamedDocument> parts, String docUri) {
        String subject = null;
        if (doc.getMetadata() != null && this.subjectFieldPriority != null) {
            for (String possibleSubjectField : this.subjectFieldPriority) {
                subject = doc.getMetadata().get(possibleSubjectField);
                if (subject == null || subject.equals("")) continue;
                break;
            }
        }
        String completeUri = NOTES_URI_PREFIX + this.shortenServerName + "/" + replicaId + "/0/" + docUri;
        this.entries.add(new DocUriTuple(doc, completeUri, isHighLevel, parts, subject));
    }

    @Override
    public Content getContent() throws AdapterException {
        SimpleContent content;
        block10: {
            if (this.quickModeDoc) {
                return null;
            }
            content = SimpleBuilder.newContent();
            if (this.acl != null) {
                content.setAcl(this.acl.clone());
            }
            try {
                if (this.entry.getDoc() instanceof StreamedDocument) {
                    StreamedDocument doc = (StreamedDocument)this.entry.getDoc();
                    Iterable<StreamedDocument> parts = this.entry.getParts();
                    String fileName = this.entry.getUri();
                    InputStream is = doc.getInputStream();
                    if (this.entry.isHighLevel()) {
                        is = this.addMetaDataToInputStream(is, doc.getMetadata(), parts);
                    }
                    content.addField("securityuri", this.uri);
                    if (this.entry.isHighLevel()) {
                        fileName = this.entry.getSubject() == null ? "" : "NotesDoc:" + this.entry.getSubject() + ".notes";
                    }
                    content.addField("filename", fileName);
                    content.addField("dirname", this.dirName);
                    content.createBody(is, fileName);
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException e) {}
                    }
                    break block10;
                }
                return null;
            }
            catch (IOException e) {
                throw new AdapterException(e);
            }
        }
        return content;
    }

    @Override
    public long getLastModified() {
        if (this.quickModeDoc) {
            return new Long(this.urlsModifiedDate.get(this.notCrawledUrlEntry));
        }
        String docDateModified = ((StreamedDocument)this.entry.getDoc()).getMetadata().get("lastmodifiedtime");
        String attachDateModified = ((StreamedDocument)this.entry.getDoc()).getMetadata().get("docdate");
        String docDate = ((StreamedDocument)this.entry.getDoc()).getMetadata().get(FIELD_DATE);
        String lastModified = null;
        lastModified = docDateModified != null ? docDateModified : (attachDateModified != null ? attachDateModified : docDate);
        return new Long(lastModified);
    }

    @Override
    public String getURI() {
        if (this.quickModeDoc) {
            return NOTES_URI_PREFIX + this.shortenServerName + "/" + this.notCrawledUrlEntry;
        }
        String res = this.entry.getUri();
        return res;
    }

    @Override
    public long getHash() {
        return 0L;
    }

    public boolean isCurrentForQuickMode() {
        return this.quickModeDoc;
    }

    public String getSecurityURI() {
        return this.uri;
    }

    public Long getLastDBModifiedDate() {
        return this.lastDBModifiedDate;
    }

    public String getDocTitle() {
        if (this.quickModeDoc) {
            return null;
        }
        if (this.entry.isHighLevel()) {
            return this.entry.getSubject();
        }
        return null;
    }

    @Override
    public boolean next() throws AdapterException {
        boolean ans = true;
        if (!this.quickModeDoc) {
            ans = this.crawledDocsNext();
        }
        if (!ans && this.urlsModifiedDate != null) {
            this.quickModeDoc = true;
        }
        if (this.quickModeDoc) {
            ans = this.notCrawledDocsNext();
        }
        return ans;
    }

    private boolean notCrawledDocsNext() {
        if (this.allNotCrawledUrls == null) {
            this.extractAllNotCrawled();
        }
        if (this.notCrawledUrlsIt == null) {
            return false;
        }
        if (this.notCrawledUrlsIt.hasNext()) {
            this.notCrawledUrlEntry = this.notCrawledUrlsIt.next();
            return true;
        }
        return false;
    }

    private void extractAllNotCrawled() {
        this.allNotCrawledUrls = this.urlsModifiedDate.keySet();
        this.notCrawledUrlsIt = this.allNotCrawledUrls.iterator();
    }

    private boolean crawledDocsNext() throws AdapterException {
        if (this.entriesIt == null) {
            this.definitelyAllCrawled = true;
            return false;
        }
        if (this.entriesIt.hasNext()) {
            this.entry = this.entriesIt.next();
            this.removeAlreadyCrawledFromAllMap();
            return true;
        }
        try {
            while (!this.entriesIt.hasNext() && this.result.hasNext()) {
                BaseDocument curDoc = this.result.nextDocument();
                String docUri = curDoc.getUri();
                this.entries.clear();
                this.extractAllDocEntries((StreamedDocument)curDoc, docUri, true);
            }
            if (this.entriesIt != null && this.entriesIt.hasNext()) {
                return this.crawledDocsNext();
            }
            this.definitelyAllCrawled = true;
            return false;
        }
        catch (IngestException e) {
            e.printStackTrace();
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(new MalformedNoteEntryException(this.uri, this.entry != null ? this.entry.getDoc().getUri() : "<first>", e));
            }
            this.close();
            return false;
        }
    }

    private void removeAlreadyCrawledFromAllMap() {
        if (this.urlsModifiedDate == null || this.entry == null || this.entry.getUri() == null) {
            return;
        }
        String preUrl = NOTES_URI_PREFIX + this.shortenServerName + "/";
        String orginalUrl = this.entry.getUri().substring(preUrl.length());
        this.urlsModifiedDate.remove(orginalUrl);
    }

    public boolean didAllDocumentsGotCrawled() {
        return this.definitelyAllCrawled;
    }

    @Override
    public void close() throws AdapterException {
        try {
            this.result.close();
        }
        catch (IngestException e) {
            if (logger.isLoggable(Level.WARNING)) {
                String messageStr = "problems in closing notes db - " + this.uri;
                Message msg = new Message("G0020E.EXTERNAL_ERROR_MESSAGE", messageStr);
                logger.log(Level.WARNING, msg);
            }
            this.result = null;
        }
    }

    private InputStream addMetaDataToInputStream(InputStream is, Metadata md, Iterable<StreamedDocument> parts) {
        if (md == null && parts == null) {
            return is;
        }
        DataBufferStreamDocument document = null;
        try {
            byte[] docBytes = null;
            if (is != null) {
                docBytes = new byte[is.available()];
                is.read(docBytes);
            } else {
                docBytes = new byte[]{};
            }
            StringBuffer metaData = new StringBuffer();
            metaData.append(System.getProperty("line.separator"));
            metaData.append("=======================================================");
            metaData.append(System.getProperty("line.separator"));
            for (String curMataData : this.metaDataViewableFields) {
                String metaDataVal = md.get(curMataData);
                if (metaDataVal == null) continue;
                if (curMataData.equals("createdtime") || curMataData.equals("lastmodifiedtime")) {
                    metaDataVal = this.longToDate(metaDataVal);
                }
                metaData.append(curMataData).append(" - ").append(metaDataVal);
                metaData.append(System.getProperty("line.separator"));
            }
            if (parts != null) {
                for (StreamedDocument attachment : parts) {
                    String encodedAttachUri = attachment.getUri();
                    metaData.append("Attachment").append(" - ").append(encodedAttachUri);
                    metaData.append(System.getProperty("line.separator"));
                }
            }
            metaData.append("=======================================================");
            metaData.append(System.getProperty("line.separator"));
            byte[] mateDataBytes = metaData.toString().getBytes("UTF-8");
            byte[] docAndMateData = new byte[mateDataBytes.length + docBytes.length];
            for (int i = 0; i < mateDataBytes.length + docBytes.length; ++i) {
                docAndMateData[i] = i < mateDataBytes.length ? mateDataBytes[i] : docBytes[i - mateDataBytes.length];
            }
            DataBufferOutputStream dataBuffer = new DataBufferOutputStream();
            dataBuffer.write(docAndMateData);
            dataBuffer.close();
            try {
                document = new DataBufferStreamDocument("", dataBuffer);
            }
            catch (DocumentStreamCreateException e1) {
                return is;
            }
            is = document.getInputStream();
        }
        catch (Exception e) {
            return is;
        }
        return document.getInputStream();
    }

    private String longToDate(String dateAsLong) {
        return new Date(new Long(dateAsLong)).toString();
    }

    private static final class MalformedNoteEntryException
    extends ExtendedException {
        private static final long serialVersionUID = 1802069033280899892L;

        private MalformedNoteEntryException(String uri, String entryName, Throwable cause) {
            super("The crawler cannot extract the notes entry " + entryName + " from the notes file" + uri + ".", cause);
        }
    }

    private static final class IllegalNoteFormatException
    extends ExtendedException {
        private static final long serialVersionUID = -815269514863466209L;

        private IllegalNoteFormatException(String uri, Throwable cause) {
            super("The crawler cannot extract or crawl the note file " + uri + " . Document ID: " + uri + ".", cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DocUriTuple {
        private BaseDocument doc;
        private String uri;
        private boolean isHighLevel;
        Iterable<StreamedDocument> parts;
        private String subject;

        public DocUriTuple(BaseDocument doc, String uri, boolean isHighLevel, Iterable<StreamedDocument> parts, String subject) {
            this.doc = doc;
            this.uri = uri;
            this.isHighLevel = isHighLevel;
            this.parts = parts;
            this.subject = subject;
        }

        public BaseDocument getDoc() {
            return this.doc;
        }

        public String getUri() {
            return this.uri;
        }

        public boolean isHighLevel() {
            return this.isHighLevel;
        }

        public Iterable<StreamedDocument> getParts() {
            return this.parts;
        }

        public String getSubject() {
            return this.subject;
        }
    }
}

