/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreManager;
import com.ibm.es.nuvo.crawler.runtime.AFPHandler;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.FieldSelector;
import org.apache.lucene.document.FieldSelectorResult;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class IndexerCrawlerSync {
    IndexerCrawlerSync() {
    }

    public static Set<String> getAllDocumentsToUpdate(String collectionId, MetadataStoreManager metadataManager) {
        Set<String> indexErrorDocs = IndexerCrawlerSync.getAllDocumentsToUpdate(collectionId);
        if (indexErrorDocs != null) {
            return indexErrorDocs;
        }
        return Collections.emptySet();
    }

    private static Set<String> getAllDocumentsToUpdate(String collectionId) {
        try {
            HashSet<String> allUris = new HashSet<String>();
            ConfigurationManager configManager = ConfigurationManager.getConfigurationManager();
            CollectionConfiguration configuration = configManager.getCollection(collectionId);
            FSDirectory directory = FSDirectory.getDirectory((String)configuration.getIndexPath(IndexDescriptor.IndexType.Text));
            IndexReader indexReader = IndexReader.open((Directory)directory);
            FieldSelector fieldSelector = new FieldSelector(){
                private static final long serialVersionUID = -7524823581217618527L;

                public FieldSelectorResult accept(String name) {
                    FieldSelectorResult result = FieldSelectorResult.NO_LOAD;
                    if (name.equals("_code")) {
                        result = FieldSelectorResult.LOAD;
                    }
                    if (name.equals("uri")) {
                        result = FieldSelectorResult.LOAD;
                    }
                    if (name.equals("securityuri")) {
                        result = FieldSelectorResult.LOAD;
                    }
                    return result;
                }
            };
            long[] fieldValues = new long[indexReader.maxDoc()];
            for (int i = 0; i < fieldValues.length; ++i) {
                if (indexReader.isDeleted(i)) continue;
                Document doc = indexReader.document(i, fieldSelector);
                try {
                    String status = doc.get("_code");
                    int statusVal = 404;
                    if (status != null) {
                        statusVal = new Integer(status);
                    }
                    if (statusVal == 200) continue;
                    String uri = doc.get("uri");
                    String securityUri = doc.get("securityuri");
                    File physicalFile = null;
                    if (securityUri != null) {
                        physicalFile = FSURIUtil.getFileObject(securityUri);
                    } else if (uri != null) {
                        physicalFile = FSURIUtil.getFileObject(uri);
                    }
                    if (!physicalFile.exists()) continue;
                    allUris.addAll(IndexerCrawlerSync.handleSpecialURI(uri, securityUri));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            return allUris;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Set<String> handleSpecialURI(String uri, String securityUri) {
        HashSet<String> allUris = new HashSet<String>();
        if (uri == null) {
            return allUris;
        }
        if (!(uri.startsWith("file://") && AFPHandler.isAFP(uri) || DataIOType.isExtNSF(uri))) {
            allUris.add(uri);
        }
        if (uri.contains("ArchiveEntry=")) {
            String newUri = uri.substring(0, uri.indexOf("ArchiveEntry=") - 1);
            allUris.add(newUri);
        }
        if (uri.startsWith("Notes://") && securityUri != null) {
            allUris.add(securityUri);
        }
        if (uri.startsWith("file://") && uri.endsWith(AFPHandler.CONVERTED_AFP_URI_SUFFIX)) {
            String originalAFPURI = AFPHandler.reconstructOriginalAFPUri(uri);
            if (originalAFPURI != null) {
                allUris.add(originalAFPURI);
            }
            allUris.add(uri);
        }
        return allUris;
    }
}

