/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.plugin.CrawledData;
import com.ibm.es.nuvo.crawler.plugin.Metadata;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldMap {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final Map<String, FieldDefinition> definitionMap = new HashMap<String, FieldDefinition>();
    private final Map<String, FieldDefinition> userPluginUpdatedDefinitionMap = new HashMap<String, FieldDefinition>();
    private final Map<String, String> userPluginUpdatedFieldNameMap = new HashMap<String, String>();
    private boolean isUpdated = false;

    public FieldMap(SpaceConfiguration config) throws CrawlerConfigurationException {
        if (config.isSetAsCrawlSpace()) {
            Iterator<FieldConfiguration> fields = config.getFields();
            while (fields.hasNext()) {
                FieldConfiguration field = fields.next();
                if (!field.isEnabled()) continue;
                String name = field.getName();
                String typeName = field.getTypeName();
                FieldType type = field.getType();
                boolean isSystem = field.isSystemField();
                FieldDefinition fieldDefinition = null;
                switch (type) {
                    case STRING: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.STRING, isSystem);
                        break;
                    }
                    case DATE: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.DATE, isSystem);
                        break;
                    }
                    case BOOLEAN: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.BOOLEAN, isSystem);
                        break;
                    }
                    case DOUBLE: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.DOUBLE, isSystem);
                        break;
                    }
                    case LONG: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.LONG, isSystem);
                        break;
                    }
                    default: {
                        fieldDefinition = new FieldDefinition(name, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.UNKNOWN, isSystem);
                    }
                }
                this.definitionMap.put(name, fieldDefinition);
            }
        }
    }

    public void update(CrawledData updatedCrawledData) throws AdapterException {
        this.isUpdated = true;
        this.userPluginUpdatedDefinitionMap.clear();
        this.userPluginUpdatedFieldNameMap.clear();
        List<Metadata> metadataList = updatedCrawledData.getMetadataList();
        for (Metadata metadata : metadataList) {
            String nativeName = metadata.getNativeName();
            String metadataFieldName = metadata.getMetadataFieldName();
            FieldDefinition fieldDefinition = this.definitionMap.get(nativeName);
            if (fieldDefinition == null) {
                String typeName = "";
                Metadata.MetadataType type = metadata.getMetadataType();
                boolean isSystem = false;
                fieldDefinition = type.equals((Object)Metadata.MetadataType.STRING) ? new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.STRING, isSystem) : (type.equals((Object)Metadata.MetadataType.DATE) ? new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.DATE, isSystem) : (type.equals((Object)Metadata.MetadataType.BOOLEAN) ? new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.BOOLEAN, isSystem) : (type.equals((Object)Metadata.MetadataType.DOUBLE) ? new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.DOUBLE, isSystem) : (type.equals((Object)Metadata.MetadataType.LONG) ? new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.LONG, isSystem) : new FieldDefinition(nativeName, typeName, com.ibm.es.nuvo.crawler.adapter.FieldType.UNKNOWN, isSystem)))));
            }
            this.userPluginUpdatedDefinitionMap.put(nativeName, fieldDefinition);
            this.userPluginUpdatedFieldNameMap.put(nativeName, metadataFieldName);
        }
    }

    public Set<String> getNames() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.definitionMap.keySet());
        return names;
    }

    public FieldDefinition getFieldDefinition(String name) {
        if (this.isUpdated) {
            return this.userPluginUpdatedDefinitionMap.get(name);
        }
        return this.definitionMap.get(name);
    }

    public String map(String name) {
        if (name != null) {
            if (this.isUpdated) {
                return this.userPluginUpdatedFieldNameMap.get(name);
            }
            return this.definitionMap.containsKey(name) ? name : null;
        }
        return null;
    }
}

