/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.ContentQuery;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.ItemNotFoundException;
import com.ibm.es.nuvo.crawler.adapter.LoginException;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.adapter.URINormalizer;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.NotesCrawlMode;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreManager;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfo;
import com.ibm.es.nuvo.crawler.cdsr.SimpleStoreContextBroker;
import com.ibm.es.nuvo.crawler.cdsr.StoreContext;
import com.ibm.es.nuvo.crawler.cdsr.StoreContextBroker;
import com.ibm.es.nuvo.crawler.plugin.CrawledData;
import com.ibm.es.nuvo.crawler.plugin.CrawledDataFactory;
import com.ibm.es.nuvo.crawler.plugin.CrawlerPlugin;
import com.ibm.es.nuvo.crawler.plugin.CrawlerPluginException;
import com.ibm.es.nuvo.crawler.plugin.Metadata;
import com.ibm.es.nuvo.crawler.runtime.AFPContentSet;
import com.ibm.es.nuvo.crawler.runtime.AFPHandler;
import com.ibm.es.nuvo.crawler.runtime.AdapterService;
import com.ibm.es.nuvo.crawler.runtime.ArchiveContentSet;
import com.ibm.es.nuvo.crawler.runtime.CommonMetadata;
import com.ibm.es.nuvo.crawler.runtime.CrawlSpaceMonitor;
import com.ibm.es.nuvo.crawler.runtime.FieldMap;
import com.ibm.es.nuvo.crawler.runtime.IndexerCrawlerSync;
import com.ibm.es.nuvo.crawler.runtime.NotesContentSet;
import com.ibm.es.nuvo.crawler.runtime.QueueWriter;
import com.ibm.es.nuvo.crawler.runtime.ResourceManager;
import com.ibm.es.nuvo.crawler.runtime.UserPluginException;
import com.ibm.es.nuvo.crawler.runtime.UserPluginManager;
import com.ibm.es.nuvo.crawler.util.WeakValueHashMap;
import com.ibm.es.nuvo.crawler.util.hash.HashUtil;
import com.ibm.es.nuvo.crawler.util.migration.CrawlerMigrationUtil;
import com.ibm.es.nuvo.dataio.DataIOType;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInsertException;
import com.ibm.es.nuvo.documentqueue.DocumentStreamCreateException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.supa.notes.NotesConfigManager;
import com.ibm.supa.notes.db.NotesDBPreCrawlInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;

class CollectionControl {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = CollectionControl.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private static final String taskClassName = CrawlSpaceTask.class.getName();
    private static final ExtendedLogger taskLogger;
    private static final ExtendedLogger taskAudit;
    private static final ExtendedLogger taskTracer;
    private final String colId;
    private final AdapterService adapterService;
    private final ResourceManager resourceMgr = new ResourceManager();
    private final WeakValueHashMap<String, CrawlSpaceTask> tasks = new WeakValueHashMap();
    private final QueueWriter writer;
    private final MetadataStoreManager metadataManager;
    private final UserPluginManager pluginManager;
    private static URINormalizer EMPTY_NORMALIZER;

    CollectionControl(String collectionId, AdapterService as, MetadataStoreManager msm, QueueWriter qw) {
        String methodName = "<init>";
        tracer.entering(className, "<init>", collectionId);
        this.colId = collectionId;
        this.adapterService = as;
        this.writer = qw;
        this.metadataManager = msm;
        this.pluginManager = new UserPluginManager();
        tracer.exiting(className, "<init>");
    }

    void enqueueTask(SpaceConfiguration config, ThreadPoolExecutor executor, CrawlSpaceMonitor monitor, SessionInfo session, CrawlMode mode, ClassLoader loader) {
        String methodName = "enqueueTask";
        tracer.entering(className, "enqueueTask", new Object[]{config.getID(), mode});
        CrawlSpaceTask task = new CrawlSpaceTask(config, monitor, session, mode, null, loader);
        executor.execute(task);
        this.tasks.put(config.getID(), task);
        tracer.exiting(className, "enqueueTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean cancelTask(SpaceConfiguration config, ThreadPoolExecutor executor) {
        methodName = "cancelTask";
        CollectionControl.tracer.entering(CollectionControl.className, "cancelTask", new Object[]{config.getID()});
        taskExists = false;
        task = this.tasks.remove(config.getID());
        if (task != null) {
            taskExists = true;
            executor.remove(task);
            if (CrawlSpaceTask.access$000(task) != null && CrawlSpaceTask.access$000(task).isAlive()) {
                CrawlSpaceTask.access$100(task).lock();
                try {
                    if (!CrawlSpaceTask.access$000(task).isAlive()) ** GOTO lbl20
                    CrawlSpaceTask.access$000(task).interrupt();
                }
                finally {
                    CrawlSpaceTask.access$100(task).unlock();
                }
            } else if (CrawlSpaceTask.access$000(task) == null) {
                CrawlSpaceTask.access$200(task).cancel();
            }
        }
lbl20:
        // 7 sources

        CollectionControl.tracer.exiting(CollectionControl.className, "cancelTask");
        return taskExists;
    }

    private void sendDocument(String crawlspaceId, String uri, String securityUri, String docTitle, CommonMetadata metadata, FieldMap fieldMap, Content content, long maxPageLength) throws DocumentStreamCreateException, DocumentQueueInsertException, AdapterException {
        if (content == null) {
            return;
        }
        this.writer.writeDocument(crawlspaceId, uri, securityUri, docTitle, metadata, fieldMap, content, maxPageLength);
    }

    private void removeDocByHash(String crawlspaceId, Long id) throws DocumentQueueInsertException {
        if (crawlspaceId != null && crawlspaceId.length() > 0 && id != null) {
            this.writer.removeByHash(crawlspaceId, id);
        }
    }

    private void removeDocByURI(String crawlspaceId, String uri) throws DocumentQueueInsertException {
        if (crawlspaceId != null && crawlspaceId.length() > 0 && uri != null && uri.length() > 0) {
            this.writer.removeByURI(crawlspaceId, uri);
        }
    }

    void dropCrawlSpace(String crawlspaceId) throws DocumentQueueInsertException, MetadataStoreException {
        if (crawlspaceId == null || crawlspaceId.length() == 0) {
            return;
        }
        this.writer.removeByCrawlSpace(crawlspaceId);
        this.metadataManager.drop(crawlspaceId);
    }

    static {
        taskAudit = taskLogger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + taskClassName);
        taskTracer = ExtendedLogger.getLogger("NuvoTracer." + taskClassName);
        EMPTY_NORMALIZER = new URINormalizer(){

            public String normalize(String uri) {
                return uri;
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CrawlSpaceTask
    implements Runnable {
        private NotesCrawlMode notesCrawlMode;
        private boolean isCanceled;
        private MetadataStore store;
        private Thread thread;
        private final Lock interruptionLock = new ReentrantLock(true);
        private final CrawlMode mode;
        private final SpaceConfiguration config;
        private final String crawlerId;
        private final String crawlerName;
        private final String crawlspaceId;
        private final String crawlspaceName;
        private final StoreContextBroker broaker;
        private final CrawlSpaceMonitor monitor;
        private CommonMetadata common;
        private FieldMap fieldMap;
        private final long interval;
        private final long maxPageLength;
        private final SessionInfo session;
        private final ClassLoader loader;
        private final long prevMaxLastModified;
        private long maxLastModified;
        private URINormalizer normalizer;
        private CrawlerPlugin crawlerPlugin;
        private final long configHash;
        private final long prevConfigHash;
        private long lastForceCrawled;
        private Set<String> enforceUpdateDocs;
        private final boolean wasAllDocumentUpToDate;

        public CrawlSpaceTask(SpaceConfiguration cfg, CrawlSpaceMonitor mon, SessionInfo ses, CrawlMode md, StoreContextBroker scb, ClassLoader ldr) {
            String methodName = "<init>";
            tracer.entering(taskClassName, "<init>", new Object[]{cfg.getID(), md});
            this.notesCrawlMode = NotesCrawlMode.QUICK;
            this.isCanceled = false;
            this.mode = md;
            this.monitor = mon;
            this.config = cfg;
            this.crawlerId = cfg.getCrawler().getID();
            this.crawlerName = cfg.getCrawler().getName();
            this.crawlspaceId = cfg.getID();
            this.crawlspaceName = cfg.getName();
            this.session = ses;
            this.wasAllDocumentUpToDate = ses.isAllDocumentsUpToDate();
            this.broaker = scb == null ? new SimpleStoreContextBroker() : scb;
            this.loader = ldr;
            Map<String, Configuration> configs = cfg.getCrawler().getConfigurations();
            this.interval = this.getInterval(configs.get("es:fetch_interval"));
            this.maxPageLength = this.getMaxPageLength(configs.get("es:max_page_length"));
            this.prevMaxLastModified = this.session.getMaxLastModified();
            this.prevConfigHash = this.session.getConfigHash();
            long crawlerConfigHash = this.config.getCrawler().getChecksum(true);
            long spaceConfigHash = this.config.getChecksum(true);
            this.configHash = crawlerConfigHash + spaceConfigHash;
            this.lastForceCrawled = this.session.getLastForceCrawled();
            this.crawlerPlugin = null;
            tracer.exiting(taskClassName, "<init>");
        }

        private long getInterval(Configuration param) {
            long defaultInterval = 0L;
            if (param == null || param.getType() != Configuration.Type.LONG) {
                return defaultInterval;
            }
            if (param.getLong() < 0L) {
                return defaultInterval;
            }
            return param.getLong();
        }

        private long getMaxPageLength(Configuration param) {
            long defaultMaxPageLength = 0x3200000L;
            if (param == null || param.getType() != Configuration.Type.LONG) {
                return defaultMaxPageLength;
            }
            if (param.getLong() < 0L) {
                return defaultMaxPageLength;
            }
            return param.getLong();
        }

        private CommonMetadata buildCommon(SpaceConfiguration crawlspace) throws CrawlerConfigurationException {
            CommonMetadata meta = new CommonMetadata();
            Map<String, Configuration> params = crawlspace.getCrawlSpaceConfigurations();
            if (params != null) {
                Configuration charset = params.get("es:known_charset");
                if (charset != null && charset.getString() != null) {
                    meta.setCharset(charset.getString(), true);
                } else {
                    charset = params.get("es:charset");
                    if (charset != null && charset.getString() != null) {
                        meta.setCharset(charset.getString(), false);
                    }
                }
                Configuration language = params.get("es:known_language");
                if (language != null && language.getString() != null) {
                    meta.setLanguage(language.getString(), true);
                } else {
                    language = params.get("es:language");
                    if (language != null && language.getString() != null) {
                        meta.setLanguage(language.getString(), false);
                    }
                }
            }
            return meta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block116: {
                Object v1;
                Space space;
                Adapter adapter;
                ClassLoader orgLoader;
                block111: {
                    boolean comp;
                    String methodName = "run";
                    tracer.entering(taskClassName, "run", new Object[]{this.crawlspaceId, this.mode});
                    this.thread = Thread.currentThread();
                    String orgThreadName = this.thread.getName();
                    this.thread.setName(orgThreadName + " - crawler [col:" + CollectionControl.this.colId + "][crw:" + this.crawlerName + "(" + this.crawlerId + ")][csp:" + this.crawlspaceName + "(" + this.crawlspaceId + ")]");
                    this.maxLastModified = this.prevMaxLastModified;
                    if (this.mode.equals((Object)CrawlMode.FORCE)) {
                        this.lastForceCrawled = System.currentTimeMillis();
                    }
                    if (!this.wasAllDocumentUpToDate || this.prevConfigHash != 0L && this.prevConfigHash != this.configHash) {
                        this.monitor.start(this.mode, false);
                    } else {
                        this.monitor.start(this.mode, true);
                    }
                    orgLoader = this.thread.getContextClassLoader();
                    adapter = null;
                    space = null;
                    this.enforceUpdateDocs = IndexerCrawlerSync.getAllDocumentsToUpdate(CollectionControl.this.colId, CollectionControl.this.metadataManager);
                    this.session.setStatus(this.monitor.getStatus().toString());
                    this.session.setConfigHash(this.configHash);
                    this.session.setOptionalData(new byte[0]);
                    this.session.setLastForceCrawled(this.lastForceCrawled);
                    this.session.start(this.mode.toString());
                    this.fieldMap = new FieldMap(this.config);
                    this.common = this.buildCommon(this.config);
                    this.thread.setContextClassLoader(this.loader);
                    CrawlerConfiguration crawlerConfig = this.config.getCrawler();
                    CrawlerType crawlerType = crawlerConfig.getType();
                    adapter = CollectionControl.this.adapterService.newAdapter(crawlerType.getName(), this.loader);
                    this.normalizer = adapter.createURINormalizer();
                    this.normalizer = this.normalizer == null ? EMPTY_NORMALIZER : this.normalizer;
                    space = CollectionControl.this.resourceMgr.openResource(this.config, adapter.getRootSpace());
                    this.initializeCrawlerPlugin(crawlerConfig);
                    ContentQuery query = space.createContentQuery();
                    for (String fieldName : this.fieldMap.getNames()) {
                        query.addField(this.fieldMap.getFieldDefinition(fieldName));
                    }
                    if (this.mode == CrawlMode.QUICK) {
                        query.setMaxLastModified(this.prevMaxLastModified);
                    }
                    ContentSet set = query.execute();
                    this.store = CollectionControl.this.metadataManager.getMetadataStore(this.config.getID());
                    StoreContext cx = this.store.getDefaultContext();
                    cx.set(set);
                    this.broaker.add(cx);
                    while (!Thread.currentThread().isInterrupted() && (cx = this.broaker.next()) != null) {
                        ContentSet contents = cx.get();
                        cx.setMode(this.mode);
                        try {
                            this.fetchContext(cx, contents);
                        }
                        finally {
                            contents.close();
                        }
                        this.exitContexts(this.broaker.exit(cx));
                    }
                    boolean bl = comp = !this.thread.isInterrupted();
                    if (comp) {
                        this.monitor.comp();
                        this.maxLastModified -= this.monitor.getTotalTime();
                        this.session.setNumOfTotalDoc(this.monitor.getNumberOfTotalRecords());
                        this.session.setMaxLastModified(this.prevMaxLastModified > this.maxLastModified ? this.prevMaxLastModified : this.maxLastModified);
                        CrawlerMigrationUtil.dropR1CrawlSpace(this.config, this.crawlspaceId, CollectionControl.this.writer);
                    }
                    if (taskTracer.isLoggable(Level.FINER)) {
                        taskTracer.finer("Exiting " + (comp ? "Completed" : "Interrupted"));
                    }
                    if (!taskAudit.isLoggable(Level.INFO) || Thread.interrupted()) break block111;
                    Message msg = new Message("C3015I.CRWL_GEN_COMPLETE_SPACE_INFO", this.config.getCrawler().getName(), this.config.getName());
                    taskAudit.log(Level.INFO, msg);
                }
                Object var14_32 = null;
                try {
                    Throwable e2222222222;
                    try {
                        if (space != null) {
                            CollectionControl.this.resourceMgr.closeResource(space);
                        }
                        if (adapter != null) {
                            try {
                                adapter.close();
                            }
                            catch (AdapterException e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                            }
                        }
                        if (this.store != null) {
                            this.store.close();
                            this.store = null;
                        }
                        this.terminalizeCrawlerPlugin();
                        v1 = null;
                    }
                    catch (Throwable e2222222222) {
                        this.monitor.fatal(e2222222222);
                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                        v1 = null;
                    }
                }
                catch (Throwable throwable) {
                    v1 = null;
                }
                Object var17_62 = v1;
                this.thread.setContextClassLoader(orgLoader);
                this.monitor.end();
                try {
                    this.session.setStatus(this.monitor.getStatus().toString());
                    this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                    this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                    this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                    this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                    this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                    this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                    System.out.println("crawling session info = " + this.session.printInfo());
                    this.session.close();
                }
                catch (MetadataStoreException e3) {
                    this.monitor.fatal(e3);
                    taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                }
                break block116;
                {
                    catch (InterruptedException ie) {
                        Object v2;
                        taskTracer.log(Level.FINE, "Configuration error.", ie);
                        Object var14_33 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v2 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v2 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v2 = null;
                        }
                        Object var17_63 = v2;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (CrawlerConfigurationException e) {
                        Object v3;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "Configuration error.", e);
                        } else {
                            this.monitor.fatal(e);
                            logger.log(e);
                            taskTracer.log(Level.FINE, "Configuration error.", e);
                        }
                        Object var14_34 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v3 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v3 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v3 = null;
                        }
                        Object var17_64 = v3;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (LoginException e) {
                        Object v4;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "The target server may be down.", e);
                        } else {
                            this.monitor.fatal(e);
                            logger.log(e);
                            taskTracer.log(Level.FINE, "The target server may be down.", e);
                        }
                        Object var14_35 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v4 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v4 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v4 = null;
                        }
                        Object var17_65 = v4;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (AdapterException e) {
                        Object v5;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "An unexpected crawler-adapter exception was thrown.", e);
                        } else {
                            this.monitor.fatal(e);
                            logger.log(e);
                            taskTracer.log(Level.FINE, "An unexpected crawler-adapter exception was thrown.", e);
                        }
                        Object var14_36 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v5 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v5 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v5 = null;
                        }
                        Object var17_66 = v5;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (UserPluginException e) {
                        Object v6;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "Configuration error.", e);
                        } else {
                            this.monitor.fatal(e);
                            logger.log(e);
                            taskTracer.log(Level.FINE, "Configuration error.", e);
                        }
                        Object var14_37 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v6 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v6 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v6 = null;
                        }
                        Object var17_67 = v6;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (MetadataStoreException e) {
                        Object v7;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e);
                        } else {
                            this.monitor.fatal(e);
                            Message msg = new Message(e);
                            logger.log(Level.SEVERE, msg);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e);
                        }
                        Object var14_38 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v7 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v7 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v7 = null;
                        }
                        Object var17_68 = v7;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (DocumentQueueInsertException e) {
                        Object v8;
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "Document queue may have an error.", e);
                        } else {
                            this.monitor.fatal(e);
                            logger.log(e);
                            taskTracer.log(Level.FINE, "Document queue may have an error.", e);
                        }
                        Object var14_39 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v8 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v8 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v8 = null;
                        }
                        Object var17_69 = v8;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                        break block116;
                    }
                    catch (Throwable e) {
                        Object v9;
                        e.printStackTrace();
                        Throwable it = e.getCause();
                        if (it != null && it instanceof InterruptedException) {
                            taskTracer.log(Level.FINE, "An unexpected exception was thrown.", e);
                        } else {
                            this.monitor.fatal(e);
                            Message msg = new Message(e);
                            logger.log(Level.SEVERE, msg);
                            taskTracer.log(Level.FINE, "An unexpected exception was thrown.", e);
                        }
                        Object var14_40 = null;
                        try {
                            Throwable e2222222222;
                            try {
                                if (space != null) {
                                    CollectionControl.this.resourceMgr.closeResource(space);
                                }
                                if (adapter != null) {
                                    try {
                                        adapter.close();
                                    }
                                    catch (AdapterException e2222222222) {
                                        this.monitor.fatal(e2222222222);
                                        taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                    }
                                }
                                if (this.store != null) {
                                    this.store.close();
                                    this.store = null;
                                }
                                this.terminalizeCrawlerPlugin();
                                v9 = null;
                            }
                            catch (Throwable e2222222222) {
                                this.monitor.fatal(e2222222222);
                                taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                                v9 = null;
                            }
                        }
                        catch (Throwable throwable) {
                            v9 = null;
                        }
                        Object var17_70 = v9;
                        this.thread.setContextClassLoader(orgLoader);
                        this.monitor.end();
                        try {
                            this.session.setStatus(this.monitor.getStatus().toString());
                            this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                            this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                            this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                            this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                            this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                            this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                            System.out.println("crawling session info = " + this.session.printInfo());
                            this.session.close();
                        }
                        catch (MetadataStoreException e3) {
                            this.monitor.fatal(e3);
                            taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object v10;
                    Object var14_41 = null;
                    try {
                        Throwable e2222222222;
                        try {
                            if (space != null) {
                                CollectionControl.this.resourceMgr.closeResource(space);
                            }
                            if (adapter != null) {
                                try {
                                    adapter.close();
                                }
                                catch (AdapterException e2222222222) {
                                    this.monitor.fatal(e2222222222);
                                    taskTracer.log(Level.FINE, "An unexpected exception was thrown in crawler-adapter termination.", e2222222222);
                                }
                            }
                            if (this.store != null) {
                                this.store.close();
                                this.store = null;
                            }
                            this.terminalizeCrawlerPlugin();
                            v10 = null;
                        }
                        catch (Throwable e2222222222) {
                            this.monitor.fatal(e2222222222);
                            taskTracer.log(Level.FINE, "An unexpected exception was thrown in termination.", e2222222222);
                            v10 = null;
                        }
                    }
                    catch (Throwable throwable2) {
                        v10 = null;
                    }
                    Object var17_71 = v10;
                    this.thread.setContextClassLoader(orgLoader);
                    this.monitor.end();
                    try {
                        this.session.setStatus(this.monitor.getStatus().toString());
                        this.session.setNumOfCrawledDoc(this.monitor.getNumberOfCrawledRecords());
                        this.session.setNumOfUpdatedDoc(this.monitor.getNumberOfUpdatedRecords());
                        this.session.setNumOfInsertedDoc(this.monitor.getNumberOfInsertedRecords());
                        this.session.setNumOfDeletedDoc(this.monitor.getNumberOfDeletedRecords());
                        this.session.setNumOfErrorDoc(this.monitor.getNumberOfErrorRecords());
                        this.session.allDocumentsIsUpToDate(this.monitor.isAllDocumentsUpToDate());
                        System.out.println("crawling session info = " + this.session.printInfo());
                        this.session.close();
                    }
                    catch (MetadataStoreException e3) {
                        this.monitor.fatal(e3);
                        taskTracer.log(Level.FINE, "An unexpected internal error was thrown.", e3);
                    }
                    throw throwable;
                }
            }
            tracer.exiting(taskClassName, "run");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void exitContexts(Iterator<StoreContext> itr) throws DocumentQueueInsertException, MetadataStoreException {
            String methodName = "exitContexts";
            taskTracer.entering(taskClassName, "exitContexts");
            if (itr == null) {
                taskTracer.exiting(taskClassName, "exitContexts", -1);
                return;
            }
            int deleted = 0;
            while (itr.hasNext()) {
                Iterator<String> names;
                StoreContext sc = itr.next();
                if (CrawlMode.QUICK != this.mode && (names = sc.getRemovedDocumentNameIterator()) != null) {
                    while (names.hasNext()) {
                        CollectionControl.this.removeDocByURI(this.crawlspaceId, names.next());
                        ++deleted;
                        this.monitor.deleted();
                    }
                }
                this.interruptionLock.lock();
                try {
                    sc.exit();
                }
                finally {
                    this.interruptionLock.unlock();
                }
            }
            taskTracer.exiting(taskClassName, "exitContexts", deleted);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fetchContext(StoreContext cx, ContentSet contents) throws AdapterException, MetadataStoreException, DocumentQueueInsertException, InterruptedException {
            String methodName = "fetchContext";
            taskTracer.entering(taskClassName, "fetchContext");
            if (taskTracer.isLoggable(Level.FINEST)) {
                taskTracer.finest("Process the context. id=" + cx.getId());
            }
            cx.enter();
            while (!Thread.currentThread().isInterrupted() && contents.next()) {
                if (this.interval > 0L) {
                    Thread.sleep(this.interval);
                }
                String uri = contents.getURI();
                String securityUri = null;
                String docTitle = null;
                if (contents instanceof NotesContentSet) {
                    securityUri = ((NotesContentSet)contents).getSecurityURI();
                    docTitle = ((NotesContentSet)contents).getDocTitle();
                }
                if (contents instanceof ArchiveContentSet) {
                    securityUri = ((ArchiveContentSet)contents).getSecurityURI();
                }
                if (contents instanceof AFPContentSet) {
                    docTitle = ((AFPContentSet)contents).getDocTitle();
                }
                if (contents instanceof ContentSet.ShortenedNameAvailable) {
                    docTitle = ((ContentSet.ShortenedNameAvailable)((Object)contents)).getShortenedName();
                }
                long modified = contents.getLastModified();
                NotesDBPreCrawlInfo notesDBPreCrawlInfo = null;
                if (NotesConfigManager.isNotesSupported() && DataIOType.isExtNSF(uri)) {
                    String userIdPath = NotesConfigManager.getInstance().getUserIdPathInfo();
                    String userPass = null;
                    try {
                        userPass = NotesConfigManager.getInstance().getEncryptedUserPassWordInfo();
                    }
                    catch (Exception e) {
                        userPass = null;
                    }
                    Date lastSuccessfulFullCrawl = cx.getLastSuccessfulCrawledDate(HashUtil.hashCode64(uri));
                    Boolean onlyDBModifiedDate = false;
                    if (this.notesCrawlMode == NotesCrawlMode.VERY_QUICK || this.notesCrawlMode == NotesCrawlMode.NORMAL || lastSuccessfulFullCrawl == null) {
                        onlyDBModifiedDate = true;
                    }
                    notesDBPreCrawlInfo = new NotesDBPreCrawlInfo();
                    notesDBPreCrawlInfo.runTask(uri, userIdPath, userPass, onlyDBModifiedDate);
                }
                long hash = contents.getHash() + modified + this.configHash + this.lastForceCrawled;
                long uriHash = HashUtil.hashCode64(uri);
                Long oldHash = cx.getHash(uriHash);
                boolean hasSubNode = false;
                boolean nsfFailed = false;
                Integer returnCode = null;
                boolean quickModeCrawledNoteDoc = false;
                if (contents instanceof NotesContentSet) {
                    quickModeCrawledNoteDoc = ((NotesContentSet)contents).isCurrentForQuickMode();
                }
                boolean enforceCrawl = this.enforceUpdateDocs.contains(uri);
                if ((oldHash == null || hash != oldHash || enforceCrawl) && !quickModeCrawledNoteDoc) {
                    try {
                        Content content = contents.getContent();
                        try {
                            AFPContentSet afpSet = AFPContentSet.getAFPContentSet(uri, content, contents);
                            ArchiveContentSet arcSet = ArchiveContentSet.getArchiveContentSet(uri, securityUri, content);
                            if (arcSet != null) {
                                this.handleArchive(arcSet, cx, hash, uriHash, uri);
                                hasSubNode = true;
                            } else if (NotesConfigManager.isNotesSupported() && DataIOType.isExtNSF(uri)) {
                                NotesContentSet notesSet;
                                Date lastSuccessfulFullCrawl = cx.getLastSuccessfulCrawledDate(uriHash);
                                if (this.notesCrawlMode == NotesCrawlMode.NORMAL) {
                                    lastSuccessfulFullCrawl = null;
                                }
                                if ((notesSet = NotesContentSet.getNotesContentSet(notesDBPreCrawlInfo, uri, lastSuccessfulFullCrawl, content, CollectionControl.this.colId, this.notesCrawlMode)) != null) {
                                    try {
                                        this.handleNotesDB(notesSet, cx, hash, uriHash, uri);
                                    }
                                    finally {
                                        if (notesSet.didAllDocumentsGotCrawled()) {
                                            long safetyGap = 259200000L;
                                            long lastSuccessfulCrawlDate = notesSet.getLastDBModifiedDate() - 259200000L;
                                            this.interruptionLock.lock();
                                            try {
                                                cx.updateLastSuccessfulCrawledDate(uriHash, lastSuccessfulCrawlDate);
                                            }
                                            finally {
                                                this.interruptionLock.unlock();
                                            }
                                        }
                                    }
                                    hasSubNode = true;
                                    nsfFailed = false;
                                } else {
                                    nsfFailed = true;
                                    cx.setMode(CrawlMode.QUICK);
                                }
                            } else {
                                if (afpSet != null) {
                                    try {
                                        this.handleAFP(afpSet, cx, hash, uriHash, uri);
                                    }
                                    finally {
                                        afpSet.close();
                                    }
                                }
                                if (!AFPHandler.isAFPConversionSupported() || !uri.endsWith(AFPHandler.CONVERTED_AFP_URI_SUFFIX) || contents instanceof AFPContentSet) {
                                    if (content.hasSubContents()) {
                                        ContentSet subContents = content.getSubContents();
                                        StoreContext subcx = cx.subContext(uriHash, hash, uri);
                                        subcx.set(subContents);
                                        this.broaker.add(subcx);
                                        if (taskTracer.isLoggable(Level.FINEST)) {
                                            taskTracer.finest("Added sub context. id=" + subcx.getId() + " uri=" + uri + " urihash" + uriHash);
                                        }
                                        hasSubNode = true;
                                    }
                                    if (content.isActualContent()) {
                                        try {
                                            boolean insert;
                                            if (this.crawlerPlugin == null) {
                                                CollectionControl.this.sendDocument(this.crawlspaceId, uri, securityUri, docTitle, this.common, this.fieldMap, content, this.maxPageLength);
                                            } else {
                                                Content newContent = this.processDocumentInCrawlerPlugin(uri, content, this.fieldMap, this.common);
                                                FieldMap newFieldMap = this.fieldMap;
                                                CommonMetadata newCommonMeta = this.getNewCommonMetadataAfterPlugin(newContent);
                                                CollectionControl.this.sendDocument(this.crawlspaceId, uri, securityUri, docTitle, newCommonMeta, newFieldMap, newContent, this.maxPageLength);
                                            }
                                            boolean bl = insert = oldHash == null;
                                            if (insert) {
                                                this.monitor.inserted();
                                            } else {
                                                this.monitor.updated();
                                            }
                                            if (taskTracer.isLoggable(Level.FINEST)) {
                                                taskTracer.finest((insert ? "Inserted: " : "Updated: ") + uri);
                                            }
                                        }
                                        catch (DocumentStreamCreateException e) {
                                            this.monitor.error();
                                            this.interruptionLock.lock();
                                            try {
                                                cx.upsertError(uriHash, 500, false, uri);
                                            }
                                            finally {
                                                this.interruptionLock.unlock();
                                            }
                                            taskTracer.log(Level.FINE, "Cannot create streamed document for the document id " + uri, e);
                                        }
                                    }
                                }
                            }
                            this.maxLastModified = this.maxLastModified > modified ? this.maxLastModified : modified;
                        }
                        finally {
                            this.overwriteReturnCode(content);
                            returnCode = content.getReturnCode();
                            content.close();
                        }
                    }
                    catch (ItemNotFoundException e) {
                        this.monitor.error();
                        this.interruptionLock.lock();
                        try {
                            cx.upsertError(uriHash, 404, false, uri);
                        }
                        finally {
                            this.interruptionLock.unlock();
                        }
                        taskTracer.log(Level.FINE, "The document " + uri + " was not found.", e);
                    }
                } else {
                    boolean quickModeNewDocNewRecord = false;
                    if (quickModeCrawledNoteDoc) {
                        this.interruptionLock.lock();
                        try {
                            quickModeNewDocNewRecord = cx.isNewRecord(uriHash);
                        }
                        finally {
                            this.interruptionLock.unlock();
                        }
                    }
                    if (!quickModeNewDocNewRecord) {
                        int numChildren = cx.countChildren(uriHash);
                        this.monitor.unchanged(numChildren > 0 ? numChildren : 1);
                        if (taskTracer.isLoggable(Level.FINEST)) {
                            taskTracer.finest("Unchanged: " + uri + " # of descendant: " + numChildren);
                        }
                    }
                }
                this.interruptionLock.lock();
                try {
                    if (nsfFailed) continue;
                    if (contents instanceof AFPContentSet) {
                        if (returnCode == null) {
                            cx.getParent().upsert(uriHash, hash, uri);
                            continue;
                        }
                        cx.getParent().upsert(uriHash, returnCode, hash, uri);
                        continue;
                    }
                    if (oldHash == null && hasSubNode) continue;
                    if (returnCode == null) {
                        if (!quickModeCrawledNoteDoc) {
                            cx.upsert(uriHash, hash, uri);
                            continue;
                        }
                        cx.upsertOnlyOldRecords(uriHash, hash, uri);
                        continue;
                    }
                    if (!quickModeCrawledNoteDoc) {
                        cx.upsert(uriHash, returnCode, hash, uri);
                        continue;
                    }
                    cx.upsertOnlyOldRecords(uriHash, returnCode, hash, uri);
                }
                finally {
                    this.interruptionLock.unlock();
                }
            }
            taskTracer.exiting(taskClassName, "fetchContext", Thread.currentThread().isInterrupted());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleAFP(AFPContentSet set, StoreContext cx, long hash, long uriHash, String uri) throws MetadataStoreException, DocumentQueueInsertException, InterruptedException {
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.entering(taskClassName, "handleAFP", uri);
            }
            if (set != null) {
                StoreContext context = cx.subContext(uriHash, hash, uri);
                try {
                    this.fetchContext(context, set);
                }
                catch (AdapterException e) {
                    taskTracer.log(Level.FINE, "An exception was thrown while processing the archive entries for the document " + uri, e);
                }
                finally {
                    context.exit();
                }
            }
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.exiting(taskClassName, "handleArchive");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleArchive(ArchiveContentSet set, StoreContext cx, long hash, long uriHash, String uri) throws MetadataStoreException, DocumentQueueInsertException, InterruptedException, AdapterException {
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.entering(taskClassName, "handleArchive", uri);
            }
            if (set != null) {
                StoreContext context = cx.subContext(uriHash, hash, uri);
                try {
                    if (!uri.contains("ArchiveEntry=")) {
                        this.fetchContext(context, set);
                    }
                }
                catch (AdapterException e) {
                    taskTracer.log(Level.FINE, "An exception was thrown while processing the archive entries for the document " + uri, e);
                }
                finally {
                    set.close();
                    if (!this.isCanceled) {
                        ArrayList<StoreContext> storeContex = new ArrayList<StoreContext>();
                        storeContex.add(context);
                        this.exitContexts(storeContex.iterator());
                    }
                    context.exit();
                }
            }
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.exiting(taskClassName, "handleArchive");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleNotesDB(NotesContentSet set, StoreContext cx, long hash, long uriHash, String uri) throws MetadataStoreException, DocumentQueueInsertException, InterruptedException, AdapterException {
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.entering(taskClassName, "handleNotes", uri);
            }
            if (set != null) {
                StoreContext context = cx.subContext(uriHash, hash, uri);
                try {
                    if (!uri.contains("NotesEntry=")) {
                        this.fetchContext(context, set);
                    }
                }
                catch (AdapterException e) {
                    taskTracer.log(Level.FINE, "An exception was thrown while processing the notes entries for the document " + uri, e);
                }
                finally {
                    set.close();
                    if (this.notesCrawlMode == NotesCrawlMode.VERY_QUICK) {
                        context.setMode(CrawlMode.QUICK);
                    }
                    if (!this.isCanceled) {
                        ArrayList<StoreContext> storeContex = new ArrayList<StoreContext>();
                        storeContex.add(context);
                        this.exitContexts(storeContex.iterator());
                    }
                    context.exit();
                }
            }
            if (taskTracer.isLoggable(Level.FINER)) {
                taskTracer.exiting(taskClassName, "handleNotes");
            }
        }

        private void initializeCrawlerPlugin(CrawlerConfiguration crawlerConfig) throws UserPluginException {
            Map<String, Configuration> configMap = crawlerConfig.getConfigurations();
            String pluginClassName = null;
            String pluginClassPath = null;
            for (Map.Entry<String, Configuration> entry : configMap.entrySet()) {
                String key = entry.getKey();
                if (key.equals("es:crawler_plugin")) {
                    pluginClassName = entry.getValue().getString();
                    continue;
                }
                if (!key.equals("es:crawler_plugin_classpath")) continue;
                pluginClassPath = entry.getValue().getString();
            }
            if (pluginClassName != null && pluginClassPath != null && pluginClassName.length() != 0 && pluginClassPath.length() != 0) {
                this.crawlerPlugin = (CrawlerPlugin)CollectionControl.this.pluginManager.setClassInfo(pluginClassName, pluginClassPath);
                try {
                    this.crawlerPlugin.init();
                }
                catch (CrawlerPluginException cpe) {
                    Message msg = new Message("C3533E.CRWL_PLUGIN_FAILED_INIT_CALL");
                    msg.addArgument(pluginClassName);
                    throw new UserPluginException(msg, (Throwable)cpe);
                }
            }
        }

        private void terminalizeCrawlerPlugin() throws UserPluginException {
            if (this.crawlerPlugin != null) {
                try {
                    this.crawlerPlugin.term();
                }
                catch (CrawlerPluginException cpe) {
                    Message msg = new Message("C3535E.CRWL_PLUGIN_FAILED_TERM_CALL");
                    msg.addArgument(this.crawlerPlugin.getClass().getName());
                    throw new UserPluginException(msg, (Throwable)cpe);
                }
                this.crawlerPlugin = null;
            }
        }

        private Content processDocumentInCrawlerPlugin(String uri, Content content, FieldMap fldMap, CommonMetadata commonMetadata) throws AdapterException {
            SimpleContent newContent = null;
            try {
                CrawledData crawledData = CrawledDataFactory.toCrawledData(uri, content, fldMap, commonMetadata);
                CrawledData updatedData = this.crawlerPlugin.updateDocument(crawledData);
                fldMap.update(updatedData);
                newContent = SimpleBuilder.newContent();
                List<Metadata> metadataList = updatedData.getMetadataList();
                block9: for (Metadata mdata : metadataList) {
                    switch (mdata.getMetadataType()) {
                        case BOOLEAN: {
                            newContent.addField(mdata.getNativeName(), mdata.getBoolean());
                            continue block9;
                        }
                        case DATE: {
                            newContent.addField(mdata.getNativeName(), mdata.getDate());
                            continue block9;
                        }
                        case DOUBLE: {
                            newContent.addField(mdata.getNativeName(), mdata.getDouble());
                            continue block9;
                        }
                        case LONG: {
                            newContent.addField(mdata.getNativeName(), mdata.getLong());
                            continue block9;
                        }
                        case READER: 
                        case STRING: {
                            newContent.addField(mdata.getNativeName(), mdata.getString());
                            continue block9;
                        }
                    }
                }
                newContent.setAcl(content.getAcl());
                newContent.setDate(content.getDate());
            }
            catch (CrawlerPluginException cpe) {
                Message msg = new Message("C3534E.CRWL_PLUGIN_FAILED_UPDATEDOC_CALL");
                msg.addArgument(this.crawlerPlugin.getClass().getName());
                throw new AdapterException(msg, (Throwable)cpe);
            }
            return newContent;
        }

        private CommonMetadata getNewCommonMetadataAfterPlugin(Content newContent) throws AdapterException {
            return this.common;
        }

        private void overwriteReturnCode(Content content) throws AdapterException {
            int originalCode = content.getReturnCode();
            if (originalCode == 200) {
                ContentBody body = content.getBody();
                long bodyLength = 0L;
                if (body != null) {
                    bodyLength = body.getLength();
                }
                if (this.maxPageLength < bodyLength) {
                    content.setReturnCode(206);
                }
            }
        }

        static /* synthetic */ Thread access$000(CrawlSpaceTask x0) {
            return x0.thread;
        }

        static /* synthetic */ Lock access$100(CrawlSpaceTask x0) {
            return x0.interruptionLock;
        }

        static /* synthetic */ CrawlSpaceMonitor access$200(CrawlSpaceTask x0) {
            return x0.monitor;
        }
    }
}

