/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.crawler.util.loader.ExtClassLoader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

final class ClassLoaderManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String TEMP_CRAWLER_ID = "temp-crawler";
    private final ClassLoader parent;
    private final Map<String, CrawlerClassLoader> crawlerLoaders;

    ClassLoaderManager(ClassLoader parent) {
        this.parent = parent == null ? Thread.currentThread().getContextClassLoader() : parent;
        this.crawlerLoaders = new HashMap<String, CrawlerClassLoader>();
    }

    public CrawlerClassLoader newTempLoader() {
        return new CrawlerClassLoader(TEMP_CRAWLER_ID, this.parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlerClassLoader getLoader(String crawlerId) {
        if (crawlerId == null || crawlerId.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map<String, CrawlerClassLoader> map = this.crawlerLoaders;
        synchronized (map) {
            CrawlerClassLoader loader = this.crawlerLoaders.get(crawlerId);
            if (loader == null) {
                loader = new CrawlerClassLoader(crawlerId, this.parent);
                this.crawlerLoaders.put(crawlerId, loader);
            }
            return loader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoader(String crawlerId) {
        if (crawlerId == null || crawlerId.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map<String, CrawlerClassLoader> map = this.crawlerLoaders;
        synchronized (map) {
            this.crawlerLoaders.remove(crawlerId);
        }
    }

    public final class CrawlerClassLoader
    extends DynamicClassLoader {
        private final String crawlerId;

        private CrawlerClassLoader(String crawlerId, ClassLoader parent) {
            super(null, parent);
            this.crawlerId = crawlerId;
        }

        public void addClasspath(String classpath) {
            super.addClasspath(classpath);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getName()).append(':');
            builder.append(this.crawlerId).append(':');
            URL[] urls = super.getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    builder.append(urls[i]).append(',');
                }
            }
            return builder.toString();
        }
    }

    private abstract class DynamicClassLoader
    extends ExtClassLoader {
        private DynamicClassLoader(String path, ClassLoader parent) {
            super(path, parent);
        }

        public void addClasspath(String classpath) {
            super.addClasspath(classpath);
        }
    }
}

