/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntryControl;
import com.ibm.es.nuvo.crawler.admin.ScheduledTask;
import com.ibm.es.nuvo.crawler.config.listener.ScheduleEntryListener;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.scheduler.DaysOfWeekSchedule;
import com.ibm.es.nuvo.crawler.scheduler.IntervalSchedule;
import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BaseScheduleEntryControl
implements ScheduleEntryControl,
ScheduleEntryListener {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = BaseScheduleEntryControl.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private final BaseCrawlerManager manager;
    private ScheduleEntry config;
    private com.ibm.es.nuvo.crawler.scheduler.ScheduledTask task;
    private boolean enabled;
    private final List<StartCrawlCommand> targets;

    BaseScheduleEntryControl(BaseCrawlerManager manager, ScheduleEntry config) {
        String methodName = "<init>";
        Object[] params = new Object[]{config.getName()};
        tracer.entering(className, "<init>", params);
        this.manager = manager;
        this.enabled = true;
        this.task = null;
        this.targets = new ArrayList<StartCrawlCommand>();
        this.reconfigure(config);
        tracer.exiting(className, "<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconfigure(ScheduleEntry entry) {
        String methodName = "reconfigure";
        Object[] params = new Object[]{entry.getID(), entry.getName()};
        tracer.entering(className, "reconfigure", params);
        boolean needReschedule = BaseScheduleEntryControl.needReschedule(this.config, entry);
        boolean needRebuild = BaseScheduleEntryControl.needRebuildTargets(this.config, entry);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Re-schedule needed : " + needReschedule);
            tracer.log(Level.FINE, "Re-build targets needed : " + needRebuild);
        }
        if (this.task != null && needReschedule) {
            this.task.cancel();
            this.task = null;
        }
        this.config = entry;
        if (needRebuild) {
            List<StartCrawlCommand> list = this.targets;
            synchronized (list) {
                this.targets.clear();
                for (ScheduledTask t : this.config.getScheduledTasks()) {
                    if (t == null) continue;
                    if (tracer.isLoggable(Level.FINER)) {
                        tracer.log(Level.FINER, "Scheduled task - " + t.toString());
                    }
                    if (!t.isEnabled()) continue;
                    String crawlerId = t.getCrawlerID();
                    String crawlspaceId = t.getCrawlSpaceID();
                    CrawlMode mode = t.getCrawlMode();
                    this.targets.add(new StartCrawlCommand(crawlerId, crawlspaceId, mode));
                }
            }
        }
        if (this.task == null || needReschedule) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.log(Level.FINER, "Schedule entry - " + this.config.toString());
            }
            this.task = this.manager.schedule(new ScheduledStartCrawlCommand(), BaseScheduleEntryControl.convertSchedule(this.config));
        }
        tracer.exiting(className, "reconfigure");
    }

    private static Schedule convertSchedule(ScheduleEntry entry) {
        Date startTime = entry.getStartTime();
        switch (entry.getType()) {
            case INTERVAL: {
                int interval = entry.getInterval();
                switch (entry.getIntervalUnit()) {
                    case MINUTE: {
                        return new IntervalSchedule(startTime, interval, IntervalSchedule.IntervalUnit.MINUTE);
                    }
                    case HOUR: {
                        return new IntervalSchedule(startTime, interval, IntervalSchedule.IntervalUnit.HOUR);
                    }
                    case DAY: {
                        return new IntervalSchedule(startTime, interval, IntervalSchedule.IntervalUnit.DAY);
                    }
                    case WEEK: {
                        return new IntervalSchedule(startTime, interval, IntervalSchedule.IntervalUnit.WEEK);
                    }
                }
                break;
            }
            case FIXED_TIME: {
                EnumSet<DaysOfWeekSchedule.DayOfWeek> targetDays = EnumSet.noneOf(DaysOfWeekSchedule.DayOfWeek.class);
                for (ScheduleEntry.DayOfWeek day : entry.getDaysOfWeek()) {
                    switch (day) {
                        case SUNDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.SUNDAY);
                            break;
                        }
                        case MONDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.MONDAY);
                            break;
                        }
                        case TUESDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.TUESDAY);
                            break;
                        }
                        case WEDNESDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.WEDNESDAY);
                            break;
                        }
                        case THURSDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.THURSDAY);
                            break;
                        }
                        case FRIDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.FRIDAY);
                            break;
                        }
                        case SATURDAY: {
                            targetDays.add(DaysOfWeekSchedule.DayOfWeek.SATURDAY);
                        }
                    }
                }
                return new DaysOfWeekSchedule(startTime, targetDays);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getID() {
        return this.config.getID();
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public Date getNextScheduledTime() {
        return this.task.getScheduledTime();
    }

    @Override
    public boolean isScheduleEntryEnabled() {
        return this.enabled;
    }

    @Override
    public void setScheduleEntryEnabled(boolean enable) throws CrawlerControlException {
        this.enabled = enable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CrawlSpaceControl[] getTargetCrawlSpaces() throws CrawlerControlException {
        ArrayList<CrawlSpaceControl> crawlspaces = new ArrayList<CrawlSpaceControl>();
        List<StartCrawlCommand> list = this.targets;
        synchronized (list) {
            for (StartCrawlCommand target : this.targets) {
                if (target.crawlerId == null) continue;
                if (target.crawlspaceId == null) {
                    CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(target.crawlerId);
                    if (controls == null) continue;
                    crawlspaces.addAll(Arrays.asList(controls));
                    continue;
                }
                CrawlSpaceControl control = this.manager.getCrawlSpaceControl(target.crawlerId, target.crawlspaceId);
                if (control == null) continue;
                crawlspaces.add(control);
            }
        }
        return crawlspaces.toArray(new CrawlSpaceControl[0]);
    }

    boolean cancel() {
        if (this.task != null && this.task.cancel()) {
            this.task = null;
            return true;
        }
        return false;
    }

    @Override
    public void scheduleEntryUpdated(ScheduleEntry entry) {
        String methodName = "scheduleEntryUpdated";
        Object[] params = new Object[]{entry.getID()};
        tracer.entering(className, "scheduleEntryUpdated", params);
        this.reconfigure(entry);
        tracer.exiting(className, "scheduleEntryUpdated");
    }

    private static boolean needRebuildTargets(ScheduleEntry oldEntry, ScheduleEntry newEntry) {
        if (oldEntry == null || newEntry == null) {
            return oldEntry != null || newEntry != null;
        }
        List<ScheduledTask> oldTasks = oldEntry.getScheduledTasks();
        List<ScheduledTask> newTasks = newEntry.getScheduledTasks();
        if (oldTasks == null || newTasks == null) {
            return oldTasks != null || newTasks != null;
        }
        if (oldTasks.size() != newTasks.size()) {
            return true;
        }
        int l = oldTasks.size();
        for (int i = 0; i < l; ++i) {
            if (BaseScheduleEntryControl.taskEquals(oldTasks.get(i), newTasks.get(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean needReschedule(ScheduleEntry oldEntry, ScheduleEntry newEntry) {
        if (oldEntry == null) {
            return false;
        }
        if (newEntry == null) {
            return true;
        }
        if (oldEntry.getType() != newEntry.getType()) {
            return true;
        }
        if (!BaseScheduleEntryControl.dateEquals(oldEntry.getStartTime(), newEntry.getStartTime())) {
            return true;
        }
        switch (oldEntry.getType()) {
            case INTERVAL: {
                return oldEntry.getIntervalUnit() != newEntry.getIntervalUnit() || oldEntry.getInterval() != newEntry.getInterval();
            }
            case FIXED_TIME: {
                return !BaseScheduleEntryControl.daysEquals(oldEntry.getDaysOfWeek(), newEntry.getDaysOfWeek());
            }
        }
        return true;
    }

    private static boolean taskEquals(ScheduledTask left, ScheduledTask right) {
        if (left == null || right == null) {
            return left == null && right == null;
        }
        if (!BaseScheduleEntryControl.stringEquals(left.getCrawlerID(), right.getCrawlerID())) {
            return false;
        }
        if (!BaseScheduleEntryControl.stringEquals(left.getCrawlSpaceID(), right.getCrawlSpaceID())) {
            return false;
        }
        return left.getCrawlMode() == right.getCrawlMode();
    }

    private static boolean stringEquals(String left, String right) {
        if (left == null || right == null) {
            return left == null && right == null;
        }
        return left.equals(right);
    }

    private static boolean dateEquals(Date left, Date right) {
        if (left == null || right == null) {
            return left == null && right == null;
        }
        return left.getTime() == right.getTime();
    }

    private static boolean daysEquals(Set<ScheduleEntry.DayOfWeek> left, Set<ScheduleEntry.DayOfWeek> right) {
        if (left == null || right == null) {
            return left == null && right == null;
        }
        return left.contains((Object)ScheduleEntry.DayOfWeek.SUNDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.SUNDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.MONDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.MONDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.TUESDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.TUESDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.WEDNESDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.WEDNESDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.THURSDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.THURSDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.FRIDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.FRIDAY) && left.contains((Object)ScheduleEntry.DayOfWeek.SATURDAY) == right.contains((Object)ScheduleEntry.DayOfWeek.SATURDAY);
    }

    private final class ScheduledStartCrawlCommand
    implements Runnable {
        private ScheduledStartCrawlCommand() {
        }

        private void startCrawlForce(String crawlerId, String crawlspaceId, CrawlMode mode) {
            block16: {
                if (crawlerId == null) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINER, "Unexpected scheduled command - (null)");
                    }
                    return;
                }
                try {
                    CrawlerControl crawler = BaseScheduleEntryControl.this.manager.getCrawlerControl(crawlerId);
                    if (crawler == null) {
                        if (tracer.isLoggable(Level.FINE)) {
                            tracer.log(Level.FINER, "Specified crawler was not found - " + crawlerId);
                        }
                        return;
                    }
                    if (crawlspaceId == null) {
                        CrawlSpaceControl[] crawlspaces = BaseScheduleEntryControl.this.manager.getAvailableCrawlSpaceControls(crawlerId);
                        if (crawlspaces != null) {
                            for (int i = 0; i < crawlspaces.length; ++i) {
                                try {
                                    crawlspaces[i].startCrawl(mode);
                                    continue;
                                }
                                catch (CrawlerControlException e) {
                                    if (!logger.isLoggable(Level.SEVERE)) continue;
                                    logger.log(new ScheduledStartCrawlException(crawler.getName(), crawlspaces[i].getName(), mode, e));
                                }
                            }
                        }
                    } else {
                        CrawlSpaceControl crawlspace = BaseScheduleEntryControl.this.manager.getCrawlSpaceControl(crawlerId, crawlspaceId);
                        if (crawlspace != null) {
                            try {
                                crawlspace.startCrawl(mode);
                            }
                            catch (CrawlerControlException e) {
                                if (logger.isLoggable(Level.SEVERE)) {
                                    logger.log(new ScheduledStartCrawlException(crawler.getName(), crawlspace.getName(), mode, e));
                                }
                            }
                        }
                    }
                }
                catch (CrawlerControlException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block16;
                    logger.log(new ScheduledStartCrawlException(crawlerId, crawlspaceId, mode, e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (BaseScheduleEntryControl.this.enabled) {
                List list = BaseScheduleEntryControl.this.targets;
                synchronized (list) {
                    for (StartCrawlCommand command : BaseScheduleEntryControl.this.targets) {
                        this.startCrawlForce(command.crawlerId, command.crawlspaceId, command.mode);
                    }
                }
            }
        }
    }

    private static final class ScheduledStartCrawlException
    extends ExtendedException {
        private static final long serialVersionUID = 7598916240945870152L;

        public ScheduledStartCrawlException(String crawlerName, String crawlspaceName, CrawlMode mode, Throwable e) {
            super(new Message("C3011E.CRWL_GEN_CANNOT_START_SCHEDULED_CRAWL", crawlerName, crawlspaceName, mode.name()), e);
        }
    }

    private static final class StartCrawlCommand {
        private final String crawlerId;
        private final String crawlspaceId;
        private final CrawlMode mode;

        private StartCrawlCommand(String crawlerId, String crawlspaceId, CrawlMode mode) {
            this.crawlerId = crawlerId;
            this.crawlspaceId = crawlspaceId;
            this.mode = mode;
        }

        public String toString() {
            return this.crawlerId + '/' + this.crawlspaceId + '[' + (Object)((Object)this.mode) + ']';
        }
    }
}

