/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.adapter.URINormalizer;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawledDocumentStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntryControl;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.cdsr.DocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreManager;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfo;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfoManager;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.listener.CollectionListener;
import com.ibm.es.nuvo.crawler.config.manager.ConfigurationManagerImpl;
import com.ibm.es.nuvo.crawler.config.manager.CrawlerConfigurationManager;
import com.ibm.es.nuvo.crawler.config.serialize.CrawlerConfigurationSerializer;
import com.ibm.es.nuvo.crawler.config.serialize.CrawlerConfigurationSerializerFactory;
import com.ibm.es.nuvo.crawler.config.serialize.XMLSerializer;
import com.ibm.es.nuvo.crawler.runtime.AdapterService;
import com.ibm.es.nuvo.crawler.runtime.AdapterType;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlSpaceControl;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerControl;
import com.ibm.es.nuvo.crawler.runtime.BaseScheduleEntryControl;
import com.ibm.es.nuvo.crawler.runtime.ClassLoaderManager;
import com.ibm.es.nuvo.crawler.runtime.CollectionControl;
import com.ibm.es.nuvo.crawler.runtime.CrawlSpaceMonitor;
import com.ibm.es.nuvo.crawler.runtime.QueueWriter;
import com.ibm.es.nuvo.crawler.scheduler.Schedule;
import com.ibm.es.nuvo.crawler.scheduler.ScheduledTask;
import com.ibm.es.nuvo.crawler.scheduler.Scheduler;
import com.ibm.es.nuvo.crawler.scheduler.SingleThreadScheduler;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseCrawlerManager
implements CrawlerManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = BaseCrawlerManager.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    public static final String CONFIG_FILENAME = "crawler_config.xml";
    private final ClassLoaderManager loaderManager;
    private final String colId;
    private final AdapterService adapterService;
    private final CrawlerConfigurationManager configManager;
    private final CrawlerConfigurationSerializer configSerializer;
    private final CollectionControl collectionCtrl;
    private final Map<String, BaseCrawlerControl> controls;
    private final Map<String, BaseScheduleEntryControl> schedules;
    private final List<CrawlerTypeImpl> crawlerTypes;
    private final ThreadPoolExecutor cleanupThreads;
    private final MetadataStoreManager metadataManager;
    private final SessionInfoManager sessionManager;
    private final DocumentStatusManager documentStatusManager;
    private final Scheduler scheduler;

    public BaseCrawlerManager(String colId, boolean isACLNormalized, AdapterService adapterSvc, String crawlerConfigDir, String crawlerDataDir) throws ExtendedException {
        this(colId, isACLNormalized, adapterSvc, crawlerConfigDir, crawlerDataDir, QueueWriter.QueueType.SYSTEM);
    }

    public BaseCrawlerManager(String colId, boolean isACLNormalized, AdapterService adapterSvc, String crawlerConfigDir, String crawlerDataDir, QueueWriter.QueueType queueType) throws ExtendedException {
        this(colId, adapterSvc, crawlerConfigDir, crawlerDataDir, new QueueWriter(colId, isACLNormalized, queueType));
    }

    public BaseCrawlerManager(String colId, AdapterService adapterSvc, String crawlerConfigDir, String crawlerDataDir, QueueWriter writer) throws ExtendedException {
        String methodName = "<init>";
        tracer.entering(className, "<init>", new Object[]{colId, crawlerConfigDir, crawlerDataDir});
        this.colId = colId;
        this.loaderManager = new ClassLoaderManager(null);
        this.adapterService = adapterSvc;
        this.crawlerTypes = new ArrayList<CrawlerTypeImpl>();
        AdapterType[] adapterTypes = this.adapterService.getAdapterTypes();
        for (int i = 0; i < adapterTypes.length; ++i) {
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Crawler Adapter type - " + adapterTypes[i]);
            }
            this.crawlerTypes.add(new CrawlerTypeImpl(adapterTypes[i]));
        }
        this.metadataManager = new LuceneMetadataStoreManager(crawlerDataDir);
        try {
            this.sessionManager = this.metadataManager.getSessionInfoManager();
            this.documentStatusManager = this.metadataManager.getDocumentStatusManager();
        }
        catch (MetadataStoreException e) {
            throw new IllegalStateException(e);
        }
        List<String> knownspaceNames = this.sessionManager.getKnownCrawlSpaceNames();
        HashSet<String> knownspaces = new HashSet<String>();
        for (String knownspace : knownspaceNames) {
            knownspaces.add(knownspace);
        }
        if (tracer.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder().append("The list of known crawlspaces :");
            for (String knownspace : knownspaces) {
                buf.append(' ').append(knownspace);
            }
            tracer.fine(buf.toString());
        }
        this.scheduler = new SingleThreadScheduler("scheduler [col:" + colId + "]");
        this.cleanupThreads = new ThreadPoolExecutor(2, 10, 36000L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        this.collectionCtrl = new CollectionControl(colId, this.adapterService, this.metadataManager, writer);
        this.controls = new HashMap<String, BaseCrawlerControl>();
        this.configManager = new ConfigurationManagerImpl();
        File configFile = new File(crawlerConfigDir, CONFIG_FILENAME);
        Properties props = new Properties();
        props.put((Object)XMLSerializer.Property.FILEPATH, configFile.getAbsolutePath());
        this.configSerializer = CrawlerConfigurationSerializerFactory.getSerializer(CrawlerConfigurationSerializerFactory.Type.XML, props);
        this.configManager.loadConfiguration(this.configSerializer);
        ConfiguredCrawlerConfiguration[] configs = this.configManager.getCurrentPersistentConfigurations();
        if (configs != null) {
            for (int i = 0; i < configs.length; ++i) {
                this.upsertCrawlerControl(configs[i]);
            }
        }
        this.schedules = new HashMap<String, BaseScheduleEntryControl>();
        this.upsertScheduleEntryControl(this.configManager.getSchedule());
        for (BaseCrawlerControl control : this.controls.values()) {
            for (BaseCrawlSpaceControl crawlspace : control.getAvailableCrawlSpaceControls()) {
                knownspaces.remove(crawlspace.getID());
            }
        }
        this.cleanupThreads.execute(new RemoveCrawlSpaceTask(knownspaces));
        tracer.exiting(className, "<init>");
    }

    @Override
    public CrawlerType[] getAvailableCrawlerTypes() {
        return this.crawlerTypes.toArray(new CrawlerType[0]);
    }

    @Override
    public CrawlerType getCrawlerType(String name) {
        for (CrawlerTypeImpl type : this.crawlerTypes) {
            if (!type.getName().equals(name)) continue;
            return type;
        }
        return null;
    }

    @Override
    public CrawlSpaceControl[] getAvailableCrawlSpaceControls(String crawlerId) throws CrawlerControlException {
        BaseCrawlerControl crawler = this.controls.get(crawlerId);
        if (crawler != null) {
            return crawler.getAvailableCrawlSpaceControls().toArray(new CrawlSpaceControl[0]);
        }
        return null;
    }

    @Override
    public CrawlerControl[] getAvailableCrawlerControls() throws CrawlerControlException {
        return this.controls.values().toArray(new CrawlerControl[0]);
    }

    @Override
    public CrawlSpaceControl getCrawlSpaceControl(String crawlerId, String crawlspaceId) throws CrawlerControlException {
        BaseCrawlerControl crawler = this.controls.get(crawlerId);
        if (crawler != null) {
            return crawler.getCrawlSpaceControl(crawlspaceId);
        }
        return null;
    }

    @Override
    public CrawlerControl getCrawlerControl(String crawlerId) throws CrawlerControlException {
        return this.controls.get(crawlerId);
    }

    @Override
    public CrawlerConfiguration getCrawlerConfiguration(String crawlerId) throws CrawlerConfigurationException {
        String methodName = "getCrawlerConfiguration";
        tracer.entering(className, "getCrawlerConfiguration", crawlerId);
        tracer.exiting(className, "getCrawlerConfiguration");
        ConfiguredCrawlerConfiguration persistentConfig = this.configManager.getCurrentPersistentConfiguration(crawlerId);
        CrawlerType type = persistentConfig.getType();
        AdapterType adapterType = this.adapterService.getAdapterType(type.getName());
        if (adapterType == null) {
            // empty if block
        }
        ClassLoaderManager.CrawlerClassLoader loader = this.newTempClassLoader(adapterType);
        List<String> classpaths = persistentConfig.getClasspathEntries();
        if (classpaths != null) {
            for (String classpath : classpaths) {
                loader.addClasspath(classpath);
            }
        }
        Adapter adapter = null;
        try {
            adapter = this.adapterService.newAdapter(adapterType, (ClassLoader)loader);
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
        Thread.currentThread().setContextClassLoader(loader);
        return DiscoverableConfigurationFactory.getNewDiscoverableCrawlerConfiguration(adapter, persistentConfig);
    }

    @Override
    public CrawlerConfiguration newCrawlerConfiguration(String name, CrawlerType type, List<Configuration> configurations, List<String> classpaths) throws CrawlerConfigurationException {
        String methodName = "newCrawlerConfiguration";
        Object[] params = new Object[]{name, type, configurations};
        tracer.entering(className, "newCrawlerConfiguration", params);
        try {
            AdapterType adapterType = this.adapterService.getAdapterType(type.getName());
            if (adapterType == null) {
                // empty if block
            }
            ClassLoaderManager.CrawlerClassLoader loader = this.newTempClassLoader(adapterType);
            if (classpaths != null) {
                for (String classpath : classpaths) {
                    this.validateClasspath(classpath);
                    loader.addClasspath(classpath);
                }
            }
            Adapter adapter = this.adapterService.newAdapter(adapterType, (ClassLoader)loader);
            Thread.currentThread().setContextClassLoader(loader);
            DiscoverableCrawlerConfiguration crawler = DiscoverableConfigurationFactory.getNewDiscoverableCrawlerConfiguration(adapter, name, type, configurations, classpaths);
            tracer.exiting(className, "newCrawlerConfiguration");
            return crawler;
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCrawler(String crawlerId) throws CrawlerConfigurationException {
        String methodName = "removeCrawler";
        tracer.entering(className, "removeCrawler", crawlerId);
        if (crawlerId == null) {
            throw new NullPointerException();
        }
        HashSet<String> removeCrawlspaces = new HashSet<String>();
        BaseCrawlerControl crawler = this.controls.get(crawlerId);
        if (crawler == null) {
            return;
        }
        for (BaseCrawlSpaceControl crawlspace : crawler.getAvailableCrawlSpaceControls()) {
            boolean running = crawlspace.isRunning();
            if (tracer.isLoggable(Level.FINE)) {
                tracer.log(Level.FINE, "The crawlspace " + crawlspace.getName() + " [" + crawlspace.getID() + "] is " + (running ? "" : "not ") + "running");
            }
            if (running) {
                throw new CrawlerConfigurationException(new Message("C3529E.CRWL_GEN_CANNOT_DROP_CRAWLER", crawler.getName()));
            }
            crawlspace.dispose();
            removeCrawlspaces.add(crawlspace.getID());
        }
        this.dropCrawlSpacesTask(removeCrawlspaces);
        this.configManager.removeCrawlerConfiguration(crawlerId);
        this.configManager.persistConfiguration(this.configSerializer);
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Removed the crawler configuration for the crawlspace [" + crawlerId + "]");
        }
        crawler.shutdown();
        Map<String, BaseCrawlerControl> map = this.controls;
        synchronized (map) {
            this.controls.remove(crawlerId);
        }
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Removed the crawler controller for the crawler [" + crawlerId + "]");
        }
        tracer.exiting(className, "removeCrawler");
    }

    @Override
    public void submitCrawlerConfiguration(CrawlerConfiguration configuration) throws CrawlerConfigurationException {
        String methodName = "submitCrawlerConfiguration";
        Object[] params = new Object[]{configuration.getID(), configuration.getName()};
        tracer.entering(className, "submitCrawlerConfiguration", params);
        configuration.close();
        configuration = this.configManager.submitCrawlerConfiguration(configuration);
        this.configManager.persistConfiguration(this.configSerializer);
        this.upsertCrawlerControl(configuration);
        tracer.exiting(className, "submitCrawlerConfiguration");
    }

    @Override
    public void shutdown() {
        String methodName = "shutdown";
        tracer.entering(className, "shutdown");
        this.scheduler.shutdown();
        for (BaseCrawlerControl crawler : this.controls.values()) {
            crawler.shutdown();
        }
        this.cleanupThreads.shutdownNow();
        try {
            this.cleanupThreads.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            this.metadataManager.close();
        }
        catch (MetadataStoreException metadataStoreException) {
            // empty catch block
        }
        tracer.exiting(className, "shutdown");
    }

    public Adapter getAdapter(String crawlerType, String crawlerId) throws AdapterException {
        String methodName = "getAdapter";
        Object[] params = new Object[]{crawlerType, crawlerId};
        tracer.entering(className, "getAdapter", params);
        AdapterType adapterType = this.adapterService.getAdapterType(crawlerType);
        if (adapterType == null) {
            // empty if block
        }
        ClassLoaderManager.CrawlerClassLoader loader = this.getCrawlerClassLoader(crawlerType, crawlerId);
        Adapter adapter = this.adapterService.newAdapter(adapterType, (ClassLoader)loader);
        tracer.exiting(className, "getAdapter");
        return adapter;
    }

    final void enqueueTask(SpaceConfiguration config, ThreadPoolExecutor executor, CrawlSpaceMonitor monitor, SessionInfo session, CrawlMode mode, ClassLoader loader) {
        this.collectionCtrl.enqueueTask(config, executor, monitor, session, mode, loader);
    }

    final boolean cancelTask(SpaceConfiguration config, ThreadPoolExecutor executor) {
        return this.collectionCtrl.cancelTask(config, executor);
    }

    final ScheduledTask schedule(Runnable command, Schedule schedule) {
        return this.scheduler.schedule(command, schedule);
    }

    final SessionInfo openSession(String crawlspaceId) {
        return this.sessionManager.openSession(crawlspaceId);
    }

    final SessionInfo getLatestSessionHistory(String crawlspaceId) {
        SessionInfo session = null;
        for (SessionInfo history : this.sessionManager.getSessionHistory(crawlspaceId)) {
            if (!history.isFinished()) continue;
            session = session == null || session.getFinishTime() < history.getFinishTime() ? history : session;
        }
        return session;
    }

    final DocumentStatusManager getDocumentStatusManager() {
        return this.documentStatusManager;
    }

    final void dropCrawlSpacesTask(Set<String> crawlspacesToRemove) {
        this.cleanupThreads.execute(new RemoveCrawlSpaceTask(crawlspacesToRemove));
    }

    private ClassLoaderManager.CrawlerClassLoader newTempClassLoader(AdapterType type) {
        ClassLoaderManager.CrawlerClassLoader loader = this.loaderManager.newTempLoader();
        for (String classpath : type.getClasspaths()) {
            loader.addClasspath(classpath);
        }
        return loader;
    }

    final ClassLoaderManager.CrawlerClassLoader getCrawlerClassLoader(String typeId, String crawlerId) {
        ClassLoaderManager.CrawlerClassLoader loader = this.loaderManager.getLoader(crawlerId);
        AdapterType adapterType = this.adapterService.getAdapterType(typeId);
        if (adapterType != null) {
            for (String classpath : adapterType.getClasspaths()) {
                loader.addClasspath(classpath);
            }
        }
        return loader;
    }

    final URINormalizer getURINormalizer(String typeId, String crawlerId) {
        try {
            return this.getAdapter(typeId, crawlerId).createURINormalizer();
        }
        catch (AdapterException ignore) {
            return new URINormalizer(){

                public String normalize(String uri) {
                    return uri;
                }
            };
        }
    }

    final void removeCrawlerClassLoader(String crawlerId) {
        this.loaderManager.removeLoader(crawlerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upsertCrawlerControl(CrawlerConfiguration config) throws CrawlerConfigurationException {
        Map<String, BaseCrawlerControl> map = this.controls;
        synchronized (map) {
            String crawlerId = config.getID();
            BaseCrawlerControl crawler = this.controls.get(crawlerId);
            if (crawler == null) {
                crawler = new BaseCrawlerControl(this, config);
                this.configManager.addCrawlerConfigurationListner(crawler);
                this.controls.put(crawlerId, crawler);
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(Level.FINE, "Create the a crawler controller for the crawler [" + crawlerId + "]");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void upsertScheduleEntryControl(com.ibm.es.nuvo.crawler.admin.Schedule schedule) throws CrawlerConfigurationException {
        HashSet<String> scheduledEntries = new HashSet<String>(this.schedules.keySet());
        Map<String, BaseScheduleEntryControl> map = this.schedules;
        synchronized (map) {
            for (ScheduleEntry config : schedule.getEntries()) {
                if (!config.isEnabled()) continue;
                String entryId = config.getID();
                BaseScheduleEntryControl control = this.schedules.get(entryId);
                if (control == null) {
                    control = new BaseScheduleEntryControl(this, config);
                    this.configManager.addScheduleEntryListener(control);
                    this.schedules.put(entryId, control);
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Create the a schedule entry controller for the entry [" + entryId + "]");
                    }
                }
                scheduledEntries.remove(entryId);
            }
        }
        if (tracer.isLoggable(Level.FINE)) {
            StringBuilder buf = new StringBuilder().append("The list of scheduled entries to be removed :");
            for (String entry : scheduledEntries) {
                buf.append(' ').append(entry);
            }
            tracer.fine(buf.toString());
        }
        for (String entry : scheduledEntries) {
            BaseScheduleEntryControl control = this.schedules.remove(entry);
            if (control == null) continue;
            control.cancel();
            this.configManager.removeScheduleEntryListener(control);
        }
    }

    public CrawlerConfiguration getCurrentPersistentCrawlerConfiguration(String crawlerId) throws CrawlerConfigurationException {
        String methodName = "getCurrentPersistentCrawlerConfiguration";
        tracer.entering(className, "getCurrentPersistentCrawlerConfiguration", crawlerId);
        ConfiguredCrawlerConfiguration retVal = this.configManager.getCurrentPersistentConfiguration(crawlerId);
        tracer.exiting(className, "getCurrentPersistentCrawlerConfiguration");
        return retVal;
    }

    public CrawlerConfiguration[] getCurrentPersistentCrawlerConfigurations() throws CrawlerConfigurationException {
        String methodName = "getCurrentPersistentCrawlerConfigurations";
        tracer.entering(className, "getCurrentPersistentCrawlerConfigurations");
        CrawlerConfiguration[] retVal = this.configManager.getCurrentPersistentConfigurations();
        tracer.exiting(className, "getCurrentPersistentCrawlerConfigurations");
        return retVal;
    }

    public ConfiguredCrawlerConfiguration[] addCollectionCrawlerConfigurationListener(CollectionListener listener) throws CrawlerConfigurationException {
        return this.configManager.addCollectionListener(listener);
    }

    @Override
    public CrawledDocumentStatus getCrawledDocumentStatus(String uriPattern, int max) throws CrawlerControlException {
        final class CrawledDocumentStatusStack
        implements CrawledDocumentStatus {
            List<CrawledDocumentStatus> stack = new ArrayList<CrawledDocumentStatus>();
            CrawledDocumentStatus current = null;
            int maxCount;
            int count;

            public CrawledDocumentStatusStack(int maxCount) {
                this.maxCount = maxCount;
            }

            public int getCode() {
                return this.current.getCode();
            }

            public Date getDate() {
                return this.current.getDate();
            }

            public String getURI() {
                return this.current.getURI();
            }

            public boolean next() {
                if (0 < this.maxCount && this.count == this.maxCount) {
                    return false;
                }
                if (this.current == null) {
                    if (this.stack.size() == 0) {
                        return false;
                    }
                    this.current = this.stack.remove(0);
                    return this.next();
                }
                if (this.current.next()) {
                    ++this.count;
                    return true;
                }
                if (this.stack.size() > 0) {
                    this.current = this.stack.remove(0);
                    return this.next();
                }
                return false;
            }

            public void add(CrawledDocumentStatus cds) {
                this.stack.add(cds);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder(this.getURI());
                sb.append("\n").append(" Crawler status:").append(this.getCode());
                sb.append("\n").append(" Last crawled:").append(this.getDate());
                return sb.toString();
            }
        }
        CrawledDocumentStatusStack cdsStack = new CrawledDocumentStatusStack(max);
        CrawlerControl[] crawlerControls = this.getAvailableCrawlerControls();
        for (int i = 0; i < crawlerControls.length; ++i) {
            CrawlSpaceControl[] spaceControls = this.getAvailableCrawlSpaceControls(crawlerControls[i].getID());
            for (int j = 0; j < spaceControls.length; ++j) {
                cdsStack.add(spaceControls[j].getCrawledDocumentStatus(uriPattern, max));
            }
        }
        return cdsStack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClasspath(String classpath) throws CrawlerConfigurationException {
        StringTokenizer tokens = new StringTokenizer(classpath, File.pathSeparator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            File file = new File(token);
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                try {
                    ((InputStream)is).read();
                }
                finally {
                    ((InputStream)is).close();
                }
            }
            catch (FileNotFoundException e) {
                Message msg = new Message("C3530E.CRWL_GEN_INVALID_ADDITIONAL_CLASSPATH");
                msg.addArgument(token);
                throw new CrawlerConfigurationException(msg);
            }
            catch (IOException e) {
                Message msg = new Message("C3531E.CRWL_GEN_CANNOT_LOAD_ADDITIONAL_CLASSPATH");
                msg.addArgument(token);
                throw new CrawlerConfigurationException(msg);
            }
        }
    }

    @Override
    public com.ibm.es.nuvo.crawler.admin.Schedule getSchedule() {
        return this.configManager.getSchedule();
    }

    @Override
    public void submitSchedule(com.ibm.es.nuvo.crawler.admin.Schedule schedule) throws CrawlerConfigurationException {
        String methodName = "submitCrawlerConfiguration";
        tracer.entering(className, "submitCrawlerConfiguration");
        this.configManager.submitSchedule(schedule);
        this.configManager.persistConfiguration(this.configSerializer);
        this.upsertScheduleEntryControl(this.configManager.getSchedule());
        tracer.exiting(className, "submitCrawlerConfiguration");
    }

    @Override
    public ScheduleEntryControl[] getScheduleEntryControl() throws CrawlerControlException {
        return this.schedules.values().toArray(new ScheduleEntryControl[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CrawlerTypeImpl
    implements CrawlerType {
        private final AdapterType adapterType;
        private List<Configuration> required;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CrawlerTypeImpl(AdapterType adapterType) {
            String sourceName = this.getClass().getName();
            String methodName = "<init>";
            tracer.entering(sourceName, "<init>", adapterType);
            this.adapterType = adapterType;
            this.required = new ArrayList<Configuration>();
            Adapter adapter = null;
            Thread thread = Thread.currentThread();
            ClassLoader orgLoader = thread.getContextClassLoader();
            try {
                ClassLoaderManager.CrawlerClassLoader loader = BaseCrawlerManager.this.newTempClassLoader(this.adapterType);
                adapter = BaseCrawlerManager.this.adapterService.newAdapter(this.adapterType, (ClassLoader)loader);
                thread.setContextClassLoader(loader);
                Space root = adapter.getRootSpace();
                Iterator<ConfigurationElement> configs = root.getConfigurations().getElements();
                block16: while (configs.hasNext()) {
                    ConfigurationElement config = configs.next();
                    if (tracer.isLoggable(Level.FINEST)) {
                        tracer.finest("Required configuration - " + config);
                    }
                    EnumSet<Configuration.Attribute> options = SimpleConfigurationBuilder.optionBridge(config.getAttributes());
                    switch (config.getType()) {
                        case STRING: {
                            Configuration s = SimpleConfigurationBuilder.create(config.getName(), Configuration.Type.STRING, options);
                            s.setString(config.getString());
                            this.required.add(s);
                            continue block16;
                        }
                        case BOOLEAN: {
                            Configuration b = SimpleConfigurationBuilder.create(config.getName(), Configuration.Type.BOOLEAN, options);
                            b.setBoolean(config.getBoolean());
                            this.required.add(b);
                            continue block16;
                        }
                        case LONG: {
                            Configuration l = SimpleConfigurationBuilder.create(config.getName(), Configuration.Type.LONG, options);
                            l.setLong(config.getLong());
                            this.required.add(l);
                            continue block16;
                        }
                    }
                    throw new IllegalArgumentException();
                }
            }
            catch (AdapterException e) {
                Message msg = new Message("C3022W.CRWL_GEN_CANNOT_CREATE_REQ_CONFIGS", this.adapterType.getName());
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(new ExtendedException(msg, (Throwable)e));
                }
            }
            finally {
                if (adapter != null) {
                    try {
                        adapter.close();
                    }
                    catch (AdapterException ignore) {}
                }
                thread.setContextClassLoader(orgLoader);
            }
            tracer.exiting(sourceName, "<init>");
        }

        @Override
        public String getLabel() {
            return this.adapterType.getLabel();
        }

        @Override
        public String getName() {
            return this.adapterType.getName();
        }

        @Override
        public List<Configuration> getRequiredConfigurations() {
            String sourceName = this.getClass().getName();
            String methodName = "getRequiredConfigurations";
            tracer.entering(sourceName, "getRequiredConfigurations", this.adapterType);
            ArrayList<Configuration> cloned = new ArrayList<Configuration>();
            for (Configuration config : this.required) {
                cloned.add(ConfiguredConfigurationFactory.getConfiguredClone(config));
            }
            tracer.exiting(sourceName, "getRequiredConfigurations");
            return cloned;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RemoveCrawlSpaceTask
    implements Runnable {
        private final Set<String> crawlspaces;

        private RemoveCrawlSpaceTask(Set<String> crawlspaces) {
            this.crawlspaces = crawlspaces;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            String orgName = thread.getName();
            Thread.currentThread().setName(orgName + " - cleanup [col:" + BaseCrawlerManager.this.colId + "]");
            try {
                if (tracer.isLoggable(Level.FINE)) {
                    StringBuilder buf = new StringBuilder().append("The list of removed crawlspaces :");
                    for (String crawlspace : this.crawlspaces) {
                        buf.append(' ').append(crawlspace);
                    }
                    tracer.fine(buf.toString());
                }
                for (String crawlspace : this.crawlspaces) {
                    try {
                        BaseCrawlerManager.this.collectionCtrl.dropCrawlSpace(crawlspace);
                    }
                    catch (Throwable e) {
                        logger.log(new CannotRemoveCrawlSpaceException(crawlspace));
                    }
                }
            }
            finally {
                thread.setName(orgName);
            }
        }
    }

    private static final class CannotRemoveCrawlSpaceException
    extends CrawlerControlException {
        private static final long serialVersionUID = 5655053368951066998L;

        private CannotRemoveCrawlSpaceException(String crawlspaceId) {
            super(new Message("C3528E.CRWL_GEN_CANNOT_DROP_CRAWL_SPACE", crawlspaceId));
        }
    }
}

