/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfo;
import com.ibm.es.nuvo.crawler.config.listener.CrawlerConfigurationListener;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlSpaceControl;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.runtime.ClassLoaderManager;
import com.ibm.es.nuvo.crawler.runtime.CrawlSpaceMonitor;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BaseCrawlerControl
implements CrawlerControl,
CrawlerConfigurationListener {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = BaseCrawlerControl.class.getName();
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private CrawlerConfiguration config;
    private final Map<String, BaseCrawlSpaceControl> crawlspaces;
    private final ClassLoaderManager.CrawlerClassLoader loader;
    private final String crawlerId;
    private final BaseCrawlerManager manager;
    private final ThreadPoolExecutor executor;

    BaseCrawlerControl(BaseCrawlerManager manager, CrawlerConfiguration config) {
        String methodName = "<init>";
        Object[] params = new Object[]{config.getName()};
        tracer.entering(className, "<init>", params);
        this.manager = manager;
        this.crawlerId = config.getID();
        this.config = config;
        this.loader = manager.getCrawlerClassLoader(this.config.getType().getName(), this.config.getID());
        for (String classpath : this.config.getClasspathEntries()) {
            this.loader.addClasspath(classpath);
        }
        this.crawlspaces = new HashMap<String, BaseCrawlSpaceControl>();
        CrawlSpaceTraverser crawlSpaces = new CrawlSpaceTraverser(config);
        while (crawlSpaces.hasNext()) {
            SpaceConfiguration space = (SpaceConfiguration)crawlSpaces.next();
            this.crawlspaces.put(space.getID(), new BaseCrawlSpaceControl(manager, this, space));
        }
        int maxConnections = this.getMaxConnection(this.config.getConfigurations().get("es:max_connections"));
        if (tracer.isLoggable(Level.FINE)) {
            tracer.finer("max connections for " + this.crawlerId + " is " + maxConnections);
        }
        this.executor = new ThreadPoolExecutor(maxConnections, maxConnections, 36000L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        tracer.exiting(className, "<init>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void shutdown() {
        String methodName = "shutdown";
        tracer.entering(className, "shutdown");
        if (tracer.isLoggable(Level.FINER)) {
            tracer.log(Level.FINER, "shutdown '" + this.config.getName() + "' crawler [" + this.config.getID() + "]");
        }
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        tracer.exiting(className, "shutdown");
    }

    @Override
    public String getID() {
        return this.crawlerId;
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public String getType() {
        return this.config.getType().getName();
    }

    Collection<BaseCrawlSpaceControl> getAvailableCrawlSpaceControls() {
        return this.crawlspaces.values();
    }

    BaseCrawlSpaceControl getCrawlSpaceControl(String crawlspaceId) {
        return this.crawlspaces.get(crawlspaceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void enqueueTask(SpaceConfiguration space, CrawlSpaceMonitor monitor, SessionInfo session, CrawlMode mode) {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            this.manager.enqueueTask(space, this.executor, monitor, session, mode, this.loader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean cancelTask(SpaceConfiguration space) {
        ThreadPoolExecutor threadPoolExecutor = this.executor;
        synchronized (threadPoolExecutor) {
            boolean taskExists = this.manager.cancelTask(space, this.executor);
            if (this.executor.getQueue().size() == 0) {
                this.executor.getQueue().clear();
            }
            return taskExists;
        }
    }

    @Override
    public String getCrawlerID() {
        return this.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crawlerConfigurationUpdated(CrawlerConfiguration newConfig) {
        Map<String, BaseCrawlSpaceControl> map = this.crawlspaces;
        synchronized (map) {
            HashSet<String> removedCrawlspaces = new HashSet<String>(this.crawlspaces.keySet());
            CrawlSpaceTraverser crawlSpaces = new CrawlSpaceTraverser(newConfig);
            while (crawlSpaces.hasNext()) {
                SpaceConfiguration space = (SpaceConfiguration)crawlSpaces.next();
                String crawlspaceId = space.getID();
                BaseCrawlSpaceControl crawlspace = this.crawlspaces.get(crawlspaceId);
                if (crawlspace == null) {
                    crawlspace = new BaseCrawlSpaceControl(this.manager, this, space);
                    this.crawlspaces.put(crawlspaceId, crawlspace);
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Create the a crawlspace controller for the crawlspace [" + crawlspaceId + "]");
                    }
                } else {
                    crawlspace.reconfigure(space);
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(Level.FINE, "Reconfigure the existing crawlspace controller for the crawlspace [" + crawlspaceId + "]");
                    }
                }
                removedCrawlspaces.remove(crawlspaceId);
            }
            this.manager.dropCrawlSpacesTask(removedCrawlspaces);
            for (String removedCrawlspace : removedCrawlspaces) {
                this.crawlspaces.remove(removedCrawlspace);
            }
        }
        this.config = newConfig;
        if (tracer.isLoggable(Level.FINE)) {
            tracer.log(Level.FINE, "Reconfigure the existing crawler controller for the crawler [" + this.crawlerId + "]");
        }
    }

    private final int getMaxConnection(Configuration param) {
        return (int)(param == null || param.getType() != Configuration.Type.LONG || param.getLong() < 0L ? 10L : param.getLong());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrawlSpaceTraverser
    implements Iterator<SpaceConfiguration> {
        private final SpaceTraverser traverser;

        private CrawlSpaceTraverser(SpaceConfiguration spaceConfiguration) {
            this.traverser = new SpaceTraverser(spaceConfiguration);
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = false;
            SpaceConfiguration space = null;
            while ((hasNext = this.traverser.hasNext()) && !(space = this.traverser.next()).isSetAsCrawlSpace()) {
            }
            if (hasNext) {
                return space.isSetAsCrawlSpace();
            }
            return false;
        }

        @Override
        public SpaceConfiguration next() {
            return this.traverser.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpaceTraverser
    implements Iterator<SpaceConfiguration> {
        private final Stack<SpaceConfiguration> stack = new Stack();
        private SpaceConfiguration current;

        private SpaceTraverser(SpaceConfiguration spaceConfiguration) {
            this.pushSpacesRecursively(spaceConfiguration);
            this.current = null;
        }

        private void pushSpacesRecursively(SpaceConfiguration subSpace) {
            this.stack.push(subSpace);
            try {
                Iterator<SpaceConfiguration> children = subSpace.getSubSpaces();
                while (children.hasNext()) {
                    SpaceConfiguration child = children.next();
                    this.pushSpacesRecursively(child);
                }
            }
            catch (CrawlerConfigurationException e) {
                tracer.log(e);
            }
        }

        @Override
        public boolean hasNext() {
            if (!this.stack.empty()) {
                this.current = this.stack.pop();
                return true;
            }
            return false;
        }

        @Override
        public SpaceConfiguration next() {
            return this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

