/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.URINormalizer;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.crawler.admin.CrawledDocumentStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.cdsr.DocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfo;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerControl;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.crawler.runtime.CrawlSpaceMonitor;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;

final class BaseCrawlSpaceControl
implements CrawlSpaceControl {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = BaseCrawlSpaceControl.class.getName();
    private static final ExtendedLogger logger;
    private static final ExtendedLogger audit;
    private static final ExtendedLogger tracer;
    private final BaseCrawlerManager manager;
    private final BaseCrawlerControl parent;
    private SpaceConfiguration config;
    private SpaceConfiguration configPending;
    private final CrawlSpaceStatusImpl status;
    private String crawlerName;
    private String name;
    private String[] path;
    private final SessionInfo session;

    BaseCrawlSpaceControl(BaseCrawlerManager manager, BaseCrawlerControl parent, SpaceConfiguration config) {
        String methodName = "<init>";
        Object[] params = new Object[]{config.getCrawler().getName(), config.getName()};
        tracer.entering(className, "<init>", params);
        String crawlspaceId = config.getID();
        this.manager = manager;
        this.parent = parent;
        this.config = config;
        this.configPending = null;
        this.status = new CrawlSpaceStatusImpl();
        this.reconfigure(config);
        SessionInfo history = manager.getLatestSessionHistory(crawlspaceId);
        this.session = manager.openSession(crawlspaceId);
        StringBuilder pathStr = new StringBuilder();
        for (String p : this.path) {
            pathStr.append(p);
            pathStr.append("/");
        }
        pathStr.delete(pathStr.length() - 1, pathStr.length());
        this.session.setSpaceName(pathStr.toString());
        if (history != null) {
            this.status.mode = history.getCrawlMode() == null ? null : CrawlMode.valueOf(history.getCrawlMode());
            this.status.state = history.getStatus() == null ? CrawlSpaceStatus.Status.INIT : CrawlSpaceStatus.Status.valueOf(history.getStatus());
            this.status.startTime = new Date(history.getStartTime());
            this.status.endTime = new Date(history.getFinishTime());
            this.status.total = history.getNumOfTotalDoc();
            this.status.crawled = history.getNumOfCrawledDoc();
            this.status.inserted = history.getNumOfInsertedDoc();
            this.status.updated = history.getNumOfUpdatedDoc();
            this.status.deleted = history.getNumOfDeletedDoc();
            this.status.error = history.getNumOfErrorDoc();
            this.status.quick = this.status.mode == CrawlMode.QUICK;
            this.status.lastError = null;
            this.status.isAllDocumentsUpToDate = history.isAllDocumentsUpToDate();
            history.getMaxLastModified();
            this.session.setNumOfTotalDoc(this.status.total);
            this.session.setNumOfCrawledDoc(this.status.crawled);
            this.session.setNumOfInsertedDoc(this.status.inserted);
            this.session.setNumOfUpdatedDoc(this.status.updated);
            this.session.setNumOfDeletedDoc(this.status.deleted);
            this.session.setNumOfErrorDoc(this.status.error);
            this.session.setMaxLastModified(history.getMaxLastModified());
            this.session.setConfigHash(history.getConfigHash());
            this.session.allDocumentsIsUpToDate(this.status.isAllDocumentsUpToDate);
        }
        tracer.exiting(className, "<init>");
    }

    void dispose() {
        String methodName = "dispose";
        tracer.entering(className, "dispose");
        if (tracer.isLoggable(Level.FINER)) {
            StringBuilder pathStr = new StringBuilder();
            if (this.path != null) {
                for (String p : this.path) {
                    pathStr.append(p);
                    pathStr.append("/");
                }
                pathStr.delete(pathStr.length() - 1, pathStr.length());
            }
            tracer.log(Level.FINER, "dispose [" + pathStr + "]");
        }
        tracer.exiting(className, "dispose");
    }

    void reconfigure(SpaceConfiguration newConfig) {
        String methodName = "reconfigure";
        tracer.entering(className, "reconfigure", newConfig);
        if (!this.config.getID().equals(newConfig.getID())) {
            tracer.log(Level.FINE, "Invalid request for " + newConfig.getName());
            return;
        }
        this.dispose();
        if (this.config != null && this.status.isRunning()) {
            this.configPending = newConfig;
        } else {
            this.config = newConfig;
        }
        LinkedList<String> list = new LinkedList<String>();
        list.add(this.config.getName());
        for (ConfigurationItem p = this.config.getParent(); p != null; p = p.getParent()) {
            list.add(0, p.getName().intern());
        }
        this.path = list.toArray(new String[0]);
        this.name = this.config.getName();
        this.crawlerName = this.config.getCrawler().getName();
        tracer.exiting(className, "reconfigure");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isRunning() {
        CrawlSpaceStatusImpl crawlSpaceStatusImpl = this.status;
        synchronized (crawlSpaceStatusImpl) {
            return this.status.isRunning();
        }
    }

    public String getID() {
        return this.config.getID();
    }

    public String getName() {
        return this.name;
    }

    public String[] getPath() {
        return this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawlSpaceStatus getCrawlSpaceStatus() throws CrawlerControlException {
        CrawlSpaceStatusImpl crawlSpaceStatusImpl = this.status;
        synchronized (crawlSpaceStatusImpl) {
            CrawlSpaceStatusImpl s = this.status.clone();
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCrawl(CrawlMode mode) throws CrawlerControlException {
        block8: {
            String methodName = "startCrawl";
            Object[] params = new Object[]{this.crawlerName, this.name, mode};
            tracer.entering(className, "startCrawl", params);
            if (mode == null) {
                throw new NullPointerException();
            }
            try {
                CrawlSpaceStatusImpl crawlSpaceStatusImpl = this.status;
                synchronized (crawlSpaceStatusImpl) {
                    this.status.setReady(mode);
                    if (this.configPending != null) {
                        this.config = this.configPending;
                        this.configPending = null;
                    }
                    if (audit.isLoggable(Level.INFO)) {
                        audit.log(Level.INFO, "C3005I.CRWL_GEN_START_INFO", new Object[]{this.crawlerName, this.name, mode.name()});
                    }
                    this.parent.enqueueTask(this.config, this.status, this.session, mode);
                }
            }
            catch (AlreadyRunningException warn) {
                if (!audit.isLoggable(Level.INFO)) break block8;
                audit.log(Level.INFO, warn);
            }
        }
        tracer.exiting(className, "startCrawl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCrawl() throws CrawlerControlException {
        String methodName = "stopCrawl";
        Object[] params = new Object[]{this.crawlerName, this.name};
        tracer.entering(className, "stopCrawl", params);
        boolean taskExists = true;
        CrawlSpaceStatusImpl crawlSpaceStatusImpl = this.status;
        synchronized (crawlSpaceStatusImpl) {
            taskExists = this.parent.cancelTask(this.config);
        }
        if (audit.isLoggable(Level.INFO)) {
            audit.log(Level.INFO, "C3007I.CRWL_GEN_STOP_INFO", params);
        }
        tracer.exiting(className, "stopCrawl");
    }

    public CrawledDocumentStatus getCrawledDocumentStatus(String uriPattern, int max) throws CrawlerControlException {
        URINormalizer normalizer = this.manager.getURINormalizer(this.parent.getType(), this.parent.getID());
        String normalizedURI = normalizer.normalize(uriPattern);
        String crawlspaceId = this.config.getID();
        DocumentStatusManager documentStatusManager = this.manager.getDocumentStatusManager();
        try {
            return documentStatusManager.getCrawledDocumentStatus(crawlspaceId, normalizedURI, max);
        }
        catch (ExtendedException e) {
            throw new CrawlerControlException(new Message(""), (Throwable)e);
        }
    }

    static {
        audit = logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
        tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    }

    private final class CrawlSpaceStatusImpl
    implements CrawlSpaceMonitor,
    Cloneable {
        private Date startTime = null;
        private Date endTime = null;
        private CrawlSpaceStatus.Status state = CrawlSpaceStatus.Status.INIT;
        private CrawlMode mode = null;
        private long total = 0L;
        private long crawled = 0L;
        private long updated = 0L;
        private long inserted = 0L;
        private long deleted = 0L;
        private long error = 0L;
        private long excluded = 0L;
        private Throwable lastError = null;
        private boolean quick = false;
        private boolean isAllDocumentsUpToDate = true;

        private CrawlSpaceStatusImpl() {
        }

        public CrawlSpaceStatusImpl clone() {
            try {
                return (CrawlSpaceStatusImpl)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError(e.getMessage());
            }
        }

        public CrawlSpaceStatus.Status getStatus() {
            return this.state;
        }

        public CrawlMode getMode() {
            return this.mode;
        }

        public long getNumberOfCrawledRecords() {
            return this.crawled;
        }

        public long getNumberOfDeletedRecords() {
            return this.deleted;
        }

        public long getNumberOfErrorRecords() {
            return this.error;
        }

        public long getNumberOfInsertedRecords() {
            return this.inserted;
        }

        public long getNumberOfUpdatedRecords() {
            return this.updated;
        }

        public long getTotalTime() {
            if (this.startTime != null) {
                switch (this.state) {
                    case COMPLETED: 
                    case ERROR: {
                        return this.endTime.getTime() - this.startTime.getTime();
                    }
                    case CRAWLING: 
                    case PAUSED: 
                    case WAITING: {
                        return System.currentTimeMillis() - this.startTime.getTime();
                    }
                }
            }
            return -1L;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        public long getNumberOfTotalRecords() {
            return this.total;
        }

        private boolean isRunning() {
            switch (this.state) {
                case CRAWLING: 
                case PAUSED: 
                case WAITING: {
                    return true;
                }
            }
            return false;
        }

        private void setReady(CrawlMode m) throws AlreadyRunningException {
            if (this.isRunning()) {
                throw new AlreadyRunningException(BaseCrawlSpaceControl.this.crawlerName, BaseCrawlSpaceControl.this.name);
            }
            this.state = CrawlSpaceStatus.Status.WAITING;
            this.mode = m;
            this.startTime = null;
            this.endTime = null;
            this.lastError = null;
        }

        public void start(CrawlMode m, Object ... options) {
            this.startTime = new Date(System.currentTimeMillis());
            this.state = CrawlSpaceStatus.Status.CRAWLING;
            this.mode = m;
            this.quick = this.mode == CrawlMode.QUICK;
            this.crawled = 0L;
            this.inserted = 0L;
            this.updated = 0L;
            this.deleted = 0L;
            this.excluded = 0L;
            this.error = 0L;
            if (options != null && options.length > 0) {
                this.isAllDocumentsUpToDate = (Boolean)options[0];
            }
        }

        public void end() {
            if (this.state != CrawlSpaceStatus.Status.ERROR) {
                this.state = CrawlSpaceStatus.Status.COMPLETED;
            }
            this.endTime = new Date(System.currentTimeMillis());
        }

        public void comp() {
            this.total = this.quick ? this.total + this.inserted : this.crawled;
            this.isAllDocumentsUpToDate = true;
        }

        public void fatal(Throwable cause) {
            if (this.state != CrawlSpaceStatus.Status.COMPLETED) {
                this.lastError = cause;
                this.state = CrawlSpaceStatus.Status.ERROR;
            }
        }

        public void unchanged() {
            ++this.crawled;
        }

        public void unchanged(int num) {
            this.crawled += (long)num;
        }

        public void inserted() {
            ++this.crawled;
            ++this.inserted;
        }

        public void updated() {
            ++this.crawled;
            ++this.updated;
        }

        public void excluded() {
            ++this.excluded;
        }

        public void deleted() {
            ++this.deleted;
        }

        public void error() {
            ++this.error;
        }

        public boolean isAllDocumentsUpToDate() {
            return this.isAllDocumentsUpToDate;
        }

        public void cancel() {
            this.startTime = new Date(System.currentTimeMillis());
            this.state = CrawlSpaceStatus.Status.COMPLETED;
            this.mode = CrawlMode.NORMAL;
            this.quick = false;
            this.crawled = 0L;
            this.inserted = 0L;
            this.updated = 0L;
            this.deleted = 0L;
            this.excluded = 0L;
            this.error = 0L;
            this.endTime = this.startTime;
        }
    }

    private static final class AlreadyRunningException
    extends CrawlerControlException {
        private static final long serialVersionUID = -4390733438237823454L;

        private AlreadyRunningException(String crawlerName, String crawlspaceName) {
            super(new Message("C3006I.CRWL_GEN_ALREADY_STARTED_INFO", crawlerName, crawlspaceName));
        }
    }
}

