/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.runtime.AbstractAdapterService;
import com.ibm.es.nuvo.crawler.runtime.CollectionControl;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class BaseAdapterService
extends AbstractAdapterService {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CLASS_NAME = CollectionControl.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + CLASS_NAME);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CLASS_NAME);
    private static final String PLUGIN_CONFIG_XML = "plugin.xml";

    public BaseAdapterService(File adapterDir) throws ExtendedException {
        String sourceName = this.getClass().getName();
        String methodName = "<init>";
        tracer.entering(sourceName, "<init>", adapterDir);
        if (!adapterDir.exists() || !adapterDir.isDirectory()) {
            ExtendedException e = new ExtendedException(new Message("C3521E.CRWL_GEN_CANNOT_INIT_ADAPTER_MGR", adapterDir.getAbsolutePath()));
            logger.log(e);
            throw e;
        }
        File[] pluginJars = adapterDir.listFiles(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".jar");
            }
        });
        for (int i = 0; i < pluginJars.length; ++i) {
            try {
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.fine("Loading the crawler plugin in " + pluginJars[i]);
                }
                if (pluginJars[i].isDirectory()) {
                    File config = new File(pluginJars[i], PLUGIN_CONFIG_XML);
                    if (config.exists() && config.isFile() && config.canRead()) {
                        CrawlerAdapterReader reader = new CrawlerAdapterReader(new FileInputStream(config));
                        this.addAdapterClasspath(reader.id, pluginJars[i].getCanonicalPath());
                        continue;
                    }
                    if (!tracer.isLoggable(Level.FINE)) continue;
                    tracer.fine(pluginJars[i] + " directory does not have " + PLUGIN_CONFIG_XML + " entry.");
                    continue;
                }
                JarFile plugin = new JarFile(pluginJars[i]);
                ZipEntry entry = plugin.getEntry(PLUGIN_CONFIG_XML);
                if (entry != null) {
                    CrawlerAdapterReader reader = new CrawlerAdapterReader(plugin.getInputStream(entry));
                    this.addAdapterClasspath(reader.id, pluginJars[i].getCanonicalPath());
                    continue;
                }
                if (!tracer.isLoggable(Level.FINE)) continue;
                tracer.fine(pluginJars[i] + " file does not have " + PLUGIN_CONFIG_XML + " entry.");
                continue;
            }
            catch (IOException e) {
                Message msg = new Message("C3522W.CRWL_GEN_CANNOT_INIT_ADAPTER_JAR", e);
                logger.log(Level.WARNING, msg);
            }
        }
        tracer.exiting(sourceName, "<init>");
    }

    private class CrawlerAdapterReader
    extends DefaultHandler {
        private static final int P = 3;
        private static final int CP = 4;
        private static final int PE = 5;
        private static final String ELT_CRAWLERPLUGIN = "crawler-adapter";
        private static final String ELT_CLASSPATH = "classpath";
        private static final String ELT_PATH = "path";
        private static final String ELT_PATHELT = "path-element";
        private static final String ATTR_ID = "id";
        private static final String ATTR_NAME = "name";
        private static final String ATTR_VERSION = "version";
        private static final String ATTR_CLASS = "class";
        private StringBuilder value = new StringBuilder();
        private int state;
        private String id;
        private String name;
        private String version;
        private String className;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CrawlerAdapterReader(InputStream in) {
            BufferedInputStream input = null;
            try {
                input = new BufferedInputStream(in);
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputStream)input, (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (input != null) {
                    try {
                        ((InputStream)input).close();
                    }
                    catch (IOException ignore) {}
                }
            }
        }

        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            String n = qname;
            if (ELT_CRAWLERPLUGIN.equals(n)) {
                this.name = atts.getValue(ATTR_NAME);
                this.id = atts.getValue(ATTR_ID);
                this.version = atts.getValue(ATTR_VERSION);
                this.className = atts.getValue(ATTR_CLASS);
            } else if (ELT_PATH.equals(n)) {
                this.state = 3;
            } else if (ELT_CLASSPATH.equals(n)) {
                this.state = 4;
            } else if (ELT_PATHELT.equals(n)) {
                this.state = 5;
                this.value.setLength(0);
            }
        }

        public void endElement(String uri, String localName, String qname) throws SAXException {
            String n = qname;
            if (ELT_CRAWLERPLUGIN.equals(n)) {
                if (this.assertString(this.id) && this.assertString(this.name) && this.assertString(this.className)) {
                    BaseAdapterService.this.addAdapterType(this.id, this.name, this.version, this.className);
                }
            } else if (ELT_PATH.equals(n) || ELT_CLASSPATH.equals(n) || ELT_PATHELT.equals(n)) {
                // empty if block
            }
            this.state = 0;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 3: {
                    this.value.append(ch, start, length);
                    break;
                }
            }
        }

        private boolean assertString(String str) {
            return str != null && str.length() > 0;
        }
    }
}

