/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Acl;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntry;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveEntryFilter;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFile;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFileDescriptor;
import com.ibm.es.nuvo.crawler.util.archive.ArchiveFileRegistory;
import com.ibm.es.nuvo.crawler.util.archive.FilteredArchiveFile;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.logging.Level;

public class ArchiveContentSet
extends ContentSet
implements ArchiveEntryFilter {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = ArchiveContentSet.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    public static final String ATTR_ARCHIVE_ENTRY = "ArchiveEntry=";
    private static final ArchiveFileRegistory registory = new ArchiveFileRegistory();
    private FilteredArchiveFile file;
    private ArchiveEntry entry;
    private final String uri;
    private final String securityUri;
    private final String parentDir;
    private final Content parent;

    public static ArchiveContentSet getArchiveContentSet(String uri, String securityUri, Content content) {
        block6: {
            if (content.hasBody()) {
                try {
                    ContentBody body = content.getBody();
                    String mimetype = body.getMimetype();
                    ArchiveFileDescriptor descriptor = registory.getArchiveFileDescriptor(uri, mimetype);
                    if (descriptor == null) {
                        return null;
                    }
                    return new ArchiveContentSet(descriptor.createArchiveFile(uri, mimetype, body.getStream()), uri, securityUri, content);
                }
                catch (AdapterException e) {
                    if (tracer.isLoggable(Level.FINE)) {
                        tracer.log(new IllegalArchiveFormatException(uri, e));
                    }
                }
                catch (IOException e) {
                    if (!tracer.isLoggable(Level.FINE)) break block6;
                    tracer.log(new IllegalArchiveFormatException(uri, e));
                }
            }
        }
        return null;
    }

    private ArchiveContentSet(ArchiveFile file, String uri, String securityUri, Content parent) {
        this.file = new FilteredArchiveFile(file);
        this.file.addFilter(this);
        this.uri = uri;
        this.securityUri = this.uri.startsWith("Notes://") ? securityUri : this.uri;
        this.parentDir = FSURIUtil.getFileObject(this.securityUri).getParentFile().getAbsolutePath();
        this.parent = parent;
    }

    public Content getContent() throws AdapterException {
        SimpleContent content = SimpleBuilder.newContent();
        Acl acl = this.parent.getAcl();
        if (acl != null) {
            content.setAcl(acl.clone());
        }
        try {
            content.createBody(this.file.getInputStream(), this.entry.getName());
            content.addField("filename", this.entry.getName());
            content.addField("dirname", this.parentDir);
        }
        catch (IOException e) {
            this.close();
            throw new AdapterException(e);
        }
        return content;
    }

    public long getLastModified() {
        return this.entry.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws AdapterException {
        if (this.file != null) {
            try {
                this.file.close();
            }
            catch (IOException ignored) {
                if (logger.isLoggable(Level.WARNING)) {
                    Message msg = new Message("C3513W.CFW_ARC_ENTRY_CLOSE_WARN", this.uri);
                    logger.log(Level.WARNING, msg);
                }
            }
            finally {
                this.file = null;
            }
        }
    }

    public String getURI() {
        StringBuilder builder = new StringBuilder(this.uri.length() * 2);
        builder.append(this.uri);
        builder.append(this.uri.lastIndexOf(63) != -1 ? (char)'&' : '?');
        builder.append(ATTR_ARCHIVE_ENTRY);
        String name = this.entry.getName();
        try {
            builder.append(URLEncoder.encode(name, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            builder.append(name);
        }
        return builder.toString();
    }

    public String getSecurityURI() {
        return this.securityUri;
    }

    public boolean next() throws AdapterException {
        if (this.file != null) {
            try {
                this.entry = this.file.getNextEntry();
            }
            catch (IOException e) {
                this.close();
                if (tracer.isLoggable(Level.FINE)) {
                    tracer.log(new MalformedArchiveEntryException(this.uri, this.entry != null ? this.entry.getName() : "<first>", e));
                }
                this.entry = null;
            }
            return this.entry != null;
        }
        return false;
    }

    public boolean accept(ArchiveEntry e) {
        boolean accept;
        boolean bl = accept = !e.isDirectory();
        if (accept) {
            String name = e.getName();
            if (accept &= true) {
                accept &= registory.getArchiveFileDescriptor(name, null) == null;
            }
        }
        return accept;
    }

    private static final class MalformedArchiveEntryException
    extends ExtendedException {
        private static final long serialVersionUID = 7707611526845981081L;

        private MalformedArchiveEntryException(String uri, String entryName, Throwable cause) {
            super(new Message("C3512W.CFW_ARC_ENTRY_EXTRACT_WARN", uri, entryName), cause);
        }
    }

    private static final class IllegalArchiveFormatException
    extends ExtendedException {
        private static final long serialVersionUID = -8434956680956584960L;

        private IllegalArchiveFormatException(String uri, Throwable cause) {
            super(new Message("C3511W.CFW_ARC_EXTRACT_WARN", uri), cause);
        }
    }
}

