/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.runtime.AdapterService;
import com.ibm.es.nuvo.crawler.runtime.AdapterType;
import com.ibm.es.nuvo.crawler.runtime.AdapterTypeNotExistException;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

class AbstractAdapterService
implements AdapterService {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String CLASS_NAME = AbstractAdapterService.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + CLASS_NAME);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + CLASS_NAME);
    private final Map<String, AdapterTypeImpl> adapterTypes = new TreeMap<String, AdapterTypeImpl>();

    protected AbstractAdapterService() {
    }

    protected void addAdapterType(String name, String label, String version, String adapterClassName) {
        this.adapterTypes.put(name, new AdapterTypeImpl(name, label, version, adapterClassName));
    }

    protected void addAdapterClasspath(String name, String classpath) {
        AdapterTypeImpl adapterType = this.adapterTypes.get(name);
        if (adapterType != null) {
            adapterType.classpath.add(classpath);
        }
    }

    public AdapterType[] getAdapterTypes() {
        return this.adapterTypes.values().toArray(new AdapterType[0]);
    }

    public Adapter newAdapter(AdapterType type, ClassLoader loader) throws AdapterException {
        String methodName = "newAdapter";
        tracer.entering(CLASS_NAME, "newAdapter", type);
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Try to create an adapter instance of [" + type + "] with the classloader [" + loader + "]");
        }
        try {
            if (type != null) {
                AdapterTypeImpl adapterType = this.adapterTypes.get(type.getName());
                try {
                    Adapter adapter = (Adapter)Class.forName(adapterType.className, true, loader).newInstance();
                    tracer.exiting(CLASS_NAME, "newAdapter");
                    return adapter;
                }
                catch (ClassNotFoundException e) {
                    throw new AdapterException(e);
                }
                catch (InstantiationException e) {
                    throw new AdapterException(e);
                }
                catch (IllegalAccessException e) {
                    throw new AdapterException(e);
                }
            }
            throw new NoAdapterTypeSpecifiedException();
        }
        catch (AdapterException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(new AdapterTypeNotExistException(type != null ? type.getName() : "", (Throwable)e));
            }
            throw e;
        }
    }

    public AdapterType getAdapterType(String typeId) {
        if (typeId == null) {
            return null;
        }
        return this.adapterTypes.get(typeId);
    }

    public Adapter newAdapter(String typeId, ClassLoader loader) throws AdapterException {
        return this.newAdapter(this.adapterTypes.get(typeId), loader);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AdapterTypeImpl
    implements AdapterType {
        private final String name;
        private final String label;
        private final String version;
        private final String className;
        private final List<String> classpath;

        private AdapterTypeImpl(String name, String label, String version, String className) {
            this.name = name;
            this.label = label;
            this.version = version;
            this.className = className;
            this.classpath = new ArrayList<String>();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public List<String> getClasspaths() {
            return this.classpath;
        }

        public String getClassName() {
            return this.className;
        }

        public String toString() {
            return this.label + " [" + this.name + "]";
        }
    }

    private static final class NoAdapterTypeSpecifiedException
    extends AdapterException {
        private static final long serialVersionUID = -1674713262380680504L;
        private static final String MSG_CODE = "C3527E.CRWL_ADP_NO_ADAPTER_TYPE";

        private NoAdapterTypeSpecifiedException() {
            super(new Message(MSG_CODE));
        }
    }
}

