/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class AFPHandler {
    private static AFPHandler afpHandler = null;
    public static String CONVERTED_AFP_URI_SUFFIX = "_AFP.pdf";
    public static String AFP_EXTENSION = ".AFP";
    private static String tempAFPFileName = "TEMPAFP";
    private static String tempPDFFileName = "TEMPPDF";
    private long cpyRecovery = 1000L;
    private String tempAFPRelativePath = null;
    private File tempAFPDir = null;
    private File tempAFPFile = null;
    private File convertedPDFFile = null;
    private InputStream convertedPDFIS = null;
    private static String fldwprtExePath;
    private static String pdf995IniPath;
    private static String pdf995SyncIniPath;
    private static String enableAFPConversion;

    public static boolean isAFP(String uri) {
        String ucUri = uri.toUpperCase();
        return ucUri.endsWith(AFP_EXTENSION);
    }

    public static AFPHandler getAFPHandler() throws AFPConversionNotSupportedException {
        if (enableAFPConversion == null || fldwprtExePath == null || pdf995IniPath == null || pdf995SyncIniPath == null) {
            throw new AFPConversionNotSupportedException();
        }
        if (enableAFPConversion.equals("true")) {
            if (afpHandler == null) {
                afpHandler = new AFPHandler();
            }
            return afpHandler;
        }
        throw new AFPConversionNotSupportedException();
    }

    private AFPHandler() {
    }

    public static String convertAFPURIToPDFUri(String afpUri) {
        String pdfUri = afpUri.substring(0, afpUri.length() - 4);
        pdfUri = pdfUri + CONVERTED_AFP_URI_SUFFIX;
        return pdfUri;
    }

    public static String reconstructOriginalAFPUri(String convertedPDFUri) {
        if (!convertedPDFUri.endsWith(CONVERTED_AFP_URI_SUFFIX)) {
            return null;
        }
        String afpUri = convertedPDFUri.substring(0, convertedPDFUri.length() - 8);
        afpUri = afpUri + AFP_EXTENSION;
        return afpUri;
    }

    public synchronized void converAFPISToPDF(InputStream afpIS, String afpFileName, String pdfDestDir, boolean pdfIsTemp) throws IOException, InterruptedException, AFPConversionException {
        this.createTempAFP(afpIS);
        if (pdfIsTemp) {
            this.convertToPDF(pdfDestDir, tempPDFFileName);
        } else {
            this.convertToPDF(pdfDestDir, afpFileName);
        }
        this.tempAFPFile.delete();
        this.tempAFPDir.delete();
        this.convertedPDFIS = this.createIndependentISFromFile(this.convertedPDFFile);
        if (pdfIsTemp) {
            this.convertedPDFFile.delete();
        }
    }

    public InputStream getConvertedPDFIS() {
        return this.convertedPDFIS;
    }

    public File getConvertedPDFFile() {
        return this.convertedPDFFile;
    }

    public static boolean isAFPConversionSupported() {
        if (enableAFPConversion == null || fldwprtExePath == null || pdf995IniPath == null || pdf995SyncIniPath == null) {
            return false;
        }
        return enableAFPConversion.equals("true");
    }

    private void createTempAFP(InputStream afpIS) throws IOException {
        int len;
        String tempAFPFileStr = fldwprtExePath.substring(0, fldwprtExePath.lastIndexOf("\\"));
        String tempAFPFileDirStr = tempAFPFileStr + File.separator + "TempAfpForSUPA";
        this.tempAFPDir = new File(tempAFPFileDirStr);
        this.tempAFPDir.mkdir();
        tempAFPFileStr = tempAFPFileStr + File.separator + "TempAfpForSUPA" + File.separator + tempAFPFileName + ".AFP";
        this.tempAFPRelativePath = "TempAfpForSUPA" + File.separator + tempAFPFileName + ".AFP";
        this.tempAFPFile = new File(tempAFPFileStr);
        FileOutputStream out = new FileOutputStream(this.tempAFPFile);
        byte[] buf = new byte[1024];
        while ((len = afpIS.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        afpIS.close();
    }

    private void convertToPDF(String pdfDestDir, String pdfFileName) throws IOException, InterruptedException, AFPConversionException {
        String[] commands;
        String[] pdfsyncFileStr;
        String[] pdf995FileStr;
        new File(pdfDestDir).mkdir();
        String outputPdfFile = pdfDestDir + File.separator + pdfFileName + CONVERTED_AFP_URI_SUFFIX;
        this.convertedPDFFile = new File(outputPdfFile);
        this.convertedPDFFile.delete();
        File iniFile = new File(pdf995IniPath);
        iniFile.delete();
        iniFile.createNewFile();
        FileOutputStream fop = new FileOutputStream(iniFile);
        for (String curLine : pdf995FileStr = new String[]{"[Parameters]", "Quiet=0", "Use GPL Ghostcript=1", "Use GPL Ghostscript=1", "Use AFPL Ghostscript=1", "Output Folder=" + pdfDestDir, "Output File=" + outputPdfFile, "Autolaunch=0", "[Debug]", "EndDocPort1=1", "EndDocPort2=1", "EndDocPort3=1"}) {
            fop.write(curLine.getBytes());
            fop.write(System.getProperty("line.separator").getBytes());
        }
        fop.flush();
        fop.close();
        iniFile = new File(pdf995SyncIniPath);
        iniFile.delete();
        iniFile.createNewFile();
        fop = new FileOutputStream(iniFile);
        for (String curLine : pdfsyncFileStr = new String[]{"[Parameters]", "Save As Display CS=0", "Save As Displayed=0", "Generating PDF CS=0", "PS Creation Complete=1"}) {
            fop.write(curLine.getBytes());
            fop.write(System.getProperty("line.separator").getBytes());
        }
        fop.flush();
        fop.close();
        String tempDir = GlobalConfiguration.getConfiguration().getTempDirectory();
        File tempBatchDir = new File(tempDir + File.separator + "tempBatch");
        tempBatchDir.mkdir();
        String tempBatchFileStr = tempDir + File.separator + "tempBatch" + File.separator + "converAFPToPDF.bat";
        File tempBatchFile = new File(tempBatchFileStr);
        tempBatchFile.createNewFile();
        FileOutputStream fbatch = new FileOutputStream(tempBatchFile);
        String fldwprtExeDir = fldwprtExePath.substring(0, fldwprtExePath.lastIndexOf("\\"));
        String fldwprtExeDrive = fldwprtExeDir.substring(0, fldwprtExeDir.indexOf(":") + 1);
        String fldwprtExeFileName = fldwprtExePath.substring(fldwprtExePath.lastIndexOf("\\") + 1);
        for (String curLine : commands = new String[]{fldwprtExeDrive, "cd \"" + fldwprtExeDir + "\"", fldwprtExeFileName + " " + this.tempAFPRelativePath + " /P /N"}) {
            fbatch.write(curLine.getBytes());
            fbatch.write(System.getProperty("line.separator").getBytes());
        }
        fbatch.flush();
        fbatch.close();
        Runtime.getRuntime().exec(tempBatchFile.getCanonicalPath());
        boolean fileWasCreated = this.waitStillFileIsCreated(outputPdfFile);
        tempBatchFile.delete();
        tempBatchDir.delete();
        if (!fileWasCreated) {
            throw new AFPConversionException();
        }
        this.wait(this.cpyRecovery);
        this.convertedPDFFile = new File(outputPdfFile);
    }

    private boolean waitStillFileIsCreated(String userFile) throws InterruptedException, IOException {
        String strLine;
        BufferedReader br;
        DataInputStream in;
        FileInputStream fstream;
        int counter;
        int amOfChecks = 2000;
        int checkInterval = 100;
        userFile = userFile.trim();
        boolean pdfWasLaunced = false;
        for (counter = 0; counter < amOfChecks; ++counter) {
            this.wait(checkInterval);
            fstream = new FileInputStream(pdf995IniPath);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                String launchVal;
                if (!strLine.startsWith("Launch") || !userFile.equals(launchVal = strLine.substring("Launch".length() + 1).trim())) continue;
                pdfWasLaunced = true;
                break;
            }
            in.close();
            if (pdfWasLaunced) break;
        }
        for (counter = 0; counter < amOfChecks; ++counter) {
            this.wait(checkInterval);
            fstream = new FileInputStream(pdf995SyncIniPath);
            in = new DataInputStream(fstream);
            br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                char comp;
                if (!strLine.contains("Generating PDF CS") || (comp = strLine.charAt(strLine.length() - 1)) != '0') continue;
                return true;
            }
            in.close();
        }
        return false;
    }

    private InputStream createIndependentISFromFile(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        byte[] buf = new byte[fis.available()];
        fis.read(buf);
        fis.close();
        return new ByteArrayInputStream(buf);
    }

    static {
        try {
            fldwprtExePath = ConfigurationLoader.getGlobalConfig().getAFPConvertorConfig().getFldwprtExePath();
            pdf995IniPath = ConfigurationLoader.getGlobalConfig().getAFPConvertorConfig().getPdf995IniPath();
            pdf995SyncIniPath = ConfigurationLoader.getGlobalConfig().getAFPConvertorConfig().getPdf995SyncIniPath();
            enableAFPConversion = ConfigurationLoader.getGlobalConfig().getAFPConvertorConfig().getEnableAFPConversion().toLowerCase();
        }
        catch (Exception e) {
            enableAFPConversion = "false";
            fldwprtExePath = null;
            pdf995SyncIniPath = null;
            enableAFPConversion = null;
        }
    }

    public static final class AFPConversionException
    extends ExtendedException {
        private static final long serialVersionUID = 1711674721988994489L;

        AFPConversionException() {
            super("Could not convert AFP to PDF");
        }
    }

    public static final class AFPConversionNotSupportedException
    extends ExtendedException {
        private static final long serialVersionUID = -7798557995821520782L;

        private AFPConversionNotSupportedException() {
            super("AFP conversion is not supported");
        }
    }
}

