/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.runtime;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.Content;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.adapter.SimpleBuilder;
import com.ibm.es.nuvo.crawler.adapter.SimpleContent;
import com.ibm.es.nuvo.crawler.adapter.file.FileAclHandler;
import com.ibm.es.nuvo.crawler.runtime.AFPHandler;
import com.ibm.es.nuvo.util.databuffer.DataBufferException;
import com.ibm.es.nuvo.util.uri.FSURIUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class AFPContentSet
extends ContentSet {
    private String orginalUri;
    private ContentSet orginalContents;
    private boolean nextWasInvoked;
    private File pdfFile;
    private static final boolean useTempPdfForFileSys = true;
    private AFPOrigin afpOrigin;
    private String afpFileName;
    private SimpleContent newContent;

    public static AFPContentSet getAFPContentSet(String uri, Content content, ContentSet contents) {
        if (contents instanceof AFPContentSet || !AFPHandler.isAFP(uri)) {
            return null;
        }
        AFPContentSet set = null;
        try {
            set = new AFPContentSet(uri, content, contents);
        }
        catch (AdapterException e) {
            return null;
        }
        catch (DataBufferException e) {
            return null;
        }
        catch (AFPHandler.AFPConversionNotSupportedException e) {
            return null;
        }
        catch (AFPContentIsEmptyException e) {
            return null;
        }
        catch (AFPHandler.AFPConversionException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
        return set;
    }

    private AFPContentSet(String uri, Content content, ContentSet contents) throws AdapterException, DataBufferException, IOException, AFPContentIsEmptyException, InterruptedException, AFPHandler.AFPConversionException, AFPHandler.AFPConversionNotSupportedException {
        AFPHandler afpHandler = AFPHandler.getAFPHandler();
        this.nextWasInvoked = false;
        this.orginalUri = uri;
        this.orginalContents = contents;
        InputStream afpInputStream = null;
        String pdfDirPath = null;
        if (content.hasBody()) {
            ContentBody body = content.getBody();
            afpInputStream = body instanceof SimpleContent.ContentBodyImpl ? ((SimpleContent.ContentBodyImpl)body).getDataBuffer().getInputStream() : body.getStream();
        } else {
            throw new AFPContentIsEmptyException();
        }
        String tempDir = GlobalConfiguration.getConfiguration().getTempDirectory();
        pdfDirPath = tempDir + File.separator + "supa" + File.separator + "afp_pdf_conv";
        if (uri.startsWith("file:")) {
            this.afpOrigin = AFPOrigin.FILESYS;
            File originalFile = FSURIUtil.getFileObject(uri);
            this.afpFileName = originalFile.getName().substring(0, originalFile.getName().lastIndexOf("."));
        } else if (uri.startsWith("Notes:") && uri.contains("?NotesEntry")) {
            if (uri.contains("&ArchiveEntry=")) {
                int lastSlash = uri.lastIndexOf("/");
                int lastDot = uri.lastIndexOf(".");
                this.afpFileName = uri.substring(lastSlash + 1, lastDot);
            } else {
                int lastEq = uri.lastIndexOf("=");
                int lastDot = uri.lastIndexOf(".");
                this.afpFileName = uri.substring(lastEq + 1, lastDot);
            }
            this.afpOrigin = AFPOrigin.NOTES;
        } else {
            throw new AFPHandler.AFPConversionException();
        }
        boolean pdfIsTemp = true;
        if (this.afpOrigin == AFPOrigin.FILESYS) {
            // empty if block
        }
        afpHandler.converAFPISToPDF(afpInputStream, this.afpFileName, pdfDirPath, pdfIsTemp);
        this.pdfFile = afpHandler.getConvertedPDFFile();
        this.newContent = SimpleBuilder.newContent();
        this.newContent.createBody(afpHandler.getConvertedPDFIS(), this.afpFileName);
        this.newContent.addField("filename", this.afpFileName);
    }

    public Content getContent() throws AdapterException {
        return this.newContent;
    }

    public long getHash() {
        if (this.afpOrigin == AFPOrigin.FILESYS) {
            // empty if block
        }
        return this.orginalContents.getHash();
    }

    synchronized FileAclHandler getAclHandler(File f) throws AdapterException {
        FileAclHandler aclHandler = new FileAclHandler(f);
        return aclHandler;
    }

    public String getDocTitle() {
        return this.afpFileName;
    }

    public long getLastModified() {
        if (this.afpOrigin == AFPOrigin.FILESYS) {
            // empty if block
        }
        return this.orginalContents.getLastModified();
    }

    public String getURI() {
        if (this.afpOrigin == AFPOrigin.FILESYS) {
            // empty if block
        }
        return this.orginalUri;
    }

    public boolean next() throws AdapterException {
        if (!this.nextWasInvoked) {
            this.nextWasInvoked = true;
            return true;
        }
        return false;
    }

    public static boolean isUseTempPdfForFileSys() {
        return true;
    }

    private static final class AFPContentIsEmptyException
    extends ExtendedException {
        private static final long serialVersionUID = -4576569236742201092L;

        private AFPContentIsEmptyException() {
            super("AFP content is empty");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum AFPOrigin {
        NOTES,
        FILESYS;

    }
}

