/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.plugin;

import com.ibm.es.nuvo.crawler.plugin.ContentRepository;
import com.ibm.es.nuvo.crawler.plugin.CrawlerPluginException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TemporaryFileContentRepository
implements ContentRepository {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -5477317417561228029L;
    private String tempDir = System.getProperty("java.io.tmpdir");
    private String tempInputFilePath = null;
    private String tempOutputFilePath = null;
    private transient InputStream inputStream = null;
    private transient OutputStream outputStream = null;

    protected TemporaryFileContentRepository() {
    }

    protected TemporaryFileContentRepository(String tempFilePath) {
        this.tempInputFilePath = tempFilePath;
    }

    public void clean() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        if (this.tempInputFilePath != null) {
            File tempInputFile = new File(this.tempInputFilePath);
            tempInputFile.delete();
        }
        if (this.tempOutputFilePath != null) {
            File tempOutputFile = new File(this.tempOutputFilePath);
            tempOutputFile.delete();
        }
    }

    public InputStream getInputStream() throws CrawlerPluginException {
        if (this.inputStream == null && this.tempInputFilePath != null) {
            try {
                this.inputStream = new FileInputStream(this.tempInputFilePath);
            }
            catch (FileNotFoundException e) {
                throw new CrawlerPluginException(e);
            }
        }
        return this.inputStream;
    }

    public OutputStream getOutputStream() throws CrawlerPluginException {
        if (this.outputStream == null) {
            try {
                if (this.tempOutputFilePath == null) {
                    this.tempOutputFilePath = this.getTempFile(this.tempDir).getAbsolutePath();
                }
                this.outputStream = new FileOutputStream(this.tempOutputFilePath);
            }
            catch (FileNotFoundException e) {
                throw new CrawlerPluginException(e);
            }
            catch (IOException e) {
                throw new CrawlerPluginException(e);
            }
        }
        return this.outputStream;
    }

    public void submit() {
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.inputStream = null;
        this.outputStream = null;
        if (this.tempOutputFilePath == null || new File(this.tempOutputFilePath).length() == 0L) {
            throw new IllegalStateException("The empty content is submitted. If you don't want to index  the content of this document, please use \"CrawledData#submitContent(null)\" instead. ");
        }
        if (this.tempInputFilePath != null) {
            File tempInputFile = new File(this.tempInputFilePath);
            tempInputFile.delete();
        }
        this.tempInputFilePath = this.tempOutputFilePath;
        this.tempOutputFilePath = null;
    }

    private File getTempFile(String tmpDir) throws IOException {
        File tempFile = File.createTempFile("~iiof", ".tmp", new File(tmpDir));
        return tempFile;
    }
}

