/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.plugin;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ContentBody;
import com.ibm.es.nuvo.crawler.adapter.Field;
import com.ibm.es.nuvo.crawler.adapter.FieldIterator;
import com.ibm.es.nuvo.crawler.plugin.Content;
import com.ibm.es.nuvo.crawler.plugin.CrawledData;
import com.ibm.es.nuvo.crawler.plugin.CrawlerPluginException;
import com.ibm.es.nuvo.crawler.plugin.Metadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.BooleanMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.DateMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.DoubleMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.LongMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.StringMetadata;
import com.ibm.es.nuvo.crawler.runtime.CommonMetadata;
import com.ibm.es.nuvo.crawler.runtime.FieldMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;

public class CrawledDataFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static CrawledData createCrawledData(String uri) {
        return new CrawledData(uri);
    }

    public static CrawledData toCrawledData(String uri, com.ibm.es.nuvo.crawler.adapter.Content content, FieldMap fieldMap, CommonMetadata common) throws CrawlerPluginException {
        CrawledData crawledData = CrawledDataFactory.createCrawledData(uri);
        crawledData.setLanguage(common.getLanguage());
        try {
            ArrayList<Metadata> pluginMetadataList = new ArrayList<Metadata>();
            FieldIterator fields = content.getFields();
            block9: while (fields.hasNext()) {
                Field field = fields.next();
                Metadata pluginMetadata = null;
                String fieldName = field.getName();
                switch (field.getType()) {
                    case BOOLEAN: {
                        Boolean bval = field.getBoolean();
                        pluginMetadata = new BooleanMetadata(field.getName(), bval);
                        pluginMetadata.setMetadataFieldName(fieldName);
                        break;
                    }
                    case DATE: {
                        Date dateval = field.getDate();
                        pluginMetadata = new DateMetadata(field.getName(), dateval);
                        pluginMetadata.setMetadataFieldName(fieldName);
                        break;
                    }
                    case DOUBLE: {
                        Double dval = field.getDouble();
                        pluginMetadata = new DoubleMetadata(field.getName(), dval);
                        pluginMetadata.setMetadataFieldName(fieldName);
                        break;
                    }
                    case LONG: {
                        Long lval = field.getLong();
                        pluginMetadata = new LongMetadata(field.getName(), lval);
                        pluginMetadata.setMetadataFieldName(fieldName);
                        break;
                    }
                    case READER: 
                    case STRING: {
                        String sval = field.getString();
                        pluginMetadata = new StringMetadata(field.getName(), sval);
                        pluginMetadata.setMetadataFieldName(fieldName);
                        break;
                    }
                    default: {
                        continue block9;
                    }
                }
                pluginMetadataList.add(pluginMetadata);
            }
            crawledData.setMetadataList(pluginMetadataList);
            Content newPluginContent = crawledData.createNewContent();
            CrawledDataFactory.copyContent(newPluginContent, content);
            newPluginContent.setCodepage(common.getCharset());
            newPluginContent.setCodepageAutoDetection(!common.isKnownCharset());
            return crawledData;
        }
        catch (AdapterException e) {
            throw new CrawlerPluginException(e);
        }
    }

    private static void copyContent(Content pluginContent, com.ibm.es.nuvo.crawler.adapter.Content originalContent) throws CrawlerPluginException {
        OutputStream targetStream = null;
        InputStream sourceStream = null;
        try {
            targetStream = pluginContent.getOutputStream();
            if (originalContent.hasBody()) {
                int length;
                ContentBody body = originalContent.getBody();
                pluginContent.setCodepage(body.getEncoding());
                pluginContent.setMimeType(body.getMimetype());
                sourceStream = body.getStream();
                byte[] buffer = new byte[4096];
                while ((length = sourceStream.read(buffer)) != -1) {
                    targetStream.write(buffer, 0, length);
                }
            } else {
                targetStream.write(new byte[0]);
            }
        }
        catch (CrawlerPluginException e) {
            throw e;
        }
        catch (IOException e) {
            throw new CrawlerPluginException(e);
        }
        catch (AdapterException e) {
            throw new CrawlerPluginException(e);
        }
        finally {
            if (sourceStream != null) {
                try {
                    sourceStream.close();
                }
                catch (IOException e) {}
            }
            if (targetStream != null) {
                try {
                    targetStream.close();
                }
                catch (IOException e) {}
            }
        }
    }
}

