/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.plugin;

import com.ibm.es.nuvo.crawler.plugin.Content;
import com.ibm.es.nuvo.crawler.plugin.Metadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.BooleanMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.DateMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.DoubleMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.LongMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.ReaderMetadata;
import com.ibm.es.nuvo.crawler.plugin.metadata.StringMetadata;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawledData
implements Serializable {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private String uri;
    private List<Metadata> metadataList;
    private Content content;
    private String language;
    private boolean isKnownLanguage;
    private List<Content> generatedContent;

    CrawledData() {
        this(null, null, null, null, false);
    }

    CrawledData(String u) {
        this(u, null, null, null, false);
    }

    private CrawledData(String url, List<Metadata> list, Content con, String lang, boolean isKnonwLang) {
        this.uri = url;
        this.metadataList = list;
        this.content = con;
        this.language = lang;
        this.isKnownLanguage = isKnonwLang;
        this.generatedContent = new ArrayList<Content>();
    }

    public String getURI() {
        return this.uri;
    }

    public void setMetadataList(List<Metadata> metadatalist) {
        this.metadataList = metadatalist;
    }

    public List<Metadata> getMetadataList() {
        return this.metadataList;
    }

    public Content getOriginalContent() {
        return this.content;
    }

    public Content createNewContent() {
        Content newContent = new Content();
        this.generatedContent.add(newContent);
        return newContent;
    }

    public Content createNewContent(String tempFilePath) {
        Content newContent = new Content(tempFilePath);
        this.generatedContent.add(newContent);
        return newContent;
    }

    public void submitContent(Content cont) {
        if (this.content != cont && this.content != null) {
            this.content.clean();
        }
        if (cont != null) {
            this.content = cont;
            this.content.submit();
            this.generatedContent.remove(cont);
        } else {
            this.content = null;
        }
    }

    public void setLanguage(String lang) {
        this.language = lang;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguageAutoDetection(boolean autoDetection) {
        this.isKnownLanguage = autoDetection;
    }

    public boolean isLanguageAutoDetection() {
        return this.isKnownLanguage;
    }

    public String[] getMetadataNames() {
        HashSet<String> names = new HashSet<String>();
        for (Metadata metadata : this.metadataList) {
            names.add(metadata.getNativeName());
        }
        return names.toArray(new String[0]);
    }

    public int removeMetadata(String name) {
        int counter = 0;
        int index = 0;
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (Metadata metadata : this.metadataList) {
            if (metadata.getNativeName().equals(name)) {
                indexes.add(index);
            }
            ++index;
        }
        Iterator<Metadata> i$ = indexes.iterator();
        while (i$.hasNext()) {
            int i = (Integer)((Object)i$.next());
            this.metadataList.remove(i);
            ++counter;
        }
        return counter;
    }

    public List<Metadata> getMetadata(String name) {
        ArrayList<Metadata> retList = new ArrayList<Metadata>();
        for (Metadata metadata : this.metadataList) {
            if (!metadata.getNativeName().equals(name)) continue;
            retList.add(metadata);
        }
        return retList;
    }

    public void addMetadata(String name, String value) {
        StringMetadata metadata = new StringMetadata(name, value);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }

    public void addMetadata(String name, Date value) {
        DateMetadata metadata = new DateMetadata(name, value);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }

    public void addMetadata(String name, long value) {
        LongMetadata metadata = new LongMetadata(name, value);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }

    public void addMetadata(String name, double value) {
        DoubleMetadata metadata = new DoubleMetadata(name, value);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }

    public void addMetadata(String name, Reader reader) {
        ReaderMetadata metadata = new ReaderMetadata(name, reader);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }

    public void addMetadata(String name, boolean value) {
        BooleanMetadata metadata = new BooleanMetadata(name, value);
        metadata.setMetadataFieldName(name);
        this.metadataList.add(metadata);
    }
}

