/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.plugin;

import com.ibm.es.nuvo.crawler.plugin.ContentRepository;
import com.ibm.es.nuvo.crawler.plugin.CrawlerPluginException;
import com.ibm.es.nuvo.crawler.plugin.TemporaryFileContentRepository;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class Content
implements Serializable {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = 1L;
    private ContentRepository contentRepository;
    private String codepage = null;
    private boolean isKnownCodepage = false;
    private String mimeType = null;
    private boolean submitted;

    protected Content() {
        this.contentRepository = new TemporaryFileContentRepository();
        this.submitted = false;
    }

    protected Content(String tempFilePath) {
        this.contentRepository = new TemporaryFileContentRepository(tempFilePath);
        this.submitted = false;
    }

    public void setCodepage(String codepage) {
        this.codepage = codepage;
    }

    public String getCodepage() {
        return this.codepage;
    }

    public void setCodepageAutoDetection(boolean autoDetection) {
        this.isKnownCodepage = !autoDetection;
    }

    public boolean isCodepageAutoDetection() {
        return this.isKnownCodepage;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public InputStream getInputStream() throws CrawlerPluginException {
        InputStream inputStream = null;
        inputStream = this.contentRepository.getInputStream();
        return inputStream;
    }

    public OutputStream getOutputStream() throws CrawlerPluginException {
        OutputStream outputStream = null;
        outputStream = this.contentRepository.getOutputStream();
        return outputStream;
    }

    protected void submit() {
        this.submitted = true;
        this.contentRepository.submit();
    }

    public boolean isSubmittedByCrawlerPlugin() {
        return this.submitted;
    }

    protected void clean() {
        this.contentRepository.clean();
    }
}

