/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.serialize;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.admin.ScheduledTask;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.AbstractConfigurationItem;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.SimpleListConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredSpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.container.ConfigurationContainer;
import com.ibm.es.nuvo.crawler.config.id.IDExistingException;
import com.ibm.es.nuvo.crawler.config.schedule.ScheduleFactory;
import com.ibm.es.nuvo.crawler.config.serialize.CrawlerConfigurationSerializer;
import com.ibm.es.nuvo.crawler.util.text.DateFormatFactory;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.ReliableFileInputStream;
import com.ibm.es.nuvo.util.ReliableFileOutputStream;
import com.ibm.es.nuvo.util.XMLTagger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLSerializer
implements CrawlerConfigurationSerializer {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = XMLSerializer.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private final Properties props = new Properties();
    private static final String ELT_ROOT = "crawler-runtime";
    private static final String ELT_CRAWLER = "crawler";
    private static final String ELT_CRAWLSPACE = "crawlspace";
    private static final String ELT_SPACE = "space";
    private static final String ELT_FIELD = "field";
    private static final String ELT_SCHEDULE = "schedule";
    private static final String ELT_SCHEDULE_ENTRY = "schedule-entry";
    private static final String ELT_SCHEDULED_TASK = "schedule-task";
    private static final String ELT_PROPERTY = "property";
    private static final String ELT_ITEM = "item";
    private static final String ELT_CLASSPATH = "classpath";
    private static final String ELT_PATHELT = "path-element";
    private static final String ATTR_ID = "id";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_ISCRAWLSPACE = "crawlspace-param";
    private static final String ATTR_TYPE_NAME = "type-name";
    private static final String ATTR_ATTRIBUTES = "attributes";
    private static final String ATTR_TYPE = "type";
    private static final String ATTR_ENABLED = "enabled";
    private static final String ATTR_OPTIONS = "options";
    private static final String ATTR_CRAWLER_ID = "crawler-id";
    private static final String ATTR_CRAWLSPACE_ID = "crawlspace-id";
    private static final String ATTR_SCHEDULE_MODE = "mode";
    private static final String ATTR_SCHEDULE_START = "start";
    private static final String ATTR_SCHEDULE_INTERVAL = "interval";
    private static final String ATTR_SCHEDULE_UNIT = "unit";
    private static final String ATTR_SCHEDULE_DAYOFWEEK = "day-of-week";
    private static final String ATTR_SCHEDULE_ENABLED = "enabled";
    private static final String ATTRIBUTES_SEP = ";";

    XMLSerializer(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    public void deserialize(ConfigurationContainer container) throws CrawlerConfigurationException {
        String methodName = "deserialize";
        tracer.entering(className, "deserialize");
        String filepath = null;
        InputStream input = null;
        try {
            if (this.props.containsKey((Object)Property.FILEPATH)) {
                File file;
                filepath = (String)this.props.get((Object)Property.FILEPATH);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "The " + Property.FILEPATH.name() + " property is specified. Value:" + filepath);
                }
                if (!(file = new File(filepath)).exists() || !file.isFile()) {
                    return;
                }
                input = new ReliableFileInputStream(filepath);
            } else if (this.props.containsKey((Object)Property.STREAM)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "The " + Property.STREAM.name() + " property is specified. :" + filepath);
                }
                input = (InputStream)this.props.get((Object)Property.STREAM);
            }
            input = new BufferedInputStream(input);
            new CrawlerConfigReader(container).loadConfiguration(input);
            tracer.exiting(className, "deserialize");
        }
        catch (IOException e) {
            Message msg = new Message("C3017E.CRWL_GEN_CONFIG_IOERROR");
            msg.addArgument(filepath);
            throw new CrawlerConfigurationException(msg, (Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Message msg = new Message("C3017E.CRWL_GEN_CONFIG_IOERROR");
                    msg.addArgument(filepath);
                    throw new CrawlerConfigurationException(msg, (Throwable)e);
                }
            }
        }
        tracer.exiting(className, "deserialize");
    }

    public void serialize(ConfigurationContainer container) throws CrawlerConfigurationException {
        String methodName = "serialize";
        tracer.entering(className, "serialize");
        Map<String, CrawlerConfiguration> configurations = container.getCrawlerConfigurations();
        List<ScheduleEntry> schedule = container.getScheduleEntries();
        String filepath = null;
        OutputStream output = null;
        try {
            if (this.props.containsKey((Object)Property.FILEPATH)) {
                filepath = (String)this.props.get((Object)Property.FILEPATH);
                File file = new File(filepath);
                if (!file.exists() && !file.createNewFile() || file.exists() && file.isDirectory()) {
                    Message msg = new Message("C3019E.CRWL_GEN_CONFIG_FILE_CANNOT_CREATE");
                    msg.addArgument(filepath);
                    throw new CrawlerConfigurationException(msg);
                }
                output = new ReliableFileOutputStream(filepath);
            } else if (this.props.containsKey((Object)Property.STREAM)) {
                output = (OutputStream)this.props.get((Object)Property.STREAM);
            }
            output = new BufferedOutputStream(output);
            new CrawlerConfigWriter().saveConfiguration(output, schedule, configurations);
        }
        catch (IOException e) {
            Message msg = new Message("C3017E.CRWL_GEN_CONFIG_IOERROR");
            msg.addArgument(filepath);
            throw new CrawlerConfigurationException(msg, (Throwable)e);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    Message msg = new Message("C3017E.CRWL_GEN_CONFIG_IOERROR");
                    msg.addArgument(filepath);
                    throw new CrawlerConfigurationException(msg, (Throwable)e);
                }
            }
        }
        tracer.exiting(className, "serialize");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrawlerConfigReader
    extends DefaultHandler {
        private DateFormat dateFormat = null;
        private final Map<String, CrawlerConfiguration> crawlerConfigurations;
        private final List<ScheduleEntry> schedule;
        private ScheduleEntry scheduleEntry;
        private ScheduledTask scheduledTask;
        private static final int C = 1;
        private static final int F = 4;
        private static final int P = 5;
        private static final int SCH = 6;
        private static final int SCH_ENTRY = 7;
        private static final int I = 8;
        private static final int CP = 9;
        private static final int PE = 10;
        private static final int SCH_TASK = 11;
        private StringBuilder value = new StringBuilder();
        private String pname;
        private String ptype;
        private EnumSet<Configuration.Attribute> poptions;
        private ConfiguredCrawlerConfiguration crawler;
        private ConfiguredSpaceConfiguration space;
        private ConfiguredFieldConfiguration field;
        private AbstractConfigurationItem current;
        private SimpleListConfiguration list;
        private boolean selected;
        private boolean isCrawlSpaceParameter;
        private Stack<ConfiguredSpaceConfiguration> stack = new Stack();
        private List<String> classpaths = new ArrayList<String>();
        private int state;

        private CrawlerConfigReader(ConfigurationContainer container) {
            this.crawlerConfigurations = container.getCrawlerConfigurations();
            this.schedule = container.getScheduleEntries();
        }

        private Map<String, CrawlerConfiguration> loadConfiguration(InputStream input) throws IOException, CrawlerConfigurationException {
            String methodName = "loadConfiguration";
            tracer.entering(className, "loadConfiguration");
            Message msg = new Message("C3021E.CRWL_GEN_CONFIG_READERROR");
            try {
                this.dateFormat = DateFormatFactory.getInstance("ISO8601");
            }
            catch (ClassNotFoundException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            catch (InstantiationException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            try {
                this.crawlerConfigurations.clear();
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(input, (DefaultHandler)this);
                tracer.exiting(className, "loadConfiguration");
                return Collections.unmodifiableMap(new HashMap<String, CrawlerConfiguration>(this.crawlerConfigurations));
            }
            catch (ParserConfigurationException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            catch (SAXException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void startElement(String uri, String localName, String qname, Attributes atts) throws SAXException {
            String methodName = "startElement";
            tracer.entering(className, "startElement", localName);
            String name = qname;
            if (XMLSerializer.ELT_CRAWLER.equals(name)) {
                String n = atts.getValue(XMLSerializer.ATTR_NAME);
                String id = atts.getValue(XMLSerializer.ATTR_ID);
                String t = atts.getValue(XMLSerializer.ATTR_TYPE);
                if (t == null || t.length() == 0) {
                    Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                    msg.addArgument(XMLSerializer.ELT_CRAWLER);
                    msg.addArgument("null");
                    throw new SAXException(new CrawlerConfigurationException(msg));
                }
                CrawlerType type = ConfiguredConfigurationFactory.getCrawlerType(t);
                try {
                    this.crawler = ConfiguredConfigurationFactory.getNewConfiguredCrawlerConfiguration(id, n, type);
                    this.crawler.setEnabled(true);
                    this.current = this.crawler;
                }
                catch (IDExistingException e) {
                    throw new SAXException(e);
                }
                this.state = 1;
            } else {
                if (XMLSerializer.ELT_SPACE.equals(name) || XMLSerializer.ELT_CRAWLSPACE.equals(name)) {
                    if (this.space != null) {
                        this.stack.push(this.space);
                    }
                    boolean crawlspace = XMLSerializer.ELT_CRAWLSPACE.equals(name);
                    String n = atts.getValue(XMLSerializer.ATTR_NAME);
                    String id = atts.getValue(XMLSerializer.ATTR_ID);
                    try {
                        this.space = ConfiguredConfigurationFactory.getNewConfiguredSpaceConfiguration(id, n);
                        this.space.setEnabled(true);
                        this.space.setAvailableAsCrawlSpace(crawlspace);
                        this.space.setAsCrawlSpace(crawlspace);
                        this.current = this.space;
                    }
                    catch (IDExistingException e) {
                        throw new SAXException(new IllegalStateException("Existing ID is detected for a space:" + n));
                    }
                }
                if (XMLSerializer.ELT_FIELD.equals(name)) {
                    this.state = 4;
                    this.value.setLength(0);
                    String n = atts.getValue(XMLSerializer.ATTR_NAME);
                    String tn = atts.getValue(XMLSerializer.ATTR_TYPE_NAME);
                    String t = atts.getValue(XMLSerializer.ATTR_TYPE);
                    String e = atts.getValue("enabled");
                    FieldType type = FieldType.createFieldType(t);
                    if (type == null) {
                        Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                        msg.addArgument(XMLSerializer.ATTR_TYPE);
                        msg.addArgument("null");
                        throw new SAXException(new CrawlerConfigurationException(msg));
                    }
                    String fieldAttrs = atts.getValue(XMLSerializer.ATTR_ATTRIBUTES);
                    EnumSet<FieldConfiguration.Attribute> attributes = EnumSet.noneOf(FieldConfiguration.Attribute.class);
                    if (fieldAttrs != null) {
                        StringTokenizer tokenizer = new StringTokenizer(fieldAttrs, XMLSerializer.ATTRIBUTES_SEP);
                        while (tokenizer.hasMoreTokens()) {
                            Message msg;
                            String anAttributeStr = tokenizer.nextToken().toUpperCase();
                            FieldConfiguration.Attribute anAttribute = null;
                            try {
                                anAttribute = FieldConfiguration.Attribute.valueOf(anAttributeStr);
                                attributes.add(anAttribute);
                            }
                            catch (IllegalArgumentException iae) {
                                msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                                msg.addArgument(anAttributeStr);
                                msg.addArgument((Object)anAttribute);
                                logger.log(Level.WARNING, msg);
                            }
                            catch (NullPointerException npe) {
                                msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                                msg.addArgument(anAttributeStr);
                                msg.addArgument("null");
                                logger.log(Level.WARNING, msg);
                            }
                        }
                    }
                    if (!this.space.isSetAsCrawlSpace()) throw new IllegalAccessError();
                    this.field = ConfiguredConfigurationFactory.getNewConfiguredFieldConfiguration(n, tn, type, attributes, new Vector<Configuration>());
                    this.field.setEnabled(e == null || Boolean.parseBoolean(e));
                } else if (XMLSerializer.ELT_PROPERTY.equals(name)) {
                    Configuration.Type type;
                    this.isCrawlSpaceParameter = false;
                    this.state = 5;
                    this.pname = atts.getValue(XMLSerializer.ATTR_NAME);
                    this.ptype = atts.getValue(XMLSerializer.ATTR_TYPE);
                    this.poptions = this.parseOptions(atts.getValue(XMLSerializer.ATTR_OPTIONS));
                    String isCrawlSpaceParameterStr = atts.getValue(XMLSerializer.ATTR_ISCRAWLSPACE);
                    if (Boolean.parseBoolean(isCrawlSpaceParameterStr)) {
                        this.isCrawlSpaceParameter = true;
                    }
                    if ((type = Configuration.Type.valueOf(this.ptype.toUpperCase())) == Configuration.Type.LIST_MULTI || type == Configuration.Type.LIST_SINGLE) {
                        this.list = SimpleConfigurationBuilder.createList(this.pname, type == Configuration.Type.LIST_MULTI, this.poptions);
                    }
                    this.value.setLength(0);
                } else if (XMLSerializer.ELT_ITEM.equals(name)) {
                    this.state = 8;
                    this.value.setLength(0);
                    String e = atts.getValue("enabled");
                    this.selected = e == null || Boolean.parseBoolean(e);
                } else if (XMLSerializer.ELT_CLASSPATH.equals(name)) {
                    this.state = 9;
                    this.classpaths.clear();
                } else if (XMLSerializer.ELT_PATHELT.equals(name)) {
                    this.state = 10;
                    this.value.setLength(0);
                } else if (XMLSerializer.ELT_SCHEDULE.equals(name)) {
                    this.state = 6;
                } else if (XMLSerializer.ELT_SCHEDULE_ENTRY.equals(name)) {
                    this.state = 7;
                    String id = atts.getValue(XMLSerializer.ATTR_ID);
                    String n = atts.getValue(XMLSerializer.ATTR_NAME);
                    String typeStr = atts.getValue(XMLSerializer.ATTR_TYPE);
                    ScheduleEntry.Type type = null;
                    try {
                        type = ScheduleEntry.Type.valueOf(typeStr);
                    }
                    catch (IllegalArgumentException iae) {
                        Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                        msg.addArgument(XMLSerializer.ATTR_TYPE);
                        msg.addArgument(typeStr);
                        throw new SAXException(new CrawlerConfigurationException(msg));
                    }
                    this.scheduleEntry = ScheduleFactory.createScheduleEntry(id);
                    this.scheduleEntry.setName(n);
                    this.scheduleEntry.setType(type);
                    this.schedule.add(this.scheduleEntry);
                    String startStr = atts.getValue(XMLSerializer.ATTR_SCHEDULE_START);
                    Date start = null;
                    try {
                        start = this.dateFormat.parse(startStr);
                    }
                    catch (ParseException e) {
                        throw new SAXException(e);
                    }
                    this.scheduleEntry.setStartTime(start);
                    if (type == ScheduleEntry.Type.INTERVAL) {
                        ScheduleEntry.IntervalUnit unit = ScheduleEntry.IntervalUnit.DAY;
                        int interval = 1;
                        String unitStr = atts.getValue(XMLSerializer.ATTR_SCHEDULE_UNIT);
                        String intervalStr = atts.getValue(XMLSerializer.ATTR_SCHEDULE_INTERVAL);
                        if (unitStr != null) {
                            if (unitStr.equalsIgnoreCase(ScheduleEntry.IntervalUnit.DAY.toString())) {
                                unit = ScheduleEntry.IntervalUnit.DAY;
                            } else if (unitStr.equalsIgnoreCase(ScheduleEntry.IntervalUnit.HOUR.toString())) {
                                unit = ScheduleEntry.IntervalUnit.HOUR;
                            } else if (unitStr.equalsIgnoreCase(ScheduleEntry.IntervalUnit.MINUTE.toString())) {
                                unit = ScheduleEntry.IntervalUnit.MINUTE;
                            } else if (unitStr.equalsIgnoreCase(ScheduleEntry.IntervalUnit.WEEK.toString())) {
                                unit = ScheduleEntry.IntervalUnit.WEEK;
                            } else {
                                Message msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                                msg.addArgument(XMLSerializer.ATTR_SCHEDULE_UNIT);
                                msg.addArgument(unitStr);
                                logger.log(Level.WARNING, msg);
                            }
                        } else {
                            Message msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                            msg.addArgument(XMLSerializer.ATTR_SCHEDULE_UNIT);
                            msg.addArgument("null");
                            logger.log(Level.WARNING, msg);
                        }
                        try {
                            interval = Integer.parseInt(intervalStr);
                        }
                        catch (NumberFormatException nfe) {
                            Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                            msg.addArgument(XMLSerializer.ATTR_SCHEDULE_INTERVAL);
                            msg.addArgument(intervalStr);
                            throw new SAXException(new CrawlerConfigurationException(msg));
                        }
                        this.scheduleEntry.setInterval(interval, unit);
                    } else if (type == ScheduleEntry.Type.FIXED_TIME) {
                        String daysOfWeekStr = atts.getValue(XMLSerializer.ATTR_SCHEDULE_DAYOFWEEK);
                        StringTokenizer tokenizer = new StringTokenizer(daysOfWeekStr, XMLSerializer.ATTRIBUTES_SEP);
                        HashSet<ScheduleEntry.DayOfWeek> days = new HashSet<ScheduleEntry.DayOfWeek>();
                        while (tokenizer.hasMoreTokens()) {
                            String token = tokenizer.nextToken().trim();
                            try {
                                ScheduleEntry.DayOfWeek day = ScheduleEntry.DayOfWeek.valueOf(token.toUpperCase());
                                days.add(day);
                            }
                            catch (IllegalArgumentException iae) {
                                Message msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                                msg.addArgument(XMLSerializer.ATTR_SCHEDULE_DAYOFWEEK);
                                msg.addArgument(token);
                                logger.log(Level.WARNING, msg);
                            }
                        }
                        this.scheduleEntry.setDaysOfWeek(days);
                    }
                    boolean isEnabled = false;
                    String scheduleEnablingStr = atts.getValue("enabled");
                    isEnabled = Boolean.parseBoolean(scheduleEnablingStr);
                    this.scheduleEntry.setEnabled(isEnabled);
                } else if (XMLSerializer.ELT_SCHEDULED_TASK.equals(name)) {
                    Message msg;
                    this.state = 11;
                    if (this.scheduleEntry == null) {
                        throw new IllegalStateException();
                    }
                    String crawlerId = atts.getValue(XMLSerializer.ATTR_CRAWLER_ID);
                    if (crawlerId == null || crawlerId.length() == 0) {
                        Message msg2 = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                        msg2.addArgument(XMLSerializer.ATTR_CRAWLER_ID);
                        msg2.addArgument(crawlerId);
                        throw new SAXException(new CrawlerConfigurationException(msg2));
                    }
                    String crawlspaceId = atts.getValue(XMLSerializer.ATTR_CRAWLSPACE_ID);
                    this.scheduledTask = this.scheduleEntry.addScheduledTask(crawlerId, crawlspaceId);
                    CrawlMode mode = CrawlMode.NORMAL;
                    String modeStr = atts.getValue(XMLSerializer.ATTR_SCHEDULE_MODE);
                    if (modeStr != null) {
                        if (modeStr.equalsIgnoreCase(CrawlMode.NORMAL.toString())) {
                            mode = CrawlMode.NORMAL;
                        } else if (modeStr.equalsIgnoreCase(CrawlMode.FORCE.toString())) {
                            mode = CrawlMode.FORCE;
                        } else if (modeStr.equalsIgnoreCase(CrawlMode.QUICK.toString())) {
                            mode = CrawlMode.QUICK;
                        } else {
                            msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                            msg.addArgument(XMLSerializer.ATTR_SCHEDULE_MODE);
                            msg.addArgument(modeStr);
                            logger.log(Level.WARNING, msg);
                        }
                    } else {
                        msg = new Message("C3025W.CRWL_GEN_CONFIG_FILE_DETECT_MEANINGLESS_VALUE");
                        msg.addArgument(XMLSerializer.ATTR_SCHEDULE_MODE);
                        msg.addArgument("null");
                        logger.log(Level.WARNING, msg);
                    }
                    this.scheduledTask.setCrawlMode(mode);
                    boolean isEnabled = false;
                    String scheduleEnablingStr = atts.getValue("enabled");
                    isEnabled = Boolean.parseBoolean(scheduleEnablingStr);
                    this.scheduledTask.setEnabled(isEnabled);
                }
            }
            tracer.exiting(className, "startElement", localName);
        }

        @Override
        public void endElement(String uri, String localName, String qname) throws SAXException {
            String methodName = "endElement";
            tracer.entering(className, "endElement", localName);
            String name = qname;
            if (XMLSerializer.ELT_CRAWLER.equals(name)) {
                this.space = null;
                this.crawler.setCrawler(this.crawler);
                this.crawlerConfigurations.put(this.crawler.getID(), this.crawler);
                this.crawler = null;
                this.current = null;
                this.state = 0;
                if (!this.stack.empty()) {
                    System.err.println("unexpected format!!");
                    this.stack.clear();
                }
            } else if (XMLSerializer.ELT_SPACE.equals(name) || XMLSerializer.ELT_CRAWLSPACE.equals(name)) {
                ConfiguredSpaceConfiguration child = this.space;
                if (this.stack.isEmpty()) {
                    this.space = null;
                    this.crawler.addSubSpace(child);
                    this.current = this.crawler;
                } else {
                    this.space = this.stack.pop();
                    this.space.addSubSpace(child);
                    this.current = this.space;
                }
            } else if (XMLSerializer.ELT_FIELD.equals(name)) {
                if (this.space.isSetAsCrawlSpace()) {
                    this.space.addField(this.field);
                    this.field = null;
                }
            } else if (XMLSerializer.ELT_PROPERTY.equals(name)) {
                String pvalue = this.value.length() > 0 ? this.value.toString() : null;
                Configuration.Type type = null;
                try {
                    type = Configuration.Type.valueOf(this.ptype.toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                    msg.addArgument(XMLSerializer.ATTR_TYPE);
                    msg.addArgument(this.ptype);
                    throw new SAXException(new CrawlerConfigurationException(msg));
                }
                try {
                    if (this.poptions.contains((Object)Configuration.Attribute.ENCRYPT) && null != pvalue) {
                        pvalue = Encryption.decrypt(pvalue);
                    }
                }
                catch (ExtendedException ee) {
                    Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                    msg.addArgument(XMLSerializer.ATTR_OPTIONS);
                    msg.addArgument(this.poptions);
                    throw new SAXException(new CrawlerConfigurationException(msg));
                }
                switch (type) {
                    case STRING: 
                    case BOOLEAN: 
                    case LONG: {
                        Configuration config = SimpleConfigurationBuilder.create(this.pname, type, this.poptions);
                        config.setString(pvalue);
                        if (this.current instanceof ConfiguredSpaceConfiguration && this.isCrawlSpaceParameter) {
                            ((ConfiguredSpaceConfiguration)this.current).addCrawlSpaceConfiguration(config);
                            break;
                        }
                        this.current.addConfiguration(config);
                        break;
                    }
                    case LIST_MULTI: 
                    case LIST_SINGLE: {
                        if (this.current instanceof ConfiguredSpaceConfiguration && this.isCrawlSpaceParameter) {
                            ((ConfiguredSpaceConfiguration)this.current).addCrawlSpaceConfiguration(this.list);
                        } else {
                            this.current.addConfiguration(this.list);
                        }
                        this.list = null;
                    }
                }
            } else if (XMLSerializer.ELT_ITEM.equals(name)) {
                Configuration.ListItem item = this.list.addItem(this.value.toString());
                item.setSelected(this.selected);
            } else if (XMLSerializer.ELT_CLASSPATH.equals(name)) {
                if (!this.classpaths.isEmpty()) {
                    for (String entry : this.classpaths) {
                        this.crawler.getClasspathEntries().add(entry);
                    }
                }
            } else if (XMLSerializer.ELT_PATHELT.equals(name)) {
                this.classpaths.add(this.value.toString());
            } else if (!XMLSerializer.ELT_SCHEDULE.equals(name)) {
                if (XMLSerializer.ELT_SCHEDULE_ENTRY.equals(name)) {
                    this.scheduleEntry = null;
                } else if (XMLSerializer.ELT_SCHEDULED_TASK.equals(name)) {
                    this.scheduledTask = null;
                }
            }
            this.state = 0;
            tracer.exiting(className, "endElement", localName);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.state) {
                case 4: 
                case 5: 
                case 8: 
                case 10: {
                    this.value.append(ch, start, length);
                    break;
                }
            }
        }

        private EnumSet<Configuration.Attribute> parseOptions(String optionStr) throws SAXException {
            EnumSet<Configuration.Attribute> result = EnumSet.noneOf(Configuration.Attribute.class);
            if (null != optionStr && optionStr.length() > 0) {
                String[] options = optionStr.split(XMLSerializer.ATTRIBUTES_SEP);
                for (int i = 0; i < options.length; ++i) {
                    String option = options[i].trim();
                    try {
                        Configuration.Attribute attribute = Configuration.Attribute.valueOf(option.toUpperCase());
                        result.add(attribute);
                        continue;
                    }
                    catch (IllegalArgumentException iae) {
                        Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                        msg.addArgument(XMLSerializer.ATTR_OPTIONS);
                        msg.addArgument(optionStr);
                        throw new SAXException(new CrawlerConfigurationException(msg));
                    }
                    catch (NullPointerException npe) {
                        Message msg = new Message("C3024E.CRWL_GEN_CONFIG_FILE_DETECT_INVALID_VALUE");
                        msg.addArgument(XMLSerializer.ATTR_OPTIONS);
                        msg.addArgument(optionStr);
                        throw new SAXException(new CrawlerConfigurationException(msg));
                    }
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CrawlerConfigWriter {
        private DateFormat dateFormat = null;

        private CrawlerConfigWriter() {
        }

        private void saveConfiguration(OutputStream output, List<ScheduleEntry> schedule, Map<String, CrawlerConfiguration> configs) throws CrawlerConfigurationException, IOException {
            String methodName = "saveConfiguration";
            tracer.entering(className, "saveConfiguration");
            Message msg = new Message("C3023E.CRWL_GEN_CONFIG_WRITEERROR");
            try {
                this.dateFormat = DateFormatFactory.getInstance("ISO8601");
            }
            catch (ClassNotFoundException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            catch (InstantiationException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                msg.addArgument(e.getMessage());
                throw new CrawlerConfigurationException(msg, (Throwable)e);
            }
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, "UTF-8"));
            XMLTagger tagger = new XMLTagger(true, true);
            tagger.startElement(XMLSerializer.ELT_ROOT);
            this.writeSchedule(tagger, schedule);
            for (CrawlerConfiguration crawler : configs.values()) {
                this.writeSpace(tagger, crawler);
            }
            tagger.endElement(XMLSerializer.ELT_ROOT);
            writer.write(tagger.getXML());
            writer.flush();
            writer.close();
            tracer.exiting(className, "saveConfiguration");
        }

        private void writeSchedule(XMLTagger tagger, List<ScheduleEntry> schedule) {
            String methodName = "writeSchedule";
            tracer.entering(className, "writeSchedule");
            String eltName = XMLSerializer.ELT_SCHEDULE;
            String eltNameForEntry = XMLSerializer.ELT_SCHEDULE_ENTRY;
            String eltNameForTask = XMLSerializer.ELT_SCHEDULED_TASK;
            tagger.openStartElement(XMLSerializer.ELT_SCHEDULE);
            tagger.closeTag();
            if (schedule != null) {
                for (ScheduleEntry entry : schedule) {
                    if (entry == null) continue;
                    tagger.openStartElement(XMLSerializer.ELT_SCHEDULE_ENTRY);
                    tagger.writeAttr(XMLSerializer.ATTR_ID, entry.getID());
                    tagger.writeAttr(XMLSerializer.ATTR_NAME, entry.getName());
                    tagger.writeAttr(XMLSerializer.ATTR_TYPE, entry.getType().name());
                    tagger.writeAttr("enabled", Boolean.toString(entry.isEnabled()));
                    tagger.writeAttr(XMLSerializer.ATTR_SCHEDULE_START, this.dateFormat.format(entry.getStartTime()));
                    switch (entry.getType()) {
                        case INTERVAL: {
                            tagger.writeAttr(XMLSerializer.ATTR_SCHEDULE_INTERVAL, entry.getInterval());
                            tagger.writeAttr(XMLSerializer.ATTR_SCHEDULE_UNIT, entry.getIntervalUnit().toString());
                            break;
                        }
                        case FIXED_TIME: {
                            StringBuilder builder = new StringBuilder("");
                            for (ScheduleEntry.DayOfWeek day : entry.getDaysOfWeek()) {
                                builder.append(day.getCaseSensitiveString()).append(XMLSerializer.ATTRIBUTES_SEP);
                            }
                            if (builder.lastIndexOf(XMLSerializer.ATTRIBUTES_SEP) == builder.length() - 1) {
                                builder.deleteCharAt(builder.length() - 1);
                            }
                            tagger.writeAttr(XMLSerializer.ATTR_SCHEDULE_DAYOFWEEK, builder.toString());
                            break;
                        }
                    }
                    tagger.closeTag();
                    List<ScheduledTask> tasks = entry.getScheduledTasks();
                    if (tasks != null) {
                        for (ScheduledTask task : tasks) {
                            if (task == null) continue;
                            tagger.openStartElement(XMLSerializer.ELT_SCHEDULED_TASK);
                            tagger.writeAttr(XMLSerializer.ATTR_CRAWLER_ID, task.getCrawlerID());
                            if (task.getCrawlSpaceID() != null) {
                                tagger.writeAttr(XMLSerializer.ATTR_CRAWLSPACE_ID, task.getCrawlSpaceID());
                            }
                            tagger.writeAttr("enabled", Boolean.toString(task.isEnabled()));
                            tagger.writeAttr(XMLSerializer.ATTR_SCHEDULE_MODE, task.getCrawlMode().name());
                            tagger.closeEndElementTag();
                        }
                    }
                    tagger.endElement(XMLSerializer.ELT_SCHEDULE_ENTRY);
                }
            }
            tagger.endElement(XMLSerializer.ELT_SCHEDULE);
            tracer.exiting(className, "writeSchedule");
        }

        private void writeSpace(XMLTagger tagger, SpaceConfiguration space) throws CrawlerConfigurationException {
            Message msg;
            String methodName = "writeSpace";
            tracer.entering(className, "writeSpace");
            if (!space.isEnabled()) {
                return;
            }
            String eltName = XMLSerializer.ELT_SPACE;
            if (space instanceof CrawlerConfiguration) {
                CrawlerConfiguration crawler = (CrawlerConfiguration)space;
                eltName = XMLSerializer.ELT_CRAWLER;
                tagger.openStartElement(eltName);
                tagger.writeAttr(XMLSerializer.ATTR_ID, crawler.getID());
                tagger.writeAttr(XMLSerializer.ATTR_NAME, crawler.getName());
                tagger.writeAttr(XMLSerializer.ATTR_TYPE, crawler.getType().getName());
                tagger.closeTag();
                this.writeClasspath(tagger, crawler.getClasspathEntries());
            } else if (space.isSetAsCrawlSpace()) {
                eltName = XMLSerializer.ELT_CRAWLSPACE;
                tagger.openStartElement(eltName);
                tagger.writeAttr(XMLSerializer.ATTR_ID, space.getID());
                tagger.writeAttr(XMLSerializer.ATTR_NAME, space.getName());
                tagger.closeTag();
            } else {
                eltName = XMLSerializer.ELT_SPACE;
                tagger.openStartElement(eltName);
                tagger.writeAttr(XMLSerializer.ATTR_ID, space.getID());
                tagger.writeAttr(XMLSerializer.ATTR_NAME, space.getName());
                tagger.closeTag();
            }
            Map<String, Configuration> params = space.getConfigurations();
            for (Configuration param : params.values()) {
                this.writeConfiguration(tagger, param, false);
            }
            if (space.isSetAsCrawlSpace()) {
                Map<String, Configuration> crawlSpaceParams = space.getCrawlSpaceConfigurations();
                for (Configuration crawlSpaceParam : crawlSpaceParams.values()) {
                    this.writeConfiguration(tagger, crawlSpaceParam, true);
                }
            }
            if (space.isSetAsCrawlSpace()) {
                try {
                    Iterator<FieldConfiguration> fields = space.getFields();
                    while (fields.hasNext()) {
                        this.writeField(tagger, fields.next());
                    }
                }
                catch (CrawlerConfigurationException e) {
                    msg = new Message("C3021E.CRWL_GEN_CONFIG_READERROR");
                    msg.addArgument(e.getMessage());
                    throw new CrawlerConfigurationException(msg, (Throwable)e);
                }
            }
            if (space.hasSubSpaces()) {
                try {
                    Iterator<SpaceConfiguration> subspaces = space.getSubSpaces();
                    while (subspaces.hasNext()) {
                        this.writeSpace(tagger, subspaces.next());
                    }
                }
                catch (CrawlerConfigurationException e) {
                    msg = new Message("C3021E.CRWL_GEN_CONFIG_READERROR");
                    msg.addArgument(e.getMessage());
                    throw new CrawlerConfigurationException(msg, (Throwable)e);
                }
            }
            tagger.endElement(eltName);
            tracer.exiting(className, "writeSpace");
        }

        private void writeConfiguration(XMLTagger tagger, Configuration param, boolean isCrawlSpaceParam) throws CrawlerConfigurationException {
            String methodName = "writeConfiguration";
            tracer.entering(className, "writeConfiguration");
            tagger.openStartElement(XMLSerializer.ELT_PROPERTY);
            tagger.writeAttr(XMLSerializer.ATTR_NAME, param.getName());
            tagger.writeAttr(XMLSerializer.ATTR_TYPE, param.getType().name().toLowerCase());
            if (isCrawlSpaceParam) {
                tagger.writeAttr(XMLSerializer.ATTR_ISCRAWLSPACE, Boolean.valueOf(true).toString());
            }
            EnumSet<Configuration.Attribute> options = param.getAttributes();
            this.writeConfigurationOptions(tagger, options);
            tagger.closeTag();
            switch (param.getType()) {
                case STRING: 
                case BOOLEAN: 
                case LONG: {
                    String value = param.getString();
                    if (value == null) break;
                    if (options.contains((Object)Configuration.Attribute.ENCRYPT)) {
                        try {
                            value = Encryption.encrypt(value);
                        }
                        catch (ExtendedException ee) {
                            throw new CrawlerConfigurationException(ee);
                        }
                    }
                    tagger.writeText(value);
                    break;
                }
                case LIST_MULTI: 
                case LIST_SINGLE: {
                    for (Configuration.ListItem item : param.getItems()) {
                        tagger.openStartElement(XMLSerializer.ELT_ITEM);
                        tagger.writeAttr("enabled", Boolean.toString(item.isSelected()));
                        tagger.closeTag();
                        tagger.writeText(item.getValue());
                        tagger.endElement(XMLSerializer.ELT_ITEM);
                    }
                    break;
                }
            }
            tagger.endElement(XMLSerializer.ELT_PROPERTY);
            tracer.exiting(className, "writeConfiguration");
        }

        private void writeConfigurationOptions(XMLTagger tagger, EnumSet<Configuration.Attribute> options) {
            if (options.size() > 0) {
                StringBuilder buf = new StringBuilder();
                for (Configuration.Attribute attribute : options) {
                    buf.append(attribute.name().toLowerCase());
                    buf.append(XMLSerializer.ATTRIBUTES_SEP);
                }
                if (buf.length() > 0) {
                    tagger.writeAttr(XMLSerializer.ATTR_OPTIONS, buf.substring(0, buf.length() - 1));
                }
            }
        }

        private void writeField(XMLTagger tagger, FieldConfiguration field) {
            String methodName = "writeField";
            tracer.entering(className, "writeField");
            tagger.openStartElement(XMLSerializer.ELT_FIELD);
            tagger.writeAttr(XMLSerializer.ATTR_NAME, field.getName());
            tagger.writeAttr(XMLSerializer.ATTR_TYPE, field.getType().name().toLowerCase());
            String typeName = field.getTypeName();
            if (typeName != null && typeName.length() > 0) {
                tagger.writeAttr(XMLSerializer.ATTR_TYPE_NAME, field.getTypeName());
            }
            tagger.writeAttr("enabled", Boolean.toString(field.isEnabled()));
            StringBuffer buf = new StringBuffer();
            Iterator attrIter = field.getAttributes().iterator();
            FieldConfiguration.Attribute anAttribute = null;
            while (attrIter.hasNext()) {
                anAttribute = (FieldConfiguration.Attribute)((Object)attrIter.next());
                buf.append(anAttribute.name());
                if (!attrIter.hasNext()) continue;
                buf.append(XMLSerializer.ATTRIBUTES_SEP);
            }
            String attrStr = buf.toString();
            if (attrStr != null && attrStr.trim().length() != 0) {
                tagger.writeAttr(XMLSerializer.ATTR_ATTRIBUTES, attrStr.toLowerCase());
            }
            tagger.closeTag();
            tagger.endElement(XMLSerializer.ELT_FIELD);
            tracer.exiting(className, "writeField");
        }

        private void writeClasspath(XMLTagger tagger, List<String> classpaths) {
            String methodName = "writeClasspath";
            tracer.entering(className, "writeClasspath");
            if (classpaths.isEmpty()) {
                return;
            }
            tagger.openStartElement(XMLSerializer.ELT_CLASSPATH);
            tagger.closeTag();
            for (String entry : classpaths) {
                tagger.openStartElement(XMLSerializer.ELT_PATHELT);
                tagger.closeTag();
                tagger.writeText(entry);
                tagger.endElement(XMLSerializer.ELT_PATHELT);
            }
            tagger.endElement(XMLSerializer.ELT_CLASSPATH);
            tracer.exiting(className, "writeClasspath");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        FILEPATH,
        STREAM;

    }
}

