/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.schedule;

import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.admin.ScheduledTask;
import com.ibm.es.nuvo.crawler.config.schedule.ScheduleFactory;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SimpleScheduleEntry
implements ScheduleEntry {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final String id;
    private String name;
    private ScheduleEntry.Type type;
    private boolean isEnabled;
    private final Set<ScheduleEntry.DayOfWeek> daysOfWeek;
    private Date startTime;
    private int interval;
    private ScheduleEntry.IntervalUnit intervalUnit;
    private final List<ScheduledTask> tasks;

    SimpleScheduleEntry(String id) {
        this.id = id;
        this.name = null;
        this.isEnabled = true;
        this.daysOfWeek = new LinkedHashSet<ScheduleEntry.DayOfWeek>();
        this.startTime = new Date(System.currentTimeMillis());
        this.intervalUnit = ScheduleEntry.IntervalUnit.DAY;
        this.interval = 1;
        this.tasks = new ArrayList<ScheduledTask>();
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public ScheduleEntry.Type getType() {
        return this.type;
    }

    @Override
    public void setType(ScheduleEntry.Type type) {
        this.type = type;
    }

    @Override
    public Set<ScheduleEntry.DayOfWeek> getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @Override
    public void setDaysOfWeek(Set<ScheduleEntry.DayOfWeek> daysOfWeek) {
        if (daysOfWeek == null) {
            throw new IllegalArgumentException("daysOfWeek is null.");
        }
        this.daysOfWeek.clear();
        this.daysOfWeek.addAll(daysOfWeek);
    }

    @Override
    public Date getStartTime() {
        return this.startTime;
    }

    @Override
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    public int getInterval() {
        return this.interval;
    }

    @Override
    public ScheduleEntry.IntervalUnit getIntervalUnit() {
        return this.intervalUnit;
    }

    @Override
    public void setStartTime(Date startTime) {
        if (startTime == null) {
            throw new IllegalArgumentException("startTime must be not null.");
        }
        this.startTime = startTime;
    }

    @Override
    public void setInterval(int interval, ScheduleEntry.IntervalUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Interval unit must be not null.");
        }
        this.interval = interval;
        this.intervalUnit = unit;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    @Override
    public ScheduledTask addScheduledTask(String crawlerId, String crawlspaceId) {
        ScheduledTask newTask = ScheduleFactory.getNewScheduledTask(crawlerId, crawlspaceId);
        this.tasks.add(newTask);
        return newTask;
    }

    @Override
    public ScheduledTask addScheduledTask(String crawlerId) {
        return this.addScheduledTask(crawlerId, null);
    }

    @Override
    public List<ScheduledTask> getScheduledTasks() {
        return this.tasks;
    }

    public String toString() {
        return this.name + '[' + this.id + ',' + (Object)((Object)this.type) + ',' + this.isEnabled + ',' + this.startTime + ']';
    }
}

