/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.schedule;

import com.ibm.es.nuvo.crawler.admin.Schedule;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.config.schedule.ScheduleFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SimpleSchedule
implements Schedule {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final List<ScheduleEntry> entries = new Vector<ScheduleEntry>();

    SimpleSchedule() {
    }

    @Override
    public ScheduleEntry addEntry() {
        ScheduleEntry entry = ScheduleFactory.getNewScheduleEntry();
        this.entries.add(entry);
        return entry;
    }

    @Override
    public ScheduleEntry addEntry(String name, ScheduleEntry.Type type) {
        ScheduleEntry entry = this.addEntry();
        entry.setName(name);
        entry.setType(type);
        return entry;
    }

    @Override
    public ScheduleEntry removeEntry(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        ScheduleEntry removed = null;
        for (ScheduleEntry entry : this.entries) {
            if (entry == null || !id.equals(entry.getID())) continue;
            removed = entry;
            break;
        }
        this.entries.remove(removed);
        return removed;
    }

    @Override
    public List<ScheduleEntry> getEntries() {
        return Collections.unmodifiableList(new ArrayList<ScheduleEntry>(this.entries));
    }

    public void clear() {
        this.entries.clear();
    }

    public void addAll(Collection<ScheduleEntry> sourceEntries) {
        for (ScheduleEntry entry : sourceEntries) {
            this.add(entry);
        }
    }

    public void add(ScheduleEntry entry) {
        if (entry == null) {
            return;
        }
        this.entries.add(entry);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (ScheduleEntry entry : this.entries) {
            builder.append(entry).append('\n');
        }
        return builder.toString();
    }
}

