/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.schedule;

import com.ibm.es.nuvo.crawler.admin.Schedule;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.admin.ScheduledTask;
import com.ibm.es.nuvo.crawler.config.id.IDGeneratorFactory;
import com.ibm.es.nuvo.crawler.config.schedule.SimpleSchedule;
import com.ibm.es.nuvo.crawler.config.schedule.SimpleScheduleEntry;
import com.ibm.es.nuvo.crawler.config.schedule.SimpleScheduledTask;

public final class ScheduleFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static SimpleSchedule getNewSchedule() {
        return new SimpleSchedule();
    }

    public static ScheduleEntry getNewScheduleEntry() {
        String id = IDGeneratorFactory.getDefaultGenerator().generateNewID();
        return ScheduleFactory.createScheduleEntry(id);
    }

    public static ScheduleEntry createScheduleEntry(String id) {
        return new SimpleScheduleEntry(id);
    }

    static ScheduledTask getNewScheduledTask(String crawlerId, String crawlspaceId) {
        return new SimpleScheduledTask(crawlerId, crawlspaceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schedule getClonedSchedule(Schedule schedule) {
        SimpleSchedule cloned = new SimpleSchedule();
        Schedule schedule2 = schedule;
        synchronized (schedule2) {
            for (ScheduleEntry entry : schedule.getEntries()) {
                cloned.add(ScheduleFactory.getClonedScheduleEntry(entry));
            }
        }
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ScheduleEntry getClonedScheduleEntry(ScheduleEntry entry) {
        String id = entry.getID();
        String name = entry.getName();
        ScheduleEntry.Type type = entry.getType();
        ScheduleEntry clonedEntry = ScheduleFactory.createScheduleEntry(id);
        clonedEntry.setName(name);
        clonedEntry.setType(type);
        ScheduleEntry scheduleEntry = entry;
        synchronized (scheduleEntry) {
            switch (type) {
                case INTERVAL: {
                    clonedEntry.setInterval(entry.getInterval(), entry.getIntervalUnit());
                    break;
                }
                case FIXED_TIME: {
                    clonedEntry.setDaysOfWeek(entry.getDaysOfWeek());
                }
            }
            clonedEntry.setStartTime(entry.getStartTime());
            clonedEntry.setEnabled(entry.isEnabled());
            for (ScheduledTask task : entry.getScheduledTasks()) {
                ScheduledTask clonedTask = clonedEntry.addScheduledTask(task.getCrawlerID(), task.getCrawlSpaceID());
                ScheduledTask scheduledTask = task;
                synchronized (scheduledTask) {
                    clonedTask.setCrawlMode(task.getCrawlMode());
                    clonedTask.setEnabled(task.isEnabled());
                }
            }
        }
        return clonedEntry;
    }

    private ScheduleFactory() {
    }
}

