/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.manager;

import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.Schedule;
import com.ibm.es.nuvo.crawler.admin.ScheduleEntry;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.container.ConfigurationContainer;
import com.ibm.es.nuvo.crawler.config.container.ConfigurationContainerFactory;
import com.ibm.es.nuvo.crawler.config.listener.CollectionListener;
import com.ibm.es.nuvo.crawler.config.listener.CrawlerConfigurationListener;
import com.ibm.es.nuvo.crawler.config.listener.ScheduleEntryListener;
import com.ibm.es.nuvo.crawler.config.manager.CrawlerConfigurationManager;
import com.ibm.es.nuvo.crawler.config.schedule.ScheduleFactory;
import com.ibm.es.nuvo.crawler.config.schedule.SimpleSchedule;
import com.ibm.es.nuvo.crawler.config.serialize.CrawlerConfigurationSerializer;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManagerImpl
implements CrawlerConfigurationManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = ConfigurationManagerImpl.class.getName();
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + className);
    private final Map<String, ConfiguredCrawlerConfiguration> currentConfigurations;
    private final SimpleSchedule schedule;
    private List<CollectionListener> collectionListeners;
    private List<CrawlerConfigurationListener> crawlerListeners = new Vector<CrawlerConfigurationListener>();
    private List<ScheduleEntryListener> scheduleListeners;

    public ConfigurationManagerImpl() {
        this.currentConfigurations = new HashMap<String, ConfiguredCrawlerConfiguration>();
        this.collectionListeners = new Vector<CollectionListener>();
        this.crawlerListeners = new Vector<CrawlerConfigurationListener>();
        this.scheduleListeners = new Vector<ScheduleEntryListener>();
        this.schedule = ScheduleFactory.getNewSchedule();
    }

    @Override
    public void loadConfiguration(CrawlerConfigurationSerializer serializer) throws CrawlerConfigurationException {
        this.currentConfigurations.clear();
        this.schedule.clear();
        ConfigurationContainer container = ConfigurationContainerFactory.getNewContainer();
        serializer.deserialize(container);
        Map<String, CrawlerConfiguration> deserializedConfigs = container.getCrawlerConfigurations();
        for (Map.Entry<String, CrawlerConfiguration> entry : deserializedConfigs.entrySet()) {
            this.currentConfigurations.put(entry.getKey(), ConfiguredConfigurationFactory.getConfiguredClone(entry.getValue()));
        }
        List<ScheduleEntry> deserializedSchedule = container.getScheduleEntries();
        if (deserializedSchedule != null) {
            this.schedule.addAll(deserializedSchedule);
        }
    }

    @Override
    public void persistConfiguration(CrawlerConfigurationSerializer serializer) throws CrawlerConfigurationException {
        ConfigurationContainer container = ConfigurationContainerFactory.getNewContainer();
        container.getCrawlerConfigurations().putAll(this.currentConfigurations);
        container.getScheduleEntries().addAll(this.schedule.getEntries());
        serializer.serialize(container);
        this.notifyToCrawlerListeners(new ArrayList<CrawlerConfiguration>(this.currentConfigurations.values()));
        this.notifyToCollectionListeners();
        this.notifyToScheduleEntryListeners(new ArrayList<ScheduleEntry>(this.schedule.getEntries()));
    }

    @Override
    public ConfiguredCrawlerConfiguration getCurrentPersistentConfiguration(String crawlerId) throws CrawlerConfigurationException {
        ConfiguredCrawlerConfiguration retVal = null;
        try {
            retVal = ConfiguredConfigurationFactory.getConfiguredClone(this.currentConfigurations.get(crawlerId));
        }
        catch (CrawlerConfigurationException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public void notifyToCrawlerListeners(Collection<CrawlerConfiguration> changedCrawlers) throws CrawlerConfigurationException {
        block0: for (CrawlerConfigurationListener aListener : this.crawlerListeners) {
            String crawlerId = aListener.getCrawlerID();
            for (CrawlerConfiguration aCrawler : changedCrawlers) {
                if (!aCrawler.getID().equals(crawlerId)) continue;
                aListener.crawlerConfigurationUpdated(aCrawler);
                continue block0;
            }
        }
    }

    public void notifyToScheduleEntryListeners(Collection<ScheduleEntry> changedEntries) throws CrawlerConfigurationException {
        block0: for (ScheduleEntryListener listener : this.scheduleListeners) {
            for (ScheduleEntry entry : changedEntries) {
                if (!entry.getID().equals(listener.getID())) continue;
                listener.scheduleEntryUpdated(entry);
                continue block0;
            }
        }
    }

    public void notifyToCollectionListeners() {
        for (CollectionListener aListener : this.collectionListeners) {
            aListener.collectionUpdated(this.currentConfigurations.values().toArray(new CrawlerConfiguration[0]));
        }
    }

    @Override
    public ConfiguredCrawlerConfiguration[] getCurrentPersistentConfigurations() throws CrawlerConfigurationException {
        ArrayList<ConfiguredCrawlerConfiguration> retVal = new ArrayList<ConfiguredCrawlerConfiguration>();
        for (ConfiguredCrawlerConfiguration crawler : this.currentConfigurations.values()) {
            retVal.add(ConfiguredConfigurationFactory.getConfiguredClone(crawler));
        }
        return retVal.toArray(new ConfiguredCrawlerConfiguration[0]);
    }

    @Override
    public ConfiguredCrawlerConfiguration submitCrawlerConfiguration(CrawlerConfiguration crawler) throws CrawlerConfigurationException {
        crawler.close();
        ConfiguredCrawlerConfiguration clone = ConfiguredConfigurationFactory.getConfiguredClone(crawler);
        this.currentConfigurations.put(clone.getID(), clone);
        return clone;
    }

    @Override
    public ConfiguredCrawlerConfiguration[] addCollectionListener(CollectionListener collectionListener) throws CrawlerConfigurationException {
        this.collectionListeners.add(collectionListener);
        return this.getCurrentPersistentConfigurations();
    }

    @Override
    public void removeCollectionListener(CollectionListener unnecessaryListener) {
        this.collectionListeners.remove(unnecessaryListener);
    }

    @Override
    public ConfiguredCrawlerConfiguration addCrawlerConfigurationListner(CrawlerConfigurationListener crawlerConfigurationListener) throws CrawlerConfigurationException {
        this.crawlerListeners.add(crawlerConfigurationListener);
        return this.getCurrentPersistentConfiguration(crawlerConfigurationListener.getCrawlerID());
    }

    @Override
    public void removeCrawlerConfigurationListener(CrawlerConfigurationListener unnecessaryListener) {
        this.crawlerListeners.remove(unnecessaryListener);
    }

    @Override
    public void removeCrawlerConfiguration(String crawlerId) throws CrawlerConfigurationException {
        if (!this.currentConfigurations.containsKey(crawlerId)) {
            throw new CrawlerConfigurationException(new IllegalArgumentException("The specified crawler configuration does not exist."));
        }
        this.currentConfigurations.remove(crawlerId);
        ArrayList<CrawlerConfigurationListener> remove = new ArrayList<CrawlerConfigurationListener>();
        for (CrawlerConfigurationListener aCrawlerListener : this.crawlerListeners) {
            if (!aCrawlerListener.getCrawlerID().equals(crawlerId)) continue;
            remove.add(aCrawlerListener);
        }
        this.crawlerListeners.removeAll(remove);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduleEntry addScheduleEntryListener(ScheduleEntryListener listener) throws CrawlerConfigurationException {
        this.scheduleListeners.add(listener);
        SimpleSchedule simpleSchedule = this.schedule;
        synchronized (simpleSchedule) {
            for (ScheduleEntry entry : this.schedule.getEntries()) {
                if (!listener.getID().equals(entry.getID())) continue;
                return ScheduleFactory.getClonedScheduleEntry(entry);
            }
        }
        return null;
    }

    @Override
    public void removeScheduleEntryListener(ScheduleEntryListener listener) {
        this.scheduleListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schedule getSchedule() {
        String methodName = "getSchedule";
        Schedule cloned = null;
        tracer.entering(className, "getSchedule");
        SimpleSchedule simpleSchedule = this.schedule;
        synchronized (simpleSchedule) {
            cloned = ScheduleFactory.getClonedSchedule(this.schedule);
        }
        tracer.exiting(className, "getSchedule");
        return cloned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submitSchedule(Schedule sch) throws CrawlerConfigurationException {
        String methodName = "submitSchedule";
        tracer.entering(className, "submitSchedule");
        Schedule schedule = sch;
        synchronized (schedule) {
            SimpleSchedule simpleSchedule = this.schedule;
            synchronized (simpleSchedule) {
                this.schedule.clear();
                this.schedule.addAll(sch.getEntries());
            }
        }
        tracer.exiting(className, "submitSchedule");
    }
}

