/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.listener;

import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.listener.CollectionListener;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CollectionCrawlerConfigCacheListener
implements CollectionListener {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String className = CollectionCrawlerConfigCacheListener.class.getName();
    private static final ExtendedLogger logger = ExtendedLogger.getLogger("com.ibm.es.nuvo." + className);
    private BaseCrawlerManager manager;
    private Map<String, AdapterCrawlSpacePair> cache;

    public CollectionCrawlerConfigCacheListener(BaseCrawlerManager mgr) throws CrawlerConfigurationException, AdapterException {
        if (mgr == null) {
            throw new IllegalArgumentException();
        }
        this.manager = mgr;
        this.cache = new HashMap<String, AdapterCrawlSpacePair>();
        CrawlerConfiguration[] currentConfigs = this.manager.addCollectionCrawlerConfigurationListener(this);
        this.refreshCache(currentConfigs);
    }

    public synchronized Adapter getAdapter(String crawlSpaceId) {
        Adapter result = null;
        AdapterCrawlSpacePair pair = this.cache.get(crawlSpaceId);
        if (pair != null) {
            result = pair.getAdapter();
        }
        return result;
    }

    public synchronized SpaceConfiguration getSpaceConfiguration(String crawlSpaceId) {
        SpaceConfiguration result = null;
        AdapterCrawlSpacePair pair = this.cache.get(crawlSpaceId);
        if (pair != null) {
            result = pair.getConfig();
        }
        return result;
    }

    private synchronized void refreshCache(CrawlerConfiguration[] configs) throws CrawlerConfigurationException, AdapterException {
        CrawlerConfiguration[] crawlerConfigs = configs;
        this.cache.clear();
        if (null == crawlerConfigs) {
            crawlerConfigs = this.manager.getCurrentPersistentCrawlerConfigurations();
        }
        for (int i = 0; i < crawlerConfigs.length; ++i) {
            CrawlerConfiguration rootCrawlerConfig = crawlerConfigs[i];
            Iterator<SpaceConfiguration> itrRootSpaces = rootCrawlerConfig.getSubSpaces();
            while (itrRootSpaces.hasNext()) {
                SpaceConfiguration space = itrRootSpaces.next();
                this.traverseSpace(space);
            }
        }
    }

    private synchronized void traverseSpace(SpaceConfiguration space) throws CrawlerConfigurationException, AdapterException {
        if (space.isSetAsCrawlSpace()) {
            AdapterCrawlSpacePair pair = this.createNewAdapterSpacePair(space);
            this.cache.put(space.getID(), pair);
        } else {
            Iterator<SpaceConfiguration> itrSubspace = space.getSubSpaces();
            while (itrSubspace.hasNext()) {
                SpaceConfiguration subSpace = itrSubspace.next();
                this.traverseSpace(subSpace);
            }
        }
    }

    private AdapterCrawlSpacePair createNewAdapterSpacePair(SpaceConfiguration space) throws AdapterException {
        String crawlerType = space.getCrawler().getType().getName();
        String crawlerId = space.getCrawler().getID();
        Adapter adapter = this.manager.getAdapter(crawlerType, crawlerId);
        AdapterCrawlSpacePair pair = new AdapterCrawlSpacePair(adapter, space);
        return pair;
    }

    public void collectionUpdated(CrawlerConfiguration[] configurations) {
        try {
            this.refreshCache(configurations);
        }
        catch (AdapterException ae) {
            logger.log(ae);
            throw new RuntimeException(ae);
        }
        catch (CrawlerConfigurationException cce) {
            logger.log(cce);
            throw new RuntimeException(cce);
        }
    }

    public static class AdapterCrawlSpacePair {
        private Adapter adapter;
        private SpaceConfiguration config;

        public AdapterCrawlSpacePair(Adapter lAdapter, SpaceConfiguration lConfig) {
            this.adapter = lAdapter;
            this.config = lConfig;
        }

        public void setAdapter(Adapter adapter) {
            this.adapter = adapter;
        }

        public void setConfig(SpaceConfiguration config) {
            this.config = config;
        }

        public Adapter getAdapter() {
            return this.adapter;
        }

        public SpaceConfiguration getConfig() {
            return this.config;
        }
    }
}

