/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.listener;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.config.listener.CollectionCrawlerConfigCacheListener;
import com.ibm.es.nuvo.crawler.runtime.BaseCrawlerManager;
import java.util.HashMap;
import java.util.Map;

public class CollectionCrawlerConfigCache {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, CollectionCrawlerConfigCacheListener> colCache = new HashMap<String, CollectionCrawlerConfigCacheListener>();

    public synchronized CollectionCrawlerConfigCacheListener getCacheFor(String collectionId) throws AdapterException, CrawlerConfigurationException {
        CollectionCrawlerConfigCacheListener result = null;
        CollectionCrawlerConfigCacheListener cache = this.colCache.get(collectionId);
        if (cache != null) {
            result = cache;
        } else {
            GlobalCrawlerManager gManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
            CrawlerManager cManager = gManager.getCrawlerManager(collectionId);
            if (cManager != null) {
                result = new CollectionCrawlerConfigCacheListener((BaseCrawlerManager)cManager);
                this.colCache.put(collectionId, result);
            }
        }
        return result;
    }

    public synchronized void removeCacheFor(String collectionId) {
        if (this.colCache.containsKey(collectionId)) {
            this.colCache.remove(collectionId);
        }
    }
}

