/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.id;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.config.id.IDExistingException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Random;
import java.util.Vector;

public final class IDRepository {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static List<String> idRepository = new Vector<String>();
    private static Random random = new Random();

    public static boolean isExistingID(String id) {
        return idRepository.contains(id);
    }

    public static synchronized void registerId(String existingId) throws IDExistingException {
        if (idRepository.contains(existingId)) {
            Message msg = new Message("C3020E.CRWL_GEN_CONFIG_ID_ALREADY_EXIST");
            msg.addArgument(existingId);
            throw new IDExistingException(msg);
        }
        idRepository.add(existingId);
    }

    public static synchronized String getNewID(String prefix) {
        StringWriter sWriter;
        String tempId = null;
        do {
            int tempIdNum = random.nextInt(Integer.MAX_VALUE);
            sWriter = new StringWriter(5);
            PrintWriter pWriter = new PrintWriter(sWriter);
            pWriter.print(prefix);
            pWriter.printf("%010d", tempIdNum);
            pWriter.close();
        } while (idRepository.contains(tempId = sWriter.toString()));
        idRepository.add(tempId);
        return tempId;
    }

    public static synchronized void removeExistingId(String existingId) {
        idRepository.remove(existingId);
    }

    private IDRepository() {
    }
}

