/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.discoverable;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.ItemNotFoundException;
import com.ibm.es.nuvo.crawler.adapter.Space;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredSpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableFieldConfiguration;
import com.ibm.es.nuvo.crawler.config.id.IDExistingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiscoverableSpaceConfiguration
implements SpaceConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final Space space;
    private final boolean isAvailableAsCrawlSpace;
    private final boolean isAvailableAsNodeSpace;
    ConfiguredSpaceConfiguration config;
    private final Map<String, Configuration> params;
    private final Map<String, Configuration> crawlSpaceConfigs;
    private final DiscoverableCrawlerConfiguration crawler;
    private final DiscoverableSpaceConfiguration parent;
    private boolean open = false;
    private boolean discovered = false;
    private List<DiscoverableSpaceConfiguration> subspaces;
    private List<DiscoverableFieldConfiguration> fields;
    private List<DiscoverableFieldConfiguration> crawlSpaceFields;

    DiscoverableSpaceConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, Space space, ConfiguredSpaceConfiguration configuredSpace) {
        this.crawler = crawler;
        this.space = space;
        this.parent = parent;
        this.isAvailableAsCrawlSpace = space.isCrawlSpace();
        this.isAvailableAsNodeSpace = space.isNodeSpace();
        this.config = configuredSpace;
        this.config.setParent(null);
        this.config.setAvailableAsCrawlSpace(space.isCrawlSpace());
        this.params = new HashMap<String, Configuration>();
        this.crawlSpaceConfigs = new HashMap<String, Configuration>();
        this.params.putAll(this.config.getConfigurations());
        if (this.isSetAsCrawlSpace()) {
            this.crawlSpaceConfigs.putAll(this.config.getCrawlSpaceConfigurations());
        }
        Iterator<ConfigurationElement> elts = this.space.getConfigurations().getElements();
        while (elts.hasNext()) {
            ConfigurationElement element = elts.next();
            Configuration configuration = this.config.getConfiguration(element.getName());
            if (configuration == null) continue;
            DiscoverableConfiguration param = new DiscoverableConfiguration(crawler, this, element, configuration);
            this.params.remove(param.getName());
            this.params.put(param.getName(), param);
        }
        this.open = false;
    }

    DiscoverableSpaceConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, Space space, String name) {
        this.crawler = crawler;
        this.space = space;
        this.parent = parent;
        this.isAvailableAsCrawlSpace = space.isCrawlSpace();
        this.isAvailableAsNodeSpace = space.isNodeSpace();
        try {
            this.config = ConfiguredConfigurationFactory.getNewConfiguredSpaceConfiguration(null, name);
        }
        catch (IDExistingException e) {
            // empty catch block
        }
        this.config.setAvailableAsCrawlSpace(space.isCrawlSpace());
        this.params = new HashMap<String, Configuration>();
        this.crawlSpaceConfigs = new HashMap<String, Configuration>();
        Iterator<ConfigurationElement> elts = this.space.getConfigurations().getElements();
        while (elts.hasNext()) {
            DiscoverableConfiguration param = new DiscoverableConfiguration(this.crawler, this, elts.next(), false);
            this.params.put(param.getName(), param);
        }
        this.open = false;
    }

    DiscoverableSpaceConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, Space space, String name, String existingID) throws IDExistingException {
        this.crawler = crawler;
        this.space = space;
        this.parent = parent;
        this.isAvailableAsCrawlSpace = space.isCrawlSpace();
        this.isAvailableAsNodeSpace = space.isNodeSpace();
        this.config = ConfiguredConfigurationFactory.recreateConfiguredSpaceConfiguration(existingID, name);
        this.config.setAvailableAsCrawlSpace(space.isCrawlSpace());
        this.params = new HashMap<String, Configuration>();
        this.crawlSpaceConfigs = new HashMap<String, Configuration>();
        Iterator<ConfigurationElement> elts = this.space.getConfigurations().getElements();
        while (elts.hasNext()) {
            DiscoverableConfiguration param = new DiscoverableConfiguration(this.crawler, this, elts.next(), false);
            this.params.put(param.getName(), param);
        }
        this.open = false;
    }

    private void discover() throws CrawlerConfigurationException, AdapterException {
        if (!this.isOpen()) {
            throw new CrawlerConfigurationException(new IllegalStateException("The space has been already closed"));
        }
        if (!this.discovered) {
            int i;
            this.subspaces = new ArrayList<DiscoverableSpaceConfiguration>();
            this.fields = new ArrayList<DiscoverableFieldConfiguration>();
            this.crawlSpaceFields = new ArrayList<DiscoverableFieldConfiguration>();
            if (this.space.isNodeSpace()) {
                Space[] children = this.space.getSubSpaces();
                for (i = 0; i < children.length; ++i) {
                    ConfiguredSpaceConfiguration oldChild = this.config.getSubSpace(children[i].getName());
                    if (oldChild == null) {
                        this.subspaces.add(new DiscoverableSpaceConfiguration(this.crawler, this, children[i], children[i].getName()));
                        continue;
                    }
                    this.subspaces.add(new DiscoverableSpaceConfiguration(this.crawler, this, children[i], oldChild));
                }
            }
            if (this.space.isCrawlSpace()) {
                FieldDefinition[] fieldDefs = this.space.getFields();
                for (i = 0; i < fieldDefs.length; ++i) {
                    ConfiguredFieldConfiguration oldField = this.config.getField(fieldDefs[i].getName());
                    DiscoverableFieldConfiguration discField = new DiscoverableFieldConfiguration(this.crawler, this, fieldDefs[i], null);
                    if (oldField != null) {
                        discField.setEnabled(oldField.isEnabled());
                    }
                    (fieldDefs[i].getValue() != null ? this.crawlSpaceFields : this.fields).add(discField);
                }
                Iterator<ConfigurationElement> elts = this.space.getCrawlSpaceConfigurations().getElements();
                while (elts.hasNext()) {
                    ConfigurationElement elt = elts.next();
                    Configuration org = this.crawlSpaceConfigs.get(elt.getName());
                    DiscoverableConfiguration param = org == null ? new DiscoverableConfiguration(this.crawler, this, elt, true) : new DiscoverableConfiguration(this.crawler, this, elt, org);
                    this.crawlSpaceConfigs.put(param.getName(), param);
                }
            }
            this.discovered = true;
        }
    }

    @Override
    public final CrawlerConfiguration getCrawler() {
        return this.crawler;
    }

    @Override
    public final Iterator<SpaceConfiguration> getSubSpaces() throws CrawlerConfigurationException {
        if (!this.isOpen()) {
            return new DiscoverableSpaceIterator(this.config.getConfiguredSubSpaces());
        }
        return Collections.unmodifiableList(new ArrayList<DiscoverableSpaceConfiguration>(this.subspaces)).iterator();
    }

    @Override
    public final boolean hasSubSpaces() {
        return this.isAvailableAsNodeSpace;
    }

    @Override
    public final boolean isAvailableAsCrawlSpace() {
        return this.isAvailableAsCrawlSpace;
    }

    @Override
    public final void setAsCrawlSpace(boolean crawlspace) throws CrawlerConfigurationException {
        this.ensureOpen();
        this.config.setAsCrawlSpace(crawlspace);
    }

    @Override
    public final boolean isSetAsCrawlSpace() {
        return this.config.isSetAsCrawlSpace();
    }

    @Override
    public final Iterator<FieldConfiguration> getFields() throws CrawlerConfigurationException {
        if (!this.isOpen()) {
            return this.config.getFields();
        }
        return Collections.unmodifiableList(new ArrayList<DiscoverableFieldConfiguration>(this.fields)).iterator();
    }

    @Override
    public Iterator<FieldConfiguration> getCrawlSpaceFields() throws CrawlerConfigurationException {
        if (!this.isOpen()) {
            return null;
        }
        return Collections.unmodifiableList(new ArrayList<DiscoverableFieldConfiguration>(this.crawlSpaceFields)).iterator();
    }

    @Override
    public final String getID() {
        return this.config.getID();
    }

    @Override
    public final String getName() {
        return this.config.getName();
    }

    @Override
    public final ConfigurationItem getParent() {
        return this.parent;
    }

    @Override
    public final Map<String, Configuration> getConfigurations() {
        return this.params;
    }

    @Override
    public final boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public final void setEnabled(boolean isEnabled) throws CrawlerConfigurationException {
        if (this.parent != null) {
            if (isEnabled) {
                this.parent.config.addSubSpace(this.config);
            } else {
                this.parent.config.removeSubSpace(this.config.getName());
            }
        } else {
            this.config.setCrawler(this.crawler);
        }
        this.config.setEnabled(isEnabled);
    }

    @Override
    public void open() throws CrawlerConfigurationException {
        this.ensureClose();
        try {
            this.backingOpen();
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
        try {
            this.space.open();
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
        this.open = true;
        try {
            this.discover();
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
    }

    private void backingOpen() throws CrawlerConfigurationException, AdapterException {
        ConfigurationItem parentConfig = this.getParent();
        if (parentConfig != null) {
            if (!parentConfig.isOpen()) {
                parentConfig.open();
            }
        } else {
            this.notifyOpen(this.crawler);
        }
    }

    private void notifyOpen(DiscoverableCrawlerConfiguration discoverableCrawler) throws CrawlerConfigurationException {
        if (!discoverableCrawler.isOpen()) {
            discoverableCrawler.lazyOpen();
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws CrawlerConfigurationException {
        if (this.space != null) {
            try {
                this.space.close();
            }
            catch (AdapterException e) {
                throw new CrawlerConfigurationException(e);
            }
        }
        this.open = false;
        Iterator<SpaceConfiguration> spaceIter = this.getSubSpaces();
        while (spaceIter.hasNext()) {
            SpaceConfiguration aSpace = spaceIter.next();
            if (!aSpace.isOpen()) continue;
            aSpace.close();
        }
    }

    @Override
    public Configuration createNewConfiguration(String name, Configuration.Type type, boolean isUserConfigurable) {
        return SimpleConfigurationBuilder.create(name, type, false, isUserConfigurable, false);
    }

    @Override
    public void addConfiguration(Configuration param) throws CrawlerConfigurationException {
        this.ensureOpen();
        this.params.put(param.getName(), param);
    }

    @Override
    public void addCrawlSpaceConfiguration(Configuration param) throws CrawlerConfigurationException {
        this.ensureOpen();
        this.crawlSpaceConfigs.put(param.getName(), param);
    }

    @Override
    public Map<String, Configuration> getCrawlSpaceConfigurations() throws CrawlerConfigurationException {
        if (!this.isSetAsCrawlSpace()) {
            throw new CrawlerConfigurationException(new UnsupportedOperationException());
        }
        return this.crawlSpaceConfigs;
    }

    private void ensureOpen() throws CrawlerConfigurationException {
        if (!this.isOpen()) {
            throw new CrawlerConfigurationException(new IllegalStateException("This space is already closed"));
        }
    }

    private void ensureClose() throws CrawlerConfigurationException {
        if (this.isOpen()) {
            throw new CrawlerConfigurationException(new IllegalStateException("This space is already opened"));
        }
    }

    @Override
    public long getChecksum(boolean isFullCrawlingEnforcedValue) {
        return this.config.getChecksum(isFullCrawlingEnforcedValue);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DiscoverableSpaceIterator
    implements Iterator<SpaceConfiguration> {
        private final Iterator<SpaceConfiguration> candidatesItr;

        private DiscoverableSpaceIterator(Collection<ConfiguredSpaceConfiguration> configuredSpaceIter) {
            ArrayList<ConfiguredSpaceConfiguration> candidates = new ArrayList<ConfiguredSpaceConfiguration>();
            Iterator<ConfiguredSpaceConfiguration> i$ = configuredSpaceIter.iterator();
            while (i$.hasNext()) {
                ConfiguredSpaceConfiguration configuredSpace;
                SpaceConfiguration candidate = configuredSpace = i$.next();
                try {
                    candidate = new DiscoverableSpaceConfiguration(DiscoverableSpaceConfiguration.this.crawler, DiscoverableSpaceConfiguration.this, DiscoverableSpaceConfiguration.this.space.getSubSpace(configuredSpace.getName()), configuredSpace);
                }
                catch (ItemNotFoundException ignore) {
                }
                catch (AdapterException ignore) {
                    // empty catch block
                }
                candidates.add((ConfiguredSpaceConfiguration)candidate);
            }
            this.candidatesItr = candidates.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.candidatesItr.hasNext();
        }

        @Override
        public SpaceConfiguration next() {
            return this.candidatesItr.next();
        }

        @Override
        public void remove() {
        }
    }
}

