/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.discoverable;

import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredConfigurationFactory;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableSpaceConfiguration;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverableFieldConfiguration
implements FieldConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final DiscoverableSpaceConfiguration parent;
    private boolean open = false;
    private final ConfiguredFieldConfiguration config;
    private final Map<String, Configuration> params;

    DiscoverableFieldConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, ConfiguredFieldConfiguration configuredField) {
        this.parent = parent;
        this.config = configuredField;
        this.parent.config.addField(this.config);
        this.params = new HashMap<String, Configuration>();
        this.params.putAll(configuredField.getConfigurations());
        this.open = false;
    }

    DiscoverableFieldConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, FieldDefinition field, String id) {
        this.parent = parent;
        this.config = ConfiguredConfigurationFactory.getNewConfiguredFieldConfiguration(field);
        this.parent.config.addField(this.config);
        this.params = this.config.getConfigurations();
        this.open = true;
    }

    @Override
    public FieldType getType() {
        return this.config.getType();
    }

    @Override
    public String getID() {
        return this.config.getID();
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public ConfigurationItem getParent() {
        return this.parent;
    }

    @Override
    public Map<String, Configuration> getConfigurations() {
        return this.params;
    }

    @Override
    public boolean isEnabled() {
        return this.config.isEnabled();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.config.setEnabled(isEnabled);
    }

    @Override
    public String getTypeName() {
        return this.config.getTypeName();
    }

    @Override
    public void addConfiguration(Configuration newConfig) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public Configuration createNewConfiguration(String name, Configuration.Type type, boolean isUserConfigurable) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public void close() throws CrawlerConfigurationException {
        this.open = false;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void open() throws CrawlerConfigurationException {
        this.open = true;
    }

    @Override
    public EnumSet<FieldConfiguration.Attribute> getAttributes() {
        return this.config.getAttributes();
    }

    @Override
    public boolean isSystemField() {
        return this.config.getAttributes().contains((Object)FieldConfiguration.Attribute.SYSTEM);
    }

    @Override
    public String getValue() {
        return this.config.getValue();
    }
}

