/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.discoverable;

import com.ibm.es.nuvo.crawler.adapter.Adapter;
import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.CrawlerConfigurationUtils;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableSpaceConfiguration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoverableCrawlerConfiguration
implements CrawlerConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final String name;
    private final CrawlerType type;
    private final List<String> classpaths;
    private Adapter adapter;
    private final DiscoverableSpaceConfiguration space;
    private boolean isOpen = true;

    DiscoverableCrawlerConfiguration(Adapter adapter, ConfiguredCrawlerConfiguration configuredCrawler) throws CrawlerConfigurationException {
        this.name = configuredCrawler.getName();
        this.type = configuredCrawler.getType();
        this.classpaths = configuredCrawler.getClasspathEntries();
        this.adapter = adapter;
        try {
            this.space = new DiscoverableSpaceConfiguration(this, null, this.adapter.getRootSpace(), configuredCrawler);
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
        this.isOpen = false;
    }

    DiscoverableCrawlerConfiguration(Adapter adapter, String name, CrawlerType type, List<Configuration> configs, List<String> classpaths) throws CrawlerConfigurationException {
        this.name = name;
        this.type = type;
        this.classpaths = classpaths;
        try {
            this.adapter = adapter;
            this.space = new DiscoverableSpaceConfiguration(this, null, this.adapter.getRootSpace(), name);
            Map<String, Configuration> configMap = this.space.getConfigurations();
            block7: for (Configuration c : configs) {
                Configuration elt = configMap.get(c.getName());
                if (elt == null) {
                    throw new UnknownConfigurationException("Unexpected configuration type is specified. Name: " + c.getName() + " Type: " + (Object)((Object)c.getType()));
                }
                switch (c.getType()) {
                    case STRING: {
                        elt.setString(c.getString());
                        continue block7;
                    }
                    case BOOLEAN: {
                        elt.setBoolean(c.getBoolean());
                        continue block7;
                    }
                    case LONG: {
                        elt.setLong(c.getLong());
                        continue block7;
                    }
                }
                throw new IllegalArgumentException();
            }
            this.isOpen = false;
        }
        catch (AdapterException e) {
            throw new CrawlerConfigurationException(e);
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (CrawlerConfigurationException crawlerConfigurationException) {
            // empty catch block
        }
    }

    @Override
    public CrawlerType getType() {
        return this.type;
    }

    @Override
    public Configuration createNewConfiguration(String newName, Configuration.Type newType, boolean isUserConfigurable) {
        return SimpleConfigurationBuilder.create(newName, newType, false, isUserConfigurable, false);
    }

    @Override
    public String getID() {
        return this.space.getID();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationItem getParent() {
        return null;
    }

    @Override
    public Map<String, Configuration> getConfigurations() {
        return this.space.getConfigurations();
    }

    @Override
    public Map<String, Configuration> getCrawlSpaceConfigurations() throws CrawlerConfigurationException {
        return this.space.getCrawlSpaceConfigurations();
    }

    @Override
    public boolean isEnabled() {
        return this.space.isEnabled();
    }

    @Override
    public void setEnabled(boolean isEnabled) throws CrawlerConfigurationException {
        this.space.setEnabled(isEnabled);
    }

    @Override
    public CrawlerConfiguration getCrawler() {
        return this;
    }

    @Override
    public boolean hasSubSpaces() {
        return this.space.hasSubSpaces();
    }

    @Override
    public boolean isAvailableAsCrawlSpace() {
        return this.space.isAvailableAsCrawlSpace();
    }

    @Override
    public void setAsCrawlSpace(boolean crawlspace) throws CrawlerConfigurationException {
        this.space.setAsCrawlSpace(crawlspace);
    }

    @Override
    public boolean isSetAsCrawlSpace() {
        return this.space.isSetAsCrawlSpace();
    }

    @Override
    public Iterator<SpaceConfiguration> getSubSpaces() throws CrawlerConfigurationException {
        return this.space.getSubSpaces();
    }

    @Override
    public Iterator<FieldConfiguration> getFields() throws CrawlerConfigurationException {
        return this.space.getFields();
    }

    @Override
    public Iterator<FieldConfiguration> getCrawlSpaceFields() throws CrawlerConfigurationException {
        return this.space.getCrawlSpaceFields();
    }

    @Override
    public void addConfiguration(Configuration config) throws CrawlerConfigurationException {
        this.space.addConfiguration(config);
    }

    @Override
    public void addCrawlSpaceConfiguration(Configuration config) throws CrawlerConfigurationException {
        this.space.addCrawlSpaceConfiguration(config);
    }

    @Override
    public void open() throws CrawlerConfigurationException {
        this.doOpen();
        this.space.open();
        this.isOpen = true;
    }

    void lazyOpen() throws CrawlerConfigurationException {
        this.doOpen();
        this.isOpen = true;
    }

    private void doOpen() throws CrawlerConfigurationException {
        if (this.adapter == null) {
            throw new CrawlerConfigurationException(new IllegalStateException("This configuration has already been closed."));
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws CrawlerConfigurationException {
        this.space.close();
        if (this.adapter != null) {
            try {
                this.adapter.close();
            }
            catch (AdapterException adapterException) {
            }
            finally {
                this.adapter = null;
            }
        }
        this.isOpen = false;
    }

    @Override
    public List<String> getClasspathEntries() {
        return this.classpaths;
    }

    @Override
    public long getChecksum(boolean isFullCrawlingEnforcingValue) {
        long checksum = 0L;
        try {
            HashSet<Configuration.Attribute> ignoredAttributes = new HashSet<Configuration.Attribute>();
            if (isFullCrawlingEnforcingValue) {
                ignoredAttributes.add(Configuration.Attribute.NO_FORCE);
            }
            checksum = CrawlerConfigurationUtils.getChecksum(this.space.getCrawlSpaceConfigurations(), ignoredAttributes);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("DiscoverableCrawlerConfiguration#getChecksum");
        }
        return checksum += CrawlerConfigurationUtils.getChecksum(this.space.getFields());
    }

    private static final class UnknownConfigurationException
    extends IllegalStateException {
        private static final long serialVersionUID = 6746543621986628575L;

        public UnknownConfigurationException(String message) {
            super(message);
        }
    }
}

