/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.discoverable;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.SimpleListConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.discoverable.DiscoverableSpaceConfiguration;
import com.ibm.es.nuvo.crawler.util.Checksum;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiscoverableConfiguration
implements Configuration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private final Configuration config;
    private final DiscoverableSpaceConfiguration parent;
    private final ConfigurationElement element;

    DiscoverableConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, ConfigurationElement elt, Configuration configuredConfig) {
        this.parent = parent;
        this.element = elt;
        this.config = configuredConfig;
        try {
            switch (this.element.getType()) {
                case STRING: {
                    this.element.setString(this.config.getString());
                    break;
                }
                case BOOLEAN: {
                    this.element.setBoolean(this.config.getBoolean());
                    break;
                }
                case LONG: {
                    this.element.setLong(this.config.getLong());
                    break;
                }
                case LIST: {
                    Set<Configuration.ListItem> configuredList = this.config.getItems();
                    ListConfiguration.Item[] items = this.element.getList().getItems();
                    ArrayList<Configuration.ListItem> removeCandidate = new ArrayList<Configuration.ListItem>();
                    ArrayList<DiscoverableListItem> addCandidate = new ArrayList<DiscoverableListItem>();
                    block8: for (Configuration.ListItem aItem : configuredList) {
                        for (int i = 0; i < items.length; ++i) {
                            if (!aItem.getValue().equals(items[i].getValue())) continue;
                            removeCandidate.add(aItem);
                            addCandidate.add(new DiscoverableListItem(items[i], aItem));
                            continue block8;
                        }
                    }
                    configuredList.removeAll(removeCandidate);
                    configuredList.addAll(addCandidate);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        if (this.element.getAttributes().contains((Object)ConfigurationElement.Attribute.ENCRYPT)) {
            this.config.getAttributes().add(Configuration.Attribute.ENCRYPT);
        }
        if (this.element.getAttributes().contains((Object)ConfigurationElement.Attribute.HIDDEN)) {
            this.config.getAttributes().add(Configuration.Attribute.HIDDEN);
        }
    }

    DiscoverableConfiguration(DiscoverableCrawlerConfiguration crawler, DiscoverableSpaceConfiguration parent, ConfigurationElement elt, boolean isCrawlSpaceConfig) {
        this.parent = parent;
        this.element = elt;
        try {
            EnumSet<Configuration.Attribute> options = SimpleConfigurationBuilder.optionBridge(this.element.getAttributes());
            switch (this.element.getType()) {
                case STRING: {
                    this.config = SimpleConfigurationBuilder.create(this.element.getName(), Configuration.Type.STRING, options);
                    this.config.setString(this.element.getString());
                    break;
                }
                case BOOLEAN: {
                    this.config = SimpleConfigurationBuilder.create(this.element.getName(), Configuration.Type.BOOLEAN, options);
                    this.config.setBoolean(this.element.getBoolean());
                    break;
                }
                case LONG: {
                    this.config = SimpleConfigurationBuilder.create(this.element.getName(), Configuration.Type.LONG, options);
                    this.config.setLong(this.element.getLong());
                    break;
                }
                case LIST: {
                    ListConfiguration list = this.element.getList();
                    SimpleListConfiguration listConfig = SimpleConfigurationBuilder.createList(this.element.getName(), list.getStyle() == ListConfiguration.Style.MULTI, options);
                    ListConfiguration.Item[] items = list.getItems();
                    if (items != null) {
                        for (int i = 0; i < items.length; ++i) {
                            listConfig.addItem(new DiscoverableListItem(items[i]));
                        }
                    }
                    this.config = listConfig;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        if (this.element.getAttributes().contains((Object)ConfigurationElement.Attribute.ENCRYPT)) {
            this.config.getAttributes().add(Configuration.Attribute.ENCRYPT);
        }
        if (this.element.getAttributes().contains((Object)ConfigurationElement.Attribute.HIDDEN)) {
            this.config.getAttributes().add(Configuration.Attribute.HIDDEN);
        }
        if (isCrawlSpaceConfig) {
            parent.config.addCrawlSpaceConfiguration(this.config);
        } else {
            parent.config.addConfiguration(this.config);
        }
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public EnumSet<Configuration.Attribute> getAttributes() {
        return this.config.getAttributes();
    }

    @Override
    public Configuration.Type getType() {
        return this.config.getType();
    }

    @Override
    public ConfigurationItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ConfigurationItem parent) {
        throw new UnsupportedOperationException("Not implemented.");
    }

    @Override
    public String getString() {
        try {
            return this.element.getString();
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public void setString(String value) {
        try {
            this.element.setString(value);
            this.config.setString(value);
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public boolean getBoolean() {
        try {
            return this.element.getBoolean();
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public void setBoolean(boolean value) {
        try {
            this.element.setBoolean(value);
            this.config.setBoolean(value);
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public long getLong() {
        try {
            return this.element.getLong();
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public void setLong(long value) {
        try {
            this.element.setLong(value);
            this.config.setLong(value);
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public Set<Configuration.ListItem> getItems() {
        return this.config.getItems();
    }

    @Override
    public Configuration.ListItem addItem(String value) {
        try {
            ListConfiguration.Item item = this.element.getList().add(value);
            return ((SimpleListConfiguration)this.config).addItem(new DiscoverableListItem(item));
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    @Override
    public Checksum getChecksum() {
        return this.config.getChecksum();
    }

    @Override
    public void clear() {
        try {
            ListConfiguration lclist = this.element.getList();
            lclist.clear();
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        ((SimpleListConfiguration)this.config).clear();
    }

    @Override
    public Configuration.ListItem removeItem(String value) {
        try {
            ListConfiguration lclist = this.element.getList();
            ListConfiguration.Item item = lclist.get(value);
            if (item != null) {
                lclist.remove(item);
            }
            return ((SimpleListConfiguration)this.config).removeItem(value);
        }
        catch (AdapterException e) {
            throw new IllegalAccessError(e.getMessage());
        }
    }

    private final class DiscoverableListItem
    implements Configuration.ListItem {
        private final ListConfiguration.Item item;

        protected DiscoverableListItem(ListConfiguration.Item item) {
            this.item = item;
        }

        private DiscoverableListItem(ListConfiguration.Item item, Configuration.ListItem configuredItem) {
            if (!item.getValue().equals(configuredItem.getValue())) {
                throw new IllegalArgumentException();
            }
            this.item = item;
            this.setSelected(configuredItem.isSelected());
        }

        public String getValue() {
            return this.item.getValue();
        }

        public boolean isSelected() {
            return this.item.isSelected();
        }

        public void setSelected(boolean selected) {
            if (DiscoverableConfiguration.this.getType() == Configuration.Type.LIST_SINGLE && selected) {
                try {
                    ListConfiguration.Item[] items = DiscoverableConfiguration.this.element.getList().getItems();
                    if (items != null) {
                        for (int j = 0; j < items.length; ++j) {
                            items[j].setSelected(false);
                        }
                    }
                }
                catch (AdapterException adapterException) {
                    // empty catch block
                }
            }
            this.item.setSelected(selected);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.item.isSelected() ? (char)'+' : '-').append(this.item.getValue());
            return builder.toString();
        }

        public Checksum getChecksum() {
            Checksum checksum = new Checksum();
            checksum.update(this.getValue());
            checksum.update(this.isSelected());
            return checksum;
        }
    }
}

