/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.configured;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.ModificationNotAllowedException;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.AbstractConfigurationItem;
import com.ibm.es.nuvo.crawler.config.CrawlerConfigurationUtils;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfiguredSpaceConfiguration
extends AbstractConfigurationItem
implements SpaceConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CrawlerConfiguration crawler;
    private boolean isCrawlspace = false;
    private boolean isAvailableAsCrawlSpace = false;
    private final Map<String, ConfiguredSpaceConfiguration> subspaces = new HashMap<String, ConfiguredSpaceConfiguration>();
    private final Map<String, ConfiguredFieldConfiguration> fields = new HashMap<String, ConfiguredFieldConfiguration>();
    protected final Map<String, Configuration> crawlSpaceConfigs = new HashMap<String, Configuration>();

    ConfiguredSpaceConfiguration(String id, String name) {
        super(id, name);
    }

    @Override
    public void close() throws CrawlerConfigurationException {
        throw new CrawlerConfigurationException(new UnsupportedOperationException());
    }

    @Override
    public boolean isOpen() {
        return false;
    }

    @Override
    public void open() throws CrawlerConfigurationException {
        throw new CrawlerConfigurationException(new UnsupportedOperationException());
    }

    @Override
    public Iterator<FieldConfiguration> getCrawlSpaceFields() throws CrawlerConfigurationException {
        return null;
    }

    public final void addSubSpace(ConfiguredSpaceConfiguration space) {
        this.ensureStatus();
        if (space == null || space.getName() == null || space.getName().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.subspaces.put(space.getName(), space);
        space.setParent(this);
    }

    public final boolean removeSubSpace(String name) {
        this.ensureStatus();
        if (this.subspaces != null) {
            ConfiguredSpaceConfiguration child = this.subspaces.get(name);
            if (child == null) {
                return false;
            }
            this.subspaces.remove(child.getName());
            child.setParent(null);
            return true;
        }
        return false;
    }

    public final void addField(ConfiguredFieldConfiguration field) {
        this.ensureStatus();
        if (field == null || field.getName() == null || field.getName().length() == 0) {
            throw new IllegalArgumentException();
        }
        this.fields.put(field.getName(), field);
        field.setParent(this);
    }

    public final boolean removeField(String name) {
        this.ensureStatus();
        if (this.fields != null) {
            ConfiguredFieldConfiguration child = this.fields.get(name);
            if (child == null) {
                return false;
            }
            this.fields.remove(child.getName());
            child.setParent(null);
            return true;
        }
        return false;
    }

    public final void setCrawler(CrawlerConfiguration crawler) {
        if (this.subspaces != null) {
            for (ConfiguredSpaceConfiguration child : this.subspaces.values()) {
                child.setCrawler(crawler);
            }
        }
        this.crawler = crawler;
    }

    @Override
    protected void ensureStatus() {
        if (this.parent != null) {
            throw new ModificationNotAllowedException();
        }
    }

    protected final void ensureCrawlSpace() {
        if (!this.isCrawlspace) {
            throw new ModificationNotAllowedException();
        }
    }

    @Override
    public final CrawlerConfiguration getCrawler() {
        return this.crawler;
    }

    @Override
    public Iterator<SpaceConfiguration> getSubSpaces() throws CrawlerConfigurationException {
        return Collections.unmodifiableList(new ArrayList<ConfiguredSpaceConfiguration>(this.subspaces.values())).iterator();
    }

    @Override
    public boolean hasSubSpaces() {
        return this.subspaces != null && !this.subspaces.isEmpty();
    }

    @Override
    public Iterator<FieldConfiguration> getFields() throws CrawlerConfigurationException {
        if (this.fields != null) {
            return Collections.unmodifiableList(new ArrayList<ConfiguredFieldConfiguration>(this.fields.values())).iterator();
        }
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    @Override
    public boolean isAvailableAsCrawlSpace() {
        return this.isAvailableAsCrawlSpace;
    }

    public void setAvailableAsCrawlSpace(boolean isAvailableAsCrawlSpace) {
        this.isAvailableAsCrawlSpace = isAvailableAsCrawlSpace;
    }

    @Override
    public boolean isSetAsCrawlSpace() {
        return this.isCrawlspace;
    }

    @Override
    public void setAsCrawlSpace(boolean crawlspace) {
        if (crawlspace && !this.isAvailableAsCrawlSpace) {
            throw new IllegalStateException();
        }
        this.isCrawlspace = crawlspace;
    }

    @Override
    public Map<String, Configuration> getCrawlSpaceConfigurations() {
        return this.crawlSpaceConfigs;
    }

    @Override
    public void addCrawlSpaceConfiguration(Configuration config) {
        this.ensureStatus();
        if (config == null || config.getName() == null) {
            throw new IllegalArgumentException();
        }
        this.crawlSpaceConfigs.put(config.getName(), config);
        config.setParent(this);
    }

    public final ConfiguredSpaceConfiguration getSubSpace(String name) {
        return this.subspaces.get(name);
    }

    public final Collection<ConfiguredSpaceConfiguration> getConfiguredSubSpaces() {
        return this.subspaces.values();
    }

    public final ConfiguredFieldConfiguration getField(String name) {
        return this.fields.get(name);
    }

    @Override
    public long getChecksum(boolean isFullCrawlingEnforcingValue) {
        HashSet<Configuration.Attribute> ignoredAttributes = new HashSet<Configuration.Attribute>();
        if (isFullCrawlingEnforcingValue) {
            ignoredAttributes.add(Configuration.Attribute.NO_FORCE);
        }
        long checksum = CrawlerConfigurationUtils.getChecksum(this.configs, ignoredAttributes);
        return checksum += CrawlerConfigurationUtils.getChecksum(this.fields);
    }
}

