/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.configured;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.admin.ModificationNotAllowedException;
import com.ibm.es.nuvo.crawler.config.AbstractConfigurationItem;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfiguredFieldConfiguration
extends AbstractConfigurationItem
implements FieldConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String label;
    private final String typeName;
    protected String externalName;
    private final FieldType type;
    private final EnumSet<FieldConfiguration.Attribute> attributes;
    private String value;

    ConfiguredFieldConfiguration(String id, String name, String typeName, FieldType type, EnumSet<FieldConfiguration.Attribute> attributes, Collection<Configuration> configs, String value) {
        super(id, name);
        this.attributes = EnumSet.copyOf(attributes);
        this.typeName = typeName;
        this.type = type;
        this.configs = new HashMap();
        for (Configuration configuration : configs) {
            this.configs.put(configuration.getName(), configuration);
        }
        this.value = value;
    }

    ConfiguredFieldConfiguration(String id, String name, String typeName, FieldType type, EnumSet<FieldConfiguration.Attribute> attributes, Collection<Configuration> configs) {
        this(id, name, typeName, type, attributes, configs, null);
    }

    @Override
    public FieldType getType() {
        return this.type;
    }

    @Override
    protected void ensureStatus() throws ModificationNotAllowedException {
        if (this.parent != null) {
            throw new ModificationNotAllowedException();
        }
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public EnumSet<FieldConfiguration.Attribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean isSystemField() {
        return this.attributes.contains((Object)FieldConfiguration.Attribute.SYSTEM);
    }

    @Override
    public void addConfiguration(Configuration config) {
        super.addConfiguration(config);
    }

    @Override
    public String getValue() {
        return this.value;
    }
}

