/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config.configured;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.FieldDefinition;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.FieldType;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import com.ibm.es.nuvo.crawler.config.SimpleListConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredCrawlerType;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredSpaceConfiguration;
import com.ibm.es.nuvo.crawler.config.id.IDExistingException;
import com.ibm.es.nuvo.crawler.config.id.IDGeneratorFactory;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ConfiguredConfigurationFactory {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    private ConfiguredConfigurationFactory() {
    }

    public static synchronized ConfiguredCrawlerConfiguration getNewConfiguredCrawlerConfiguration(String id, String name, CrawlerType type) throws IDExistingException {
        if (id == null) {
            id = IDGeneratorFactory.getDefaultGenerator().generateNewID();
        }
        return new ConfiguredCrawlerConfiguration(id, name, type);
    }

    public static synchronized ConfiguredSpaceConfiguration getNewConfiguredSpaceConfiguration(String id, String name) throws IDExistingException {
        if (id == null) {
            id = IDGeneratorFactory.getDefaultGenerator().generateNewID();
        }
        return new ConfiguredSpaceConfiguration(id, name);
    }

    public static synchronized ConfiguredSpaceConfiguration recreateConfiguredSpaceConfiguration(String id, String name) throws IDExistingException {
        if (id == null) {
            throw new IllegalArgumentException("ID must be secified.");
        }
        return new ConfiguredSpaceConfiguration(id, name);
    }

    public static synchronized ConfiguredFieldConfiguration getNewConfiguredFieldConfiguration(String name, String typeName, FieldType type, EnumSet<FieldConfiguration.Attribute> attribute, Collection<Configuration> configs) {
        return new ConfiguredFieldConfiguration(null, name, typeName, type, attribute, configs);
    }

    public static synchronized ConfiguredFieldConfiguration getNewConfiguredFieldConfiguration(FieldDefinition fDef) {
        return new ConfiguredFieldConfiguration(null, fDef.getName(), fDef.getTypeName(), ConfiguredConfigurationFactory.convertType(fDef.getType()), ConfiguredConfigurationFactory.convertAttributes(fDef.getFieldProperties()), ConfiguredConfigurationFactory.convertConfigs(fDef.getConfigurations().getElements()), fDef.getValue());
    }

    public static synchronized CrawlerType getCrawlerType(String name) {
        return new ConfiguredCrawlerType(name);
    }

    public static ConfiguredCrawlerConfiguration getConfiguredClone(CrawlerConfiguration originalCrawler) throws CrawlerConfigurationException {
        if (originalCrawler == null) {
            throw new IllegalArgumentException("The specified original crawler configuration is null.");
        }
        ConfiguredCrawlerConfiguration retVal = new ConfiguredCrawlerConfiguration(originalCrawler.getID(), originalCrawler.getName(), originalCrawler.getType());
        List<String> classpaths = originalCrawler.getClasspathEntries();
        if (classpaths != null) {
            for (String entry : classpaths) {
                retVal.getClasspathEntries().add(entry);
            }
        }
        retVal.setEnabled(originalCrawler.isEnabled());
        retVal.setCrawler(retVal);
        retVal.setAvailableAsCrawlSpace(originalCrawler.isAvailableAsCrawlSpace());
        retVal.setAsCrawlSpace(originalCrawler.isSetAsCrawlSpace());
        for (Configuration config : originalCrawler.getConfigurations().values()) {
            retVal.addConfiguration(ConfiguredConfigurationFactory.getConfiguredClone(config));
        }
        Iterator<SpaceConfiguration> spaceIter = originalCrawler.getSubSpaces();
        while (spaceIter.hasNext()) {
            WrappedConfigurationSpaceCfg configuredSpace = ConfiguredConfigurationFactory.getConfiguredClone(retVal, spaceIter.next());
            if (!configuredSpace.hasCrawlSpace && configuredSpace.space.isAvailableAsCrawlSpace()) continue;
            retVal.addSubSpace(configuredSpace.space);
        }
        return retVal;
    }

    private static WrappedConfigurationSpaceCfg getConfiguredClone(ConfiguredCrawlerConfiguration parentCrawler, SpaceConfiguration originalSpace) throws CrawlerConfigurationException {
        if (originalSpace == null) {
            throw new IllegalArgumentException("The specified original space configuration is null.");
        }
        ConfiguredSpaceConfiguration retVal = new ConfiguredSpaceConfiguration(originalSpace.getID(), originalSpace.getName());
        retVal.setCrawler(parentCrawler);
        retVal.setEnabled(originalSpace.isEnabled());
        retVal.setAvailableAsCrawlSpace(originalSpace.isAvailableAsCrawlSpace());
        retVal.setAsCrawlSpace(originalSpace.isSetAsCrawlSpace());
        WrappedConfigurationSpaceCfg wrappedConfigSpace = new WrappedConfigurationSpaceCfg(retVal);
        for (Configuration config : originalSpace.getConfigurations().values()) {
            retVal.addConfiguration(ConfiguredConfigurationFactory.getConfiguredClone(config));
        }
        if (retVal.isSetAsCrawlSpace()) {
            for (Configuration config : originalSpace.getCrawlSpaceConfigurations().values()) {
                retVal.addCrawlSpaceConfiguration(ConfiguredConfigurationFactory.getConfiguredClone(config));
            }
        }
        Iterator<SpaceConfiguration> spaceIter = originalSpace.getSubSpaces();
        while (spaceIter.hasNext()) {
            WrappedConfigurationSpaceCfg subWrappedSpace = ConfiguredConfigurationFactory.getConfiguredClone(parentCrawler, spaceIter.next());
            if (!subWrappedSpace.hasCrawlSpace && subWrappedSpace.space.isAvailableAsCrawlSpace()) continue;
            retVal.addSubSpace(subWrappedSpace.space);
            wrappedConfigSpace.hasCrawlSpace = true;
        }
        Iterator<FieldConfiguration> fieldIter = originalSpace.getFields();
        while (fieldIter.hasNext()) {
            retVal.addField(ConfiguredConfigurationFactory.getConfiguredClone(fieldIter.next()));
        }
        return wrappedConfigSpace;
    }

    static ConfiguredFieldConfiguration getConfiguredClone(FieldConfiguration originalField) {
        if (originalField == null) {
            throw new IllegalArgumentException("The specified original space configuration is null.");
        }
        ConfiguredFieldConfiguration retVal = new ConfiguredFieldConfiguration(originalField.getID(), originalField.getName(), originalField.getTypeName(), originalField.getType(), originalField.getAttributes(), originalField.getConfigurations().values());
        retVal.setEnabled(originalField.isEnabled());
        for (Configuration config : originalField.getConfigurations().values()) {
            retVal.addConfiguration(ConfiguredConfigurationFactory.getConfiguredClone(config));
        }
        return retVal;
    }

    public static Configuration getConfiguredClone(Configuration configuration) {
        Configuration retVal = SimpleConfigurationBuilder.create(configuration.getName(), configuration.getType(), configuration.getAttributes());
        switch (retVal.getType()) {
            case BOOLEAN: {
                retVal.setBoolean(configuration.getBoolean());
                break;
            }
            case STRING: {
                retVal.setString(configuration.getString());
                break;
            }
            case LONG: {
                retVal.setLong(configuration.getLong());
                break;
            }
            case LIST_SINGLE: 
            case LIST_MULTI: {
                SimpleListConfiguration list = (SimpleListConfiguration)retVal;
                for (Configuration.ListItem item : configuration.getItems()) {
                    Configuration.ListItem i = list.addItem(item.getValue());
                    i.setSelected(item.isSelected());
                }
                break;
            }
        }
        return retVal;
    }

    public static final FieldType convertType(com.ibm.es.nuvo.crawler.adapter.FieldType type) {
        switch (type) {
            case BOOLEAN: {
                return FieldType.BOOLEAN;
            }
            case DATE: {
                return FieldType.DATE;
            }
            case DOUBLE: {
                return FieldType.DOUBLE;
            }
            case LONG: {
                return FieldType.LONG;
            }
            case READER: 
            case STRING: {
                return FieldType.STRING;
            }
        }
        return FieldType.UNKNOWN;
    }

    public static final EnumSet<FieldConfiguration.Attribute> convertAttributes(EnumSet<FieldDefinition.FieldProperty> properties) {
        EnumSet<FieldConfiguration.Attribute> attributes = EnumSet.noneOf(FieldConfiguration.Attribute.class);
        for (FieldDefinition.FieldProperty property : properties) {
            if (!property.equals((Object)FieldDefinition.FieldProperty.SYSTEM)) continue;
            attributes.add(FieldConfiguration.Attribute.SYSTEM);
        }
        return attributes;
    }

    public static final Collection<Configuration> convertConfigs(Iterator<ConfigurationElement> configIter) {
        Vector<Configuration> result = new Vector<Configuration>();
        try {
            while (configIter.hasNext()) {
                ConfigurationElement elem = configIter.next();
                Configuration config = SimpleConfigurationBuilder.create(elem.getName(), SimpleConfigurationBuilder.typeBridge(elem), SimpleConfigurationBuilder.optionBridge(elem.getAttributes()));
                switch (elem.getType()) {
                    case STRING: {
                        config.setString(elem.getString());
                        break;
                    }
                    case BOOLEAN: {
                        config.setBoolean(elem.getBoolean());
                        break;
                    }
                    case LONG: {
                        config.setLong(elem.getLong());
                        break;
                    }
                    case LIST: {
                        ListConfiguration.Item[] items;
                        ListConfiguration list = elem.getList();
                        for (ListConfiguration.Item item : items = list.getItems()) {
                            config.addItem(item.getValue());
                        }
                        break;
                    }
                }
                result.add(config);
            }
        }
        catch (AdapterException adapterException) {
            // empty catch block
        }
        return result;
    }

    private static class WrappedConfigurationSpaceCfg {
        private final ConfiguredSpaceConfiguration space;
        private boolean hasCrawlSpace;

        private WrappedConfigurationSpaceCfg(ConfiguredSpaceConfiguration space) {
            this.space = space;
            this.hasCrawlSpace = space.isSetAsCrawlSpace();
        }
    }
}

