/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.config.AbstractConfiguration;
import com.ibm.es.nuvo.crawler.util.Checksum;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleListConfiguration
extends AbstractConfiguration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected final boolean multi;
    private TreeSet<Configuration.ListItem> items;
    private static final char SELECTED = '+';
    private static final char DESELECTED = '-';

    SimpleListConfiguration(String name, boolean multi, EnumSet<Configuration.Attribute> attributes) {
        super(name, multi ? Configuration.Type.LIST_MULTI : Configuration.Type.LIST_SINGLE, attributes);
        this.multi = multi;
        this.initItems();
    }

    private void initItems() {
        this.items = new TreeSet<Configuration.ListItem>(new Comparator<Configuration.ListItem>(){

            @Override
            public int compare(Configuration.ListItem o1, Configuration.ListItem o2) {
                String right = o1.getValue();
                String left = o2.getValue();
                if (right == null) {
                    if (left == null) {
                        return 0;
                    }
                    return -1;
                }
                return right.compareTo(left);
            }
        });
    }

    protected void deselectAll() {
        for (Configuration.ListItem item : this.items) {
            item.setSelected(false);
        }
    }

    @Override
    boolean equals(Configuration configuration) {
        if (!(configuration instanceof SimpleListConfiguration)) {
            return false;
        }
        SimpleListConfiguration right = this;
        SimpleListConfiguration left = (SimpleListConfiguration)configuration;
        if (right.items.size() == left.items.size()) {
            Iterator<Configuration.ListItem> rightItems = right.items.iterator();
            Iterator<Configuration.ListItem> leftItems = left.items.iterator();
            while (rightItems.hasNext() && leftItems.hasNext()) {
                if (rightItems.next().equals(leftItems.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<Configuration.ListItem> getItems() {
        return new TreeSet<Configuration.ListItem>((SortedSet<Configuration.ListItem>)this.items);
    }

    @Override
    public String getString() {
        StringBuilder buf = new StringBuilder();
        for (Configuration.ListItem item : this.items) {
            buf.append(item.isSelected() ? (char)'+' : '-');
            buf.append(item.getValue());
        }
        return buf.toString();
    }

    @Override
    public void setString(String value) {
        this.items.clear();
        if (value != null && value.length() > 0) {
            int i = 0;
            char del = value.charAt(i++);
            int len = value.length();
            while (i < len && (del == '+' || del == '-')) {
                SimpleListItem item;
                int next1 = value.indexOf(43, i);
                int next2 = value.indexOf(45, i);
                if (next1 == -1 && next2 == -1) {
                    SimpleListItem item2 = new SimpleListItem(value.substring(i));
                    item2.selected = del == '+';
                    this.items.add(item2);
                    i = len;
                    continue;
                }
                if (next1 > 0 && next2 > 0) {
                    int min = next1 < next2 ? next1 : next2;
                    item = new SimpleListItem(value.substring(i, min));
                    item.selected = del == '+';
                    i = min;
                    del = value.charAt(i++);
                    continue;
                }
                int min = next1 > 0 ? next1 : next2;
                item = new SimpleListItem(value.substring(i, min));
                item.selected = del == '+';
                i = min;
                del = value.charAt(i++);
            }
        }
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public Configuration.ListItem addItem(String value) {
        return this.addItem(new SimpleListItem(value));
    }

    public Configuration.ListItem addItem(Configuration.ListItem item) {
        this.items.add(item);
        return item;
    }

    @Override
    public Checksum getChecksum() {
        Checksum checksum = new Checksum();
        super.updateChecksumWithFundamentalValues(checksum);
        for (Configuration.ListItem item : this.getItems()) {
            checksum.update(item.getChecksum().getBytes());
        }
        return checksum;
    }

    @Override
    public Configuration.ListItem removeItem(String value) {
        SimpleListItem item = new SimpleListItem(value);
        this.items.remove(item);
        return item;
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class SimpleListItem
    implements Configuration.ListItem,
    Comparable<SimpleListItem> {
        private final String value;
        protected boolean selected;

        protected SimpleListItem(String value) {
            this.value = value;
            this.selected = false;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSelected() {
            return this.selected;
        }

        @Override
        public void setSelected(boolean selected) {
            if (!SimpleListConfiguration.this.multi && selected) {
                SimpleListConfiguration.this.deselectAll();
            }
            this.selected = selected;
        }

        @Override
        public int compareTo(SimpleListItem o) {
            if (this.value != null) {
                return this.value.compareTo(o.value);
            }
            if (o.value == null) {
                return 0;
            }
            return -1;
        }

        public boolean equals(Object o) {
            return o instanceof SimpleListItem ? this.compareTo((SimpleListItem)o) == 0 : false;
        }

        public int hashCode() {
            return this.value != null ? this.value.hashCode() : 0;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder().append(this.selected ? (char)'+' : '-').append(this.value);
            return builder.toString();
        }

        @Override
        public Checksum getChecksum() {
            Checksum checksum = new Checksum();
            checksum.update(this.getValue());
            checksum.update(this.isSelected());
            return checksum;
        }
    }
}

