/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.config.BooleanConfiguration;
import com.ibm.es.nuvo.crawler.config.LongConfiguration;
import com.ibm.es.nuvo.crawler.config.SimpleListConfiguration;
import com.ibm.es.nuvo.crawler.config.StringConfiguration;
import java.util.EnumSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleConfigurationBuilder {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    private static final EnumSet<Configuration.Attribute> createAttributes(boolean mandatory, boolean userConfigurable, boolean fullCrawlingEnforced) {
        EnumSet<Configuration.Attribute> attrs = EnumSet.noneOf(Configuration.Attribute.class);
        if (mandatory) {
            attrs.add(Configuration.Attribute.MANDATORY);
        }
        if (!fullCrawlingEnforced) {
            attrs.add(Configuration.Attribute.NO_FORCE);
        }
        if (!userConfigurable) {
            attrs.add(Configuration.Attribute.READONLY);
        }
        return attrs;
    }

    public static final Configuration create(String name, Configuration.Type type, boolean mandatory, boolean userConfigurable, boolean fullCrawlingEnforced) {
        return SimpleConfigurationBuilder.create(name, type, SimpleConfigurationBuilder.createAttributes(mandatory, userConfigurable, fullCrawlingEnforced));
    }

    public static final Configuration create(String name, Configuration.Type type, EnumSet<Configuration.Attribute> attributes) {
        switch (type) {
            case STRING: {
                return new StringConfiguration(name, attributes);
            }
            case LONG: {
                return new LongConfiguration(name, attributes);
            }
            case BOOLEAN: {
                return new BooleanConfiguration(name, attributes);
            }
            case LIST_MULTI: {
                return SimpleConfigurationBuilder.createList(name, true, attributes);
            }
            case LIST_SINGLE: {
                return SimpleConfigurationBuilder.createList(name, false, attributes);
            }
        }
        throw new IllegalStateException();
    }

    public static final SimpleListConfiguration createList(String name, boolean multi, boolean mandatory, boolean userConfigurable, boolean fullCrawlingEnforced) {
        return SimpleConfigurationBuilder.createList(name, multi, SimpleConfigurationBuilder.createAttributes(mandatory, userConfigurable, fullCrawlingEnforced));
    }

    public static final SimpleListConfiguration createList(String name, boolean multi, EnumSet<Configuration.Attribute> attributes) {
        return new SimpleListConfiguration(name, multi, attributes);
    }

    public static final EnumSet<Configuration.Attribute> optionBridge(EnumSet<ConfigurationElement.Attribute> adapterOptions) {
        EnumSet<Configuration.Attribute> adminOptions = EnumSet.noneOf(Configuration.Attribute.class);
        for (ConfigurationElement.Attribute attribute : adapterOptions) {
            adminOptions.add(Configuration.Attribute.valueOf(attribute.name()));
        }
        return adminOptions;
    }

    public static final Configuration.Type typeBridge(ConfigurationElement configElem) throws AdapterException {
        ConfigurationElement.Type orgType = configElem.getType();
        Configuration.Type resType = Configuration.Type.BOOLEAN;
        switch (orgType) {
            case BOOLEAN: {
                resType = Configuration.Type.BOOLEAN;
                break;
            }
            case LONG: {
                resType = Configuration.Type.LONG;
                break;
            }
            case STRING: {
                resType = Configuration.Type.STRING;
                break;
            }
            case LIST: {
                if (ListConfiguration.Style.SINGLE.equals((Object)configElem.getList().getStyle())) {
                    resType = Configuration.Type.LIST_SINGLE;
                    break;
                }
                resType = Configuration.Type.LIST_MULTI;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return resType;
    }
}

