/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.config.configured.ConfiguredFieldConfiguration;
import com.ibm.es.nuvo.crawler.util.Checksum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlerConfigurationUtils {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static long getChecksum(Map<String, Configuration> configs, Set<Configuration.Attribute> ignoredAttributes) {
        Checksum checksum = new Checksum();
        Object[] sortedKey = configs.keySet().toArray(new String[0]);
        Arrays.sort(sortedKey);
        for (Object key : sortedKey) {
            boolean isIgnored = false;
            Configuration config = configs.get(key);
            for (Configuration.Attribute ignored : ignoredAttributes) {
                if (!config.getAttributes().contains((Object)ignored)) continue;
                isIgnored = true;
                break;
            }
            if (isIgnored) continue;
            if (config.getType().equals((Object)Configuration.Type.LIST_MULTI) || config.getType().equals((Object)Configuration.Type.LIST_SINGLE)) {
                Object[] items = config.getItems().toArray(new Configuration.ListItem[0]);
                Arrays.sort(items);
                for (Object item : items) {
                    checksum.update(item.getChecksum().getValue());
                }
                continue;
            }
            checksum.update(config.getChecksum().getValue());
        }
        return checksum.getValue();
    }

    public static long getChecksum(Map<String, ConfiguredFieldConfiguration> fieldConfigs) {
        Checksum checksum = new Checksum();
        Object[] sortedKey = fieldConfigs.keySet().toArray(new String[0]);
        Arrays.sort(sortedKey);
        for (Object key : sortedKey) {
            Checksum lSum = new Checksum();
            ConfiguredFieldConfiguration fConfig = fieldConfigs.get(key);
            lSum.update(fConfig.getName());
            lSum.update(fConfig.isEnabled());
            for (FieldConfiguration.Attribute attribute : fConfig.getAttributes()) {
                lSum.update(attribute.toString());
            }
            checksum.update(lSum.getValue());
        }
        return checksum.getValue();
    }

    public static long getChecksum(Iterator<FieldConfiguration> fieldIterator) {
        Checksum checksum = new Checksum();
        HashMap<String, FieldConfiguration> fSet = new HashMap<String, FieldConfiguration>();
        while (fieldIterator.hasNext()) {
            FieldConfiguration field = fieldIterator.next();
            fSet.put(field.getName(), field);
        }
        Object[] sortedKey = fSet.keySet().toArray(new String[0]);
        Arrays.sort(sortedKey);
        for (Object key : sortedKey) {
            FieldConfiguration field = (FieldConfiguration)fSet.get(key);
            if (!field.isEnabled()) continue;
            checksum.update(((FieldConfiguration)fSet.get(key)).getName());
        }
        return checksum.getValue();
    }
}

