/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.ModificationNotAllowedException;
import com.ibm.es.nuvo.crawler.config.SimpleConfigurationBuilder;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurationItem
implements ConfigurationItem {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected AbstractConfigurationItem parent = null;
    protected AbstractConfigurationItem[] path;
    protected boolean open;
    private boolean enabled = false;
    private String id;
    private final String name;
    protected Map<String, Configuration> configs;

    protected abstract void ensureStatus() throws ModificationNotAllowedException;

    protected AbstractConfigurationItem(String id, String name) {
        this.id = id;
        this.name = name;
        this.open = true;
        this.configs = new HashMap<String, Configuration>();
    }

    @Override
    public Configuration createNewConfiguration(String newName, Configuration.Type type, boolean isUserConfigurable) {
        return SimpleConfigurationBuilder.create(newName, type, false, isUserConfigurable, false);
    }

    @Override
    public void addConfiguration(Configuration config) {
        this.ensureStatus();
        if (config == null || config.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.configs == null) {
            this.configs = new HashMap<String, Configuration>();
        }
        this.configs.put(config.getName(), config);
        config.setParent(this);
    }

    public final Configuration getConfiguration(String n) {
        if (this.configs == null) {
            return null;
        }
        return this.configs.get(n);
    }

    @Override
    public final Map<String, Configuration> getConfigurations() {
        Map<String, Configuration> map = null;
        map = this.configs == null ? Collections.emptyMap() : Collections.unmodifiableMap(this.configs);
        return map;
    }

    @Override
    public final String getID() {
        return this.id;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    public final boolean removeConfiguration(String n) {
        Configuration child;
        this.ensureStatus();
        if (this.configs != null && (child = this.configs.remove(n)) != null) {
            child.setParent(null);
            return true;
        }
        return false;
    }

    public final void removeConfigurations() {
        this.ensureStatus();
        if (this.configs != null) {
            Iterator<Configuration> nodes = this.configs.values().iterator();
            while (nodes.hasNext()) {
                nodes.next().setParent(null);
            }
            this.configs.clear();
        }
    }

    @Override
    public final ConfigurationItem getParent() {
        return this.parent;
    }

    public final void setParent(AbstractConfigurationItem parent) {
        if (parent != null) {
            this.ensureStatus();
        }
        this.parent = parent;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.enabled = isEnabled;
    }

    public String toString() {
        String lineSep = System.getProperty("line.separator");
        StringBuilder buf = new StringBuilder(this.getClass().getName()).append(lineSep);
        buf.append("ID:").append(this.getID()).append(" Name:").append(this.getName()).append(lineSep);
        if (this.configs != null) {
            buf.append("Configurations:").append(lineSep);
            for (Configuration config : this.configs.values()) {
                buf.append("name: ").append(config.getName()).append(" value(").append((Object)config.getType()).append("): ").append(config.getString());
                EnumSet<Configuration.Attribute> attrs = config.getAttributes();
                buf.append(' ');
                for (Configuration.Attribute attribute : attrs) {
                    buf.append((Object)attribute).append(' ');
                }
                buf.append(lineSep);
            }
        }
        return buf.toString();
    }

    public void setId(String newId) {
        this.id = newId;
    }

    @Override
    public void open() throws CrawlerConfigurationException {
        this.ensureClose();
        this.open = true;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws CrawlerConfigurationException {
        this.ensureOpen();
        this.open = false;
    }

    protected void ensureOpen() throws CrawlerConfigurationException {
        if (!this.isOpen()) {
            throw new CrawlerConfigurationException(new IllegalStateException("This configuration item has been already closed"));
        }
    }

    protected void ensureClose() throws CrawlerConfigurationException {
        if (this.isOpen()) {
            throw new CrawlerConfigurationException(new IllegalStateException("This configuration item has been already opened"));
        }
    }
}

