/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.config;

import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.ConfigurationItem;
import com.ibm.es.nuvo.crawler.admin.ModificationNotAllowedException;
import com.ibm.es.nuvo.crawler.util.Checksum;
import java.util.EnumSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
implements Configuration {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ConfigurationItem parent;
    private final String name;
    private final Configuration.Type type;
    private final EnumSet<Configuration.Attribute> attrs;

    protected AbstractConfiguration(String name, Configuration.Type type, EnumSet<Configuration.Attribute> attributes) {
        this.name = name;
        this.type = type;
        this.attrs = attributes.clone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ConfigurationItem getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ConfigurationItem parent) {
        if (parent != null) {
            this.ensureStatus();
        }
        this.parent = parent;
    }

    @Override
    public Configuration.Type getType() {
        return this.type;
    }

    protected void ensureStatus() {
        if (this.parent != null) {
            throw new ModificationNotAllowedException();
        }
    }

    @Override
    public EnumSet<Configuration.Attribute> getAttributes() {
        return this.attrs;
    }

    @Override
    public boolean getBoolean() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getString() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Configuration.ListItem> getItems() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setBoolean(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLong(long value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setString(String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Configuration.ListItem addItem(String value) {
        throw new UnsupportedOperationException();
    }

    public boolean isMandatory() {
        return this.attrs.contains((Object)Configuration.Attribute.MANDATORY);
    }

    public boolean isFullCrawlingEnforced() {
        return !this.attrs.contains((Object)Configuration.Attribute.NO_FORCE);
    }

    public boolean isUserConfigurable() {
        return !this.attrs.contains((Object)Configuration.Attribute.READONLY);
    }

    boolean equals(Configuration config) {
        if (config != null && config.getChecksum() != null) {
            return this.getChecksum().compareChecksum(config.getChecksum());
        }
        return false;
    }

    @Override
    public abstract Checksum getChecksum();

    protected void updateChecksumWithFundamentalValues(Checksum checksum) {
        checksum.update(this.getType().name());
        checksum.update(this.getName());
        for (Configuration.Attribute attr : this.getAttributes()) {
            checksum.update(attr.toString());
        }
    }

    @Override
    public Configuration.ListItem removeItem(String itemName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

