/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.common;

import com.ibm.es.nuvo.crawler.adapter.AdapterException;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationElement;
import com.ibm.es.nuvo.crawler.adapter.ConfigurationMap;
import com.ibm.es.nuvo.crawler.adapter.ListConfiguration;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrawlerConstants {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final int ERROR_DOC_QUEUE_NOT_AVAILABLE = 500;
    public static final int ERROR_DOC_NOT_FOUND = 404;
    public static final long DEFAULT_ITNERVAL = 0L;
    public static final long DEFAULT_MAX_CONNECTION = 10L;
    public static final long DEFAULT_MAX_PAGE_LENGTH = 0x3200000L;
    public static final String MAX_CONNECTIONS = "es:max_connections";
    public static final String FETCH_INTERVAL = "es:fetch_interval";
    public static final String MAX_PAGE_LENGTH = "es:max_page_length";
    public static final String LANGUAGE = "es:language";
    public static final String KNOWN_LANGUAGE = "es:known_language";
    public static final String CHARSET = "es:charset";
    public static final String KNOWN_CHARSET = "es:known_charset";
    public static final String MIMETYPE = "es:mimetype";
    public static final String KNOWN_MIMETYPE = "es:known_mimetype";
    public static final String EXCLUDE_EXTENSIONS = "es:exclude_extensions";
    public static final String CRAWLER_PLUGIN_CLASS = "es:crawler_plugin";
    public static final String CRAWLER_PLUGIN_CLASSPATH = "es:crawler_plugin_classpath";
    public static final String CRAWLER_PLUGIN_EXCLUDE = "es:crawler_plugin_exclude";

    public static void addCrawlerCommon(ConfigurationMap configs) {
        CrawlerConstants.addMaxConnections(configs);
        CrawlerConstants.addCrawlerPlugin(configs);
        CrawlerConstants.addCrawlerPluginClasspath(configs);
        CrawlerConstants.addCrawlerPluginUseExclude(configs);
        CrawlerConstants.addMaxPageLength(configs);
        CrawlerConstants.addFetchInterval(configs);
    }

    public static void addCrawlSpaceCommon(ConfigurationMap configs) {
        CrawlerConstants.addLanguage(configs);
        CrawlerConstants.addKnownLanguage(configs);
        CrawlerConstants.addCharset(configs);
        CrawlerConstants.addKnownCharset(configs);
        CrawlerConstants.addMimetype(configs);
        CrawlerConstants.addKnownMimetype(configs);
        CrawlerConstants.addExcludeExtensions(configs);
    }

    public static ConfigurationElement addMaxConnections(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        option.add(ConfigurationElement.Attribute.MANDATORY);
        return configs.add(MAX_CONNECTIONS, 10L, option);
    }

    public static ConfigurationElement addFetchInterval(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        option.add(ConfigurationElement.Attribute.MANDATORY);
        return configs.add(FETCH_INTERVAL, 0L, option);
    }

    public static ConfigurationElement addMaxPageLength(ConfigurationMap configs) {
        return configs.add(MAX_PAGE_LENGTH, 0x3200000L, true);
    }

    public static ConfigurationElement addLanguage(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(LANGUAGE, null, option);
    }

    public static ConfigurationElement addKnownLanguage(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(KNOWN_LANGUAGE, null, option);
    }

    public static ConfigurationElement addCharset(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(CHARSET, null, option);
    }

    public static ConfigurationElement addKnownCharset(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(KNOWN_CHARSET, null, option);
    }

    public static ConfigurationElement addMimetype(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(MIMETYPE, null, option);
    }

    public static ConfigurationElement addKnownMimetype(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        return configs.add(KNOWN_MIMETYPE, null, option);
    }

    public static ConfigurationElement addCrawlerPlugin(ConfigurationMap configs) {
        return configs.add(CRAWLER_PLUGIN_CLASS, null, false);
    }

    public static ConfigurationElement addCrawlerPluginClasspath(ConfigurationMap configs) {
        return configs.add(CRAWLER_PLUGIN_CLASSPATH, null, false);
    }

    public static ConfigurationElement addCrawlerPluginUseExclude(ConfigurationMap configs) {
        return configs.add(CRAWLER_PLUGIN_EXCLUDE, true, false);
    }

    public static Set<String> extractExcludedExtensions(ConfigurationMap configs) {
        TreeSet<String> excludedExtensions = new TreeSet<String>();
        if (configs != null) {
            ConfigurationElement config = configs.get(EXCLUDE_EXTENSIONS);
            try {
                ListConfiguration list = config.getList();
                ListConfiguration.Item[] items = list.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (!items[i].isSelected()) continue;
                    excludedExtensions.add(items[i].getValue().toLowerCase());
                }
            }
            catch (AdapterException adapterException) {
                // empty catch block
            }
        }
        return excludedExtensions;
    }

    public static ConfigurationElement addExcludeExtensions(ConfigurationMap configs) {
        EnumSet<ConfigurationElement.Attribute> option = EnumSet.noneOf(ConfigurationElement.Attribute.class);
        option.add(ConfigurationElement.Attribute.NO_FORCE);
        ConfigurationElement config = configs.add(EXCLUDE_EXTENSIONS, option, ListConfiguration.Style.MULTI);
        try {
            ListConfiguration list = config.getList();
            list.add(".a");
            list.add(".aif");
            list.add(".au");
            list.add(".avi");
            list.add(".bmp");
            list.add(".cab");
            list.add(".class");
            list.add(".com");
            list.add(".dib");
            list.add(".dll");
            list.add(".exe");
            list.add(".gif");
            list.add(".ico");
            list.add(".jar");
            list.add(".jfif");
            list.add(".jpe");
            list.add(".jpeg");
            list.add(".jpg");
            list.add(".lib");
            list.add(".lnk");
            list.add(".lzh");
            list.add(".mov");
            list.add(".mid");
            list.add(".midi");
            list.add(".mp3");
            list.add(".mpeg");
            list.add(".mpg");
            list.add(".o");
            list.add(".obj");
            list.add(".ocx");
            list.add(".pif");
            list.add(".png");
            list.add(".qt");
            list.add(".ra");
            list.add(".ram");
            list.add(".reg");
            list.add(".res");
            list.add(".rm");
            list.add(".snd");
            list.add(".so");
            list.add(".tiff");
            list.add(".tif");
            list.add(".xpm");
            list.add(".wav");
            list.add(".wm");
            list.add(".wma");
            list.add(".wmv");
            list.add(".z");
            ListConfiguration.Item[] items = list.getItems();
            for (int i = 0; i < items.length; ++i) {
                items[i].setSelected(true);
            }
        }
        catch (AdapterException adapterException) {
            // empty catch block
        }
        return config;
    }
}

