/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr.lucene;

import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfo;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfoManager;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import com.ibm.es.nuvo.crawler.util.hash.HashUtil;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LuceneSessionInfoManager
implements SessionInfoManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + LuceneSessionInfoManager.class.getName());
    private static final TermQuery TYPE_QUERY = new TermQuery(new Term("type", "properties"));
    private static final Field TYPE_FIELD = new Field("type", "properties", Field.Store.YES, Field.Index.UN_TOKENIZED);
    private Map<String, List<SessionInfo>> sessionMap = new HashMap<String, List<SessionInfo>>();
    private final LuceneMetadataStoreManager manager;
    private IndexWriter writer;
    private volatile boolean isClosed;

    LuceneSessionInfoManager(LuceneMetadataStoreManager manager) throws MetadataStoreException {
        this.manager = manager;
        this.isClosed = false;
        this.writer = this.manager.getWriter();
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SessionInfo> getSessionHistory(String crawlSpaceId) {
        Map<String, List<SessionInfo>> map = this.sessionMap;
        synchronized (map) {
            ArrayList<SessionInfo> ret = new ArrayList<SessionInfo>();
            ret.addAll(this.getHistory(crawlSpaceId));
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SessionInfo> getHistory(String crawlSpaceId) {
        List<SessionInfo> list = this.sessionMap.get(crawlSpaceId);
        if (list == null) {
            Map<String, List<SessionInfo>> map = this.sessionMap;
            synchronized (map) {
                list = this.sessionMap.get(crawlSpaceId);
                if (list == null) {
                    list = new ArrayList<SessionInfo>();
                    this.sessionMap.put(crawlSpaceId, list);
                }
            }
        }
        return list;
    }

    @Override
    public SessionInfo openSession(String crawlSpaceId) {
        return new LuceneSessionInfo(crawlSpaceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(String crawlSpaceId, LuceneSessionInfo info) throws MetadataStoreException {
        if (!this.isClosed) {
            List<SessionInfo> list = this.getHistory(crawlSpaceId);
            if (list.size() >= this.manager.getNumRevision()) {
                SessionInfo s;
                LuceneSessionInfo lsi = (LuceneSessionInfo)list.get(0);
                ListIterator<SessionInfo> li = list.listIterator(list.size());
                while (li.hasPrevious() && !(s = li.previous()).isFinished()) {
                    lsi = (LuceneSessionInfo)s;
                }
                IndexWriter indexWriter = this.writer;
                synchronized (indexWriter) {
                    if (lsi != null) {
                        try {
                            this.writer.deleteDocuments(new Term("LuceneSessionInfoID", lsi.id));
                            this.writer.flush();
                        }
                        catch (IOException e) {
                            throw new MetadataStoreException(e);
                        }
                        if (tracer.isLoggable(Level.FINE)) {
                            tracer.fine("remove " + lsi.id);
                        }
                    }
                }
                list.remove(lsi);
            }
            list.add(info);
        }
    }

    private void load() throws MetadataStoreException {
        IndexSearcher searcher = this.manager.getSearcher();
        try {
            Hits hits = searcher.search((Query)TYPE_QUERY);
            ArrayList<DocumentProperties> list = new ArrayList<DocumentProperties>();
            for (int i = 0; i < hits.length(); ++i) {
                list.add(new DocumentProperties(hits.doc(i)));
            }
            Collections.sort(list);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Sorted list " + list);
            }
            LuceneSessionInfo info = null;
            long sid = 0L;
            for (DocumentProperties p : list) {
                if (info != null) {
                    if (sid == p.sessionId && info != null) {
                        info.setEnd(p);
                        info = null;
                        continue;
                    }
                    info = null;
                }
                if (info != null) continue;
                info = new LuceneSessionInfo(p.crawlSpaceId);
                sid = p.sessionId;
                info.setStart(p);
                this.getHistory(p.crawlSpaceId).add(info);
            }
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("" + this.sessionMap);
            }
        }
        catch (IOException e) {
            throw new MetadataStoreException(e);
        }
        finally {
            try {
                searcher.close();
            }
            catch (Exception ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(DocumentProperties properties) throws MetadataStoreException {
        if (!this.isClosed) {
            IndexWriter indexWriter = this.writer;
            synchronized (indexWriter) {
                try {
                    Document doc = properties.toDocument();
                    this.writer.addDocument(doc);
                    this.writer.flush();
                }
                catch (IOException e) {
                    throw new MetadataStoreException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getKnownCrawlSpaceNames() {
        ArrayList<String> list = new ArrayList<String>();
        Map<String, List<SessionInfo>> map = this.sessionMap;
        synchronized (map) {
            for (Map.Entry<String, List<SessionInfo>> entry : this.sessionMap.entrySet()) {
                if (entry.getValue().size() <= 0) continue;
                list.add(entry.getKey());
            }
        }
        return list;
    }

    void close() {
        this.isClosed = true;
    }

    public class LuceneSessionInfo
    extends SessionInfo {
        private final String crawlSpaceId;
        private String id;

        public LuceneSessionInfo(String crawlSpaceId) {
            this.crawlSpaceId = crawlSpaceId;
            this.updateId();
        }

        public void setEnd(DocumentProperties properties) {
            this.spaceName = properties.spaceName;
            this.finishTime = properties.timestamp;
            this.crawlStatus = properties.crawlStatus;
            this.configHash = properties.configHash;
            this.numOfCrawledDoc = properties.numOfCrawledDoc;
            this.crawlMode = properties.crawlMode;
            this.numOfDeletedDoc = properties.numOfDeletedDoc;
            this.numOfErrorDoc = properties.numOfErrorDoc;
            this.numOfInsertedDoc = properties.numOfInsertedDoc;
            this.numOfTotalDoc = properties.numOfTotalDoc;
            this.numOfUpdatedDoc = properties.numOfUpdatedDoc;
            this.maxLastModified = properties.maxLastModified;
            this.optionalData = properties.optionalData;
            this.lastForceCrawled = properties.lastForceCrawled;
            String docStatus = properties.documentStatus;
            if (docStatus.equals(SessionInfo.DocumentStatus.CONSISTENT.toString())) {
                this.isAllDocumentsUpToDate = true;
            } else if (docStatus.equals(SessionInfo.DocumentStatus.INCONSISTENT.toString())) {
                this.isAllDocumentsUpToDate = false;
            }
        }

        public void setStart(DocumentProperties properties) {
            this.startTime = properties.timestamp;
            this.sessionId = properties.sessionId;
            this.updateId();
        }

        private void updateId() {
            this.id = String.valueOf(HashUtil.hashCode64(this.crawlSpaceId)) + "_" + String.valueOf(this.sessionId);
        }

        public void saveAsFinished() throws MetadataStoreException {
            DocumentProperties properties = this.createProperties();
            this.finishTime = properties.timestamp;
            LuceneSessionInfoManager.this.store(properties);
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("wrote finish " + properties.id);
            }
        }

        private DocumentProperties createProperties() {
            DocumentProperties properties = new DocumentProperties();
            properties.spaceName = this.spaceName;
            properties.crawlSpaceId = this.crawlSpaceId;
            properties.sessionId = this.sessionId;
            properties.timestamp = System.currentTimeMillis();
            properties.id = this.id;
            properties.crawlMode = this.crawlMode;
            properties.crawlStatus = this.crawlStatus;
            properties.numOfTotalDoc = this.numOfTotalDoc;
            properties.numOfErrorDoc = this.numOfErrorDoc;
            properties.numOfCrawledDoc = this.numOfCrawledDoc;
            properties.numOfInsertedDoc = this.numOfInsertedDoc;
            properties.numOfUpdatedDoc = this.numOfUpdatedDoc;
            properties.numOfDeletedDoc = this.numOfDeletedDoc;
            properties.optionalData = this.optionalData;
            properties.configHash = this.configHash;
            properties.maxLastModified = this.maxLastModified;
            properties.documentStatus = this.isAllDocumentsUpToDate ? SessionInfo.DocumentStatus.CONSISTENT.toString() : SessionInfo.DocumentStatus.INCONSISTENT.toString();
            properties.lastForceCrawled = this.lastForceCrawled;
            return properties;
        }

        public void saveAsStarted() throws MetadataStoreException {
            DocumentProperties properties = this.createProperties();
            this.setStart(properties);
            LuceneSessionInfoManager.this.addSession(this.crawlSpaceId, this);
            LuceneSessionInfoManager.this.store(properties);
            if (tracer.isLoggable(Level.FINE)) {
                tracer.fine("wrote start " + properties.id);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DocumentProperties
    extends Properties
    implements Comparable<DocumentProperties> {
        private static final long serialVersionUID = 1L;
        private static final String FLD_LUCENE_SESSION_INFO_ID = "LuceneSessionInfoID";
        private static final String FLD_CRAWLSPACE = "crawl_space_id";
        private static final String FLD_SESSION_ID = "session_id";
        private static final String FLD_HEADER = "prop_";
        private static final String FLD_TIMESTAMP = "timestamp";
        private String crawlSpaceId;
        private long sessionId;
        private long timestamp;
        private static final String FLD_CRAWL_MODE = "crawl_mode";
        private String crawlMode;
        private static final String FLD_CRAWL_STATUS = "crawl_status";
        private String crawlStatus;
        private static final String FLD_NUM_TOTAL_DOC = "num_total_doc";
        private long numOfTotalDoc;
        private static final String FLD_NUM_CRAWLED_DOC = "num_crawled_doc";
        protected long numOfCrawledDoc;
        private static final String FLD_NUM_ERROR_DOC = "num_error_doc";
        protected long numOfErrorDoc;
        private static final String FLD_NUM_INSERTED_DOC = "num_inserted_doc";
        protected long numOfInsertedDoc;
        private static final String FLD_NUM_UPDATED_DOC = "num_updated_doc";
        protected long numOfUpdatedDoc;
        private static final String FLD_NUM_DELETED_DOC = "num_deleted_doc";
        protected long numOfDeletedDoc;
        private static final String FLD_OPTINAL_DATA = "optional_data";
        protected byte[] optionalData;
        private static final String FLD_CONFIG_HASH = "config_hash";
        protected long configHash;
        private static final String FLD_MAXLASTMODIFIED = "max_lastmodified";
        protected long maxLastModified;
        private static final String FLD_SPACENAME = "spacename";
        protected String spaceName;
        private static final String FLD_DOCUMENTSTATUS = "document_status";
        protected String documentStatus;
        private static final String FLD_LAST_FORCE = "last_force_crawled";
        protected long lastForceCrawled;
        private String id;

        public DocumentProperties() {
        }

        public DocumentProperties(Document document) {
            for (Object o : document.getFields()) {
                Field field = (Field)o;
                String name = field.name();
                if (FLD_OPTINAL_DATA.equals(name)) {
                    this.optionalData = field.binaryValue();
                    continue;
                }
                String value = field.stringValue();
                if (FLD_SPACENAME.equals(name)) {
                    this.spaceName = value.intern();
                    continue;
                }
                if (FLD_TIMESTAMP.equals(name)) {
                    this.timestamp = Long.parseLong(value);
                    continue;
                }
                if (FLD_SESSION_ID.equals(name)) {
                    this.sessionId = Long.parseLong(value);
                    continue;
                }
                if (FLD_CRAWLSPACE.equals(name)) {
                    this.crawlSpaceId = value.intern();
                    continue;
                }
                if (FLD_CRAWL_MODE.equals(name)) {
                    this.crawlMode = value.intern();
                    continue;
                }
                if (FLD_CRAWL_STATUS.equals(name)) {
                    this.crawlStatus = value.intern();
                    continue;
                }
                if (FLD_NUM_TOTAL_DOC.equals(name)) {
                    this.numOfTotalDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_NUM_CRAWLED_DOC.equals(name)) {
                    this.numOfCrawledDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_NUM_ERROR_DOC.equals(name)) {
                    this.numOfErrorDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_NUM_INSERTED_DOC.equals(name)) {
                    this.numOfInsertedDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_NUM_UPDATED_DOC.equals(name)) {
                    this.numOfUpdatedDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_NUM_DELETED_DOC.equals(name)) {
                    this.numOfDeletedDoc = Long.parseLong(value);
                    continue;
                }
                if (FLD_CONFIG_HASH.equals(name)) {
                    this.configHash = Long.parseLong(value);
                    continue;
                }
                if (FLD_MAXLASTMODIFIED.equals(name)) {
                    this.maxLastModified = Long.parseLong(value);
                    continue;
                }
                if (name.startsWith(FLD_HEADER)) {
                    this.setProperty(name.substring(FLD_HEADER.length()), value);
                    continue;
                }
                if (name.equals(FLD_DOCUMENTSTATUS)) {
                    this.documentStatus = value.intern();
                    continue;
                }
                if (!name.equals(FLD_LAST_FORCE)) continue;
                this.lastForceCrawled = Long.parseLong(value);
            }
        }

        public Document toDocument() {
            Document document = new Document();
            document.add((Fieldable)TYPE_FIELD);
            document.add((Fieldable)new Field(FLD_SPACENAME, this.spaceName, Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_CRAWLSPACE, this.crawlSpaceId, Field.Store.YES, Field.Index.NO_NORMS));
            document.add((Fieldable)new Field(FLD_TIMESTAMP, String.valueOf(this.timestamp), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_SESSION_ID, String.valueOf(this.sessionId), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_LUCENE_SESSION_INFO_ID, this.id, Field.Store.NO, Field.Index.NO_NORMS));
            if (this.crawlMode == null) {
                document.add((Fieldable)new Field(FLD_CRAWL_MODE, "NORMAL", Field.Store.YES, Field.Index.NO));
            } else {
                document.add((Fieldable)new Field(FLD_CRAWL_MODE, this.crawlMode, Field.Store.YES, Field.Index.NO));
            }
            document.add((Fieldable)new Field(FLD_CRAWL_STATUS, this.crawlStatus, Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_TOTAL_DOC, String.valueOf(this.numOfTotalDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_CRAWLED_DOC, String.valueOf(this.numOfCrawledDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_ERROR_DOC, String.valueOf(this.numOfErrorDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_INSERTED_DOC, String.valueOf(this.numOfInsertedDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_UPDATED_DOC, String.valueOf(this.numOfUpdatedDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_NUM_DELETED_DOC, String.valueOf(this.numOfDeletedDoc), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_OPTINAL_DATA, this.optionalData, Field.Store.YES));
            document.add((Fieldable)new Field(FLD_CONFIG_HASH, String.valueOf(this.configHash), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_MAXLASTMODIFIED, String.valueOf(this.maxLastModified), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_DOCUMENTSTATUS, this.documentStatus, Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FLD_LAST_FORCE, String.valueOf(this.lastForceCrawled), Field.Store.YES, Field.Index.NO));
            for (Map.Entry<Object, Object> entry : this.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                document.add((Fieldable)new Field(FLD_HEADER + key, value, Field.Store.YES, Field.Index.NO));
            }
            return document;
        }

        @Override
        public int compareTo(DocumentProperties o) {
            long d = o.crawlSpaceId.compareTo(this.crawlSpaceId);
            if (d == 0L) {
                d = o.sessionId - this.sessionId;
            }
            if (d == 0L) {
                d = o.timestamp - this.timestamp;
            }
            return d > 0L ? -1 : 1;
        }

        @Override
        public synchronized String toString() {
            return this.crawlSpaceId + "_" + this.sessionId + "+" + (this.timestamp - this.sessionId);
        }
    }
}

