/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr.lucene;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.cdsr.DocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreManager;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfoManager;
import com.ibm.es.nuvo.crawler.cdsr.lucene.AbstractLuceneStore;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneDocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneSessionInfoManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMetadataStoreManager
extends MetadataStoreManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final Analyzer analyzer = new SimpleAnalyzer();
    private IndexWriter writer;
    private Lock lock = new ReentrantLock();
    private LuceneSessionInfoManager sessionInfoManager;
    private LuceneDocumentStatusManager documentStatusManager;
    private String location;

    public LuceneMetadataStoreManager(String location) {
        super(location);
        this.location = location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexWriter getWriter() throws MetadataStoreException {
        block7: {
            this.lock.lock();
            try {
                if (this.writer != null) break block7;
                try {
                    try {
                        this.writer = new IndexWriter(this.location, analyzer, false);
                    }
                    catch (FileNotFoundException e) {
                        this.writer = new IndexWriter(this.location, analyzer, true);
                    }
                }
                catch (IOException e) {
                    Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
                    msg.addArgument(this.location);
                    throw new MetadataStoreException(msg, (Throwable)e);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        return this.writer;
    }

    IndexSearcher getSearcher() throws MetadataStoreException {
        try {
            return new IndexSearcher(this.location);
        }
        catch (IOException e) {
            Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
            msg.addArgument(this.location);
            throw new MetadataStoreException(msg, (Throwable)e);
        }
    }

    @Override
    protected MetadataStore createMetadataStore(String locaion, String crawlSpaceId) throws MetadataStoreException {
        return new LuceneMetadataStore(this, crawlSpaceId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drop(String crawlSpaceId) throws MetadataStoreException {
        this.lock.lock();
        try {
            IndexWriter indexWriter;
            IndexWriter indexWriter2 = indexWriter = this.getWriter();
            synchronized (indexWriter2) {
                indexWriter.deleteDocuments(new Term("crawl_space_id", crawlSpaceId));
            }
        }
        catch (IOException e) {
            Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
            msg.addArgument(this.location);
            throw new MetadataStoreException(msg, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws MetadataStoreException {
        super.close();
        this.lock.lock();
        try {
            if (this.sessionInfoManager != null) {
                this.sessionInfoManager.close();
            }
            if (this.writer != null) {
                try {
                    this.writer.close();
                    this.writer = null;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SessionInfoManager getSessionInfoManager() throws MetadataStoreException {
        if (this.sessionInfoManager == null) {
            this.sessionInfoManager = new LuceneSessionInfoManager(this);
        }
        return this.sessionInfoManager;
    }

    @Override
    public DocumentStatusManager getDocumentStatusManager() throws MetadataStoreException {
        if (this.documentStatusManager == null) {
            this.documentStatusManager = new LuceneDocumentStatusManager(this);
        }
        return this.documentStatusManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Set<String> uris) throws MetadataStoreException {
        this.lock.lock();
        try {
            IndexWriter indexWriter;
            IndexWriter indexWriter2 = indexWriter = this.getWriter();
            synchronized (indexWriter2) {
                for (String curUri : uris) {
                    indexWriter.deleteDocuments(new Term(AbstractLuceneStore.FIELD_TYPE.uri.toString(), curUri));
                }
                indexWriter.flush();
            }
        }
        catch (IOException e) {
            Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
            msg.addArgument(this.location);
            throw new MetadataStoreException(msg, (Throwable)e);
        }
        finally {
            this.lock.unlock();
        }
    }
}

