/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr.lucene;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.crawler.adapter.ContentSet;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.StoreContext;
import com.ibm.es.nuvo.crawler.cdsr.lucene.AbstractLuceneStore;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneMetadataStore
extends AbstractLuceneStore {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + LuceneMetadataStore.class.getName());
    private static final ExtendedLogger cxTracer = ExtendedLogger.getLogger("NuvoTracer." + Context.class.getName());
    private HashMap<Long, AbstractLuceneStore.DocumentInfo> writeQueue = new HashMap();
    private Lock lock = new ReentrantLock(true);
    private String location;

    LuceneMetadataStore(LuceneMetadataStoreManager manager, String id) throws MetadataStoreException {
        super(manager, id);
        this.rootContext = new Context(null, null);
        this.searcher = manager.getSearcher();
        this.location = manager.getLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeEntries(Map<Long, AbstractLuceneStore.DocumentInfo> records) throws MetadataStoreException {
        int count = 0;
        if (records.size() > 0) {
            try {
                IndexWriter indexWriter = this.writer;
                synchronized (indexWriter) {
                    for (AbstractLuceneStore.DocumentInfo info : records.values()) {
                        if (info.touched) continue;
                        this.writer.deleteDocuments(new Term(AbstractLuceneStore.FIELD_TYPE.docid.toString(), info.docid));
                        if (tracer.isLoggable(Level.FINEST)) {
                            tracer.finest("Removed " + info);
                        }
                        if (info.numChildren != 0 || info.hadChildren) continue;
                        ++count;
                    }
                }
            }
            catch (IOException e) {
                Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
                msg.addArgument(this.location);
                throw new MetadataStoreException(msg, (Throwable)e);
            }
        }
        records.clear();
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueDoc(Long urlHash, AbstractLuceneStore.DocumentInfo info) throws MetadataStoreException {
        this.lock.lock();
        try {
            info.crawledDate = System.currentTimeMillis();
            this.writeQueue.put(urlHash, info);
        }
        finally {
            this.lock.unlock();
        }
        this.tryFlush();
    }

    private void collectSubTree(Map<Long, AbstractLuceneStore.DocumentInfo> removedDocs) throws MetadataStoreException {
        Stack<Long> stack = new Stack<Long>();
        for (Map.Entry<Long, AbstractLuceneStore.DocumentInfo> entry : removedDocs.entrySet()) {
            if (!entry.getValue().hadChildren) continue;
            stack.push(entry.getKey());
        }
        while (stack.size() > 0) {
            Long pid = (Long)stack.pop();
            boolean touched = removedDocs.get((Object)pid).touched;
            Map<Long, AbstractLuceneStore.DocumentInfo> children = this.collectChildren(pid);
            for (Map.Entry<Long, AbstractLuceneStore.DocumentInfo> entry : children.entrySet()) {
                AbstractLuceneStore.DocumentInfo info = entry.getValue();
                info.touched = touched;
                if (info.hadChildren) {
                    stack.push(entry.getKey());
                }
                removedDocs.put(entry.getKey(), info);
            }
        }
    }

    private Map<Long, AbstractLuceneStore.DocumentInfo> collectChildren(Long contextHash) throws MetadataStoreException {
        HashMap<Long, AbstractLuceneStore.DocumentInfo> m = new HashMap<Long, AbstractLuceneStore.DocumentInfo>();
        try {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term("crawl_space_id", this.id)), BooleanClause.Occur.MUST);
            query.add((Query)new TermQuery(new Term(AbstractLuceneStore.FIELD_TYPE.parent.toString(), contextHash != null ? String.valueOf(contextHash) : "root")), BooleanClause.Occur.MUST);
            Hits hits = this.searcher.search((Query)query);
            for (int i = 0; i < hits.length(); ++i) {
                Document document = hits.doc(i);
                Field field = document.getField(AbstractLuceneStore.FIELD_TYPE.urlhash.toString());
                Long urlHash = "root".equals(field.stringValue()) ? null : Long.valueOf(Long.parseLong(field.stringValue()));
                AbstractLuceneStore.DocumentInfo info = urlHash == null ? this.rootDocument : new AbstractLuceneStore.DocumentInfo(this.id, urlHash, false);
                info.load(info.docid, document);
                if (urlHash == null) continue;
                m.put(urlHash, info);
            }
            if (tracer.isLoggable(Level.FINEST)) {
                tracer.finest("Children for " + contextHash + " " + m);
            }
        }
        catch (IOException e) {
            Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
            msg.addArgument(this.location);
            throw new MetadataStoreException(msg, (Throwable)e);
        }
        return m;
    }

    @Override
    public synchronized void close() throws MetadataStoreException {
        if (this.isClosed()) {
            return;
        }
        this.enqueueDoc(null, this.rootDocument);
        this.flush();
        super.close();
        if (tracer.isLoggable(Level.FINE)) {
            tracer.fine("Closed " + this.id);
        }
    }

    private void tryFlush() throws MetadataStoreException {
        if (this.writeQueue.size() > 1000) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush() throws MetadataStoreException {
        this.lock.lock();
        HashMap<Long, AbstractLuceneStore.DocumentInfo> q = null;
        try {
            if (this.writeQueue.size() == 0) {
                return;
            }
            q = this.writeQueue;
            this.writeQueue = new HashMap();
        }
        finally {
            this.lock.unlock();
        }
        if (this.writer != null) {
            IndexWriter indexWriter = this.writer;
            synchronized (indexWriter) {
                try {
                    ArrayList<Document> addList = new ArrayList<Document>();
                    for (Map.Entry<Long, AbstractLuceneStore.DocumentInfo> entry : q.entrySet()) {
                        Long key = entry.getKey();
                        AbstractLuceneStore.DocumentInfo info = entry.getValue();
                        this.writer.deleteDocuments(new Term(AbstractLuceneStore.FIELD_TYPE.docid.toString(), info.docid));
                        Document document = info.toDocument(key);
                        if (tracer.isLoggable(Level.FINEST)) {
                            tracer.finest(document.toString().replaceAll(" stored/uncompressed|indexed|omitNorms|Document| ,", "").replaceAll("[<>]+", " "));
                        }
                        addList.add(document);
                    }
                    q = null;
                    for (Document document : addList) {
                        this.writer.addDocument(document);
                    }
                    this.writer.flush();
                }
                catch (IOException e) {
                    Message msg = new Message("C3536E.CRWL_CDSR_IO_ERROR");
                    msg.addArgument(this.location);
                    throw new MetadataStoreException(msg, (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Context
    implements StoreContext {
        private ContentSet data;
        private Long contextId;
        private Map<Long, AbstractLuceneStore.DocumentInfo> records = new HashMap<Long, AbstractLuceneStore.DocumentInfo>();
        private int initialRecords;
        private int numChildren;
        private Context parent;
        private AbstractLuceneStore.DocumentInfo documentInfo;
        private CrawlMode mode;

        public Context(Long contextId, Context parent) {
            this.contextId = contextId;
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long getHash(long urlHash) {
            Map<Long, AbstractLuceneStore.DocumentInfo> map = this.records;
            synchronized (map) {
                AbstractLuceneStore.DocumentInfo info = this.records.get(urlHash);
                return info == null ? null : info.hash;
            }
        }

        @Override
        public Iterator<String> getRemovedDocumentNameIterator() throws MetadataStoreException {
            if (CrawlMode.QUICK == this.mode) {
                return null;
            }
            LuceneMetadataStore.this.collectSubTree(this.records);
            ArrayList<String> list = new ArrayList<String>();
            int num = 0;
            for (Map.Entry<Long, AbstractLuceneStore.DocumentInfo> entry : this.records.entrySet()) {
                AbstractLuceneStore.DocumentInfo info = entry.getValue();
                if (info.numChildren != 0 || info.hadChildren || info.hash == null && !info.touched) continue;
                list.add(info.uri);
                ++num;
            }
            this.numChildren -= num;
            if (cxTracer.isLoggable(Level.FINEST)) {
                cxTracer.finest("Removed " + this.contextId + " " + list);
            }
            return list.iterator();
        }

        @Override
        public StoreContext getParent() {
            return this.parent;
        }

        @Override
        public Long getId() {
            return this.contextId;
        }

        @Override
        public ContentSet get() {
            return this.data;
        }

        @Override
        public void set(ContentSet data) {
            this.data = data;
        }

        @Override
        public void setMode(CrawlMode mode) {
            this.mode = mode;
        }

        @Override
        public int countChildren(long uriHash) {
            AbstractLuceneStore.DocumentInfo info = this.records.get(uriHash);
            return info == null ? 0 : info.numChildren;
        }

        @Override
        public StoreContext subContext(long uriHash, long contentHash, String uri) throws MetadataStoreException {
            Context context = new Context(uriHash, this);
            AbstractLuceneStore.DocumentInfo info = new AbstractLuceneStore.DocumentInfo(LuceneMetadataStore.this.id, uriHash, false);
            info.parent = this.contextId;
            info.hash = contentHash;
            info.code = 200;
            info.uri = uri;
            context.documentInfo = info;
            return context;
        }

        @Override
        public void enter() throws MetadataStoreException {
            this.records = LuceneMetadataStore.this.collectChildren(this.contextId);
            if (cxTracer.isLoggable(Level.FINER)) {
                cxTracer.finer("Enter " + this.contextId);
            }
            if (this.contextId == null) {
                this.documentInfo = LuceneMetadataStore.this.rootDocument;
            }
            int num = 0;
            for (AbstractLuceneStore.DocumentInfo info : this.records.values()) {
                if (info.hadChildren) {
                    num += info.numChildren;
                    continue;
                }
                ++num;
            }
            this.numChildren = this.initialRecords = num;
        }

        @Override
        public StoreContext exit() throws MetadataStoreException {
            if (CrawlMode.QUICK != this.mode) {
                LuceneMetadataStore.this.removeEntries(this.records);
            }
            this.documentInfo.numChildren = this.numChildren;
            LuceneMetadataStore.this.enqueueDoc(this.contextId, this.documentInfo);
            if (this.parent != null) {
                this.parent.numChildren += this.numChildren - this.initialRecords;
            }
            if (cxTracer.isLoggable(Level.FINER)) {
                cxTracer.finer("Exit " + this.contextId + " " + (this.numChildren - this.initialRecords));
            }
            return this.parent;
        }

        @Override
        public void upsert(long uriHash, long contentHash, String uri) throws MetadataStoreException {
            this.upsertRecord(uriHash, null, contentHash, uri, false);
        }

        @Override
        public void upsertError(long uriHash, int code, boolean removeHash, String uri) throws MetadataStoreException {
            AbstractLuceneStore.DocumentInfo root = this.records.get(uriHash);
            if (root != null) {
                root.touched = true;
                HashMap<Long, AbstractLuceneStore.DocumentInfo> map = new HashMap<Long, AbstractLuceneStore.DocumentInfo>();
                Context cx = new Context(uriHash, this);
                cx.enter();
                LuceneMetadataStore.this.collectSubTree(cx.records);
                map.putAll(cx.records);
                map.put(uriHash, root);
                for (Map.Entry entry : map.entrySet()) {
                    AbstractLuceneStore.DocumentInfo info = (AbstractLuceneStore.DocumentInfo)entry.getValue();
                    info.code = code;
                    if (removeHash) {
                        info.hash = null;
                        info.numChildren = 0;
                        info.touched = false;
                        continue;
                    }
                    info.touched = true;
                    LuceneMetadataStore.this.enqueueDoc((Long)entry.getKey(), info);
                }
                if (!removeHash) {
                    this.records.remove(uriHash);
                }
            } else {
                this.upsertRecord(uriHash, code, null, uri, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void upsertRecord(long uriHash, Integer code, Long contentHash, String uri, boolean dontUpsertNewRecords) throws MetadataStoreException {
            boolean isErrored;
            boolean isNewRecord;
            AbstractLuceneStore.DocumentInfo info = this.records.get(uriHash);
            boolean bl = isNewRecord = info == null;
            if (isNewRecord && dontUpsertNewRecords) {
                return;
            }
            boolean bl2 = isErrored = contentHash == null;
            if (isNewRecord) {
                info = new AbstractLuceneStore.DocumentInfo(LuceneMetadataStore.this.id, uriHash, true);
                info.hash = contentHash;
                info.parent = this.contextId;
                info.code = code == null ? 200 : code;
                info.docType = AbstractLuceneStore.DOCUMENT_TYPE.LEAF;
                info.uri = uri;
                LuceneMetadataStore.this.enqueueDoc(uriHash, info);
                if (cxTracer.isLoggable(Level.FINEST)) {
                    cxTracer.finest("Add " + this.contextId + " " + uriHash + " " + code + " " + contentHash + " " + uri);
                }
                if (!isErrored) {
                    ++this.numChildren;
                }
            } else {
                if (isErrored) {
                    throw new MetadataStoreException(new Message("Lucenemetadatastore: " + uri + " is erroed document"));
                }
                if (code == null) {
                    code = info.code;
                }
                boolean isCodeChanged = code != info.code;
                boolean isContentChanged = !contentHash.equals(info.hash);
                boolean wasErrored = info.hash == null;
                Map<Long, AbstractLuceneStore.DocumentInfo> map = this.records;
                synchronized (map) {
                    this.records.remove(uriHash);
                }
                if (isCodeChanged) {
                    info.code = code;
                }
                if (isContentChanged) {
                    if (wasErrored) {
                        ++this.numChildren;
                    }
                    info.hash = contentHash;
                }
                if (isCodeChanged || isContentChanged) {
                    LuceneMetadataStore.this.enqueueDoc(uriHash, info);
                }
                if (cxTracer.isLoggable(Level.FINEST)) {
                    cxTracer.finest("Update " + this.contextId + " " + uriHash + " " + code + " " + contentHash);
                }
            }
        }

        @Override
        public void upsert(long uriHash, int code, long contentHash, String uri) throws MetadataStoreException {
            this.upsertRecord(uriHash, code, contentHash, uri, false);
        }

        @Override
        public void updateLastSuccessfulCrawledDate(long uriHash, long successfulCrawledDate) throws MetadataStoreException {
            AbstractLuceneStore.DocumentInfo info = this.records.get(uriHash);
            if (info == null) {
                return;
            }
            info.successfulCrawledDate = successfulCrawledDate;
        }

        @Override
        public Date getLastSuccessfulCrawledDate(long uriHash) throws MetadataStoreException {
            AbstractLuceneStore.DocumentInfo info = this.records.get(uriHash);
            if (info != null) {
                if (info.successfulCrawledDate == 0L) {
                    return null;
                }
                return new Date(info.successfulCrawledDate);
            }
            return null;
        }

        @Override
        public void upsertOnlyOldRecords(long uriHash, long contentHash, String uri) throws MetadataStoreException {
            this.upsertRecord(uriHash, null, contentHash, uri, true);
        }

        @Override
        public void upsertOnlyOldRecords(long uriHash, int code, long contentHash, String uri) throws MetadataStoreException {
            this.upsertRecord(uriHash, code, contentHash, uri, true);
        }

        @Override
        public boolean isNewRecord(long uriHash) {
            AbstractLuceneStore.DocumentInfo info = this.records.get(uriHash);
            boolean isNewRecord = info == null;
            return isNewRecord;
        }
    }
}

