/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr.lucene;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.crawler.admin.CrawledDocumentStatus;
import com.ibm.es.nuvo.crawler.cdsr.DocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.lucene.AbstractLuceneStore;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FilteredTermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.WildcardQuery;

public class LuceneDocumentStatusManager
implements DocumentStatusManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    static final Analyzer analyzer = new SimpleAnalyzer();
    private final LuceneMetadataStoreManager manager;
    private static final String URI_FLD = AbstractLuceneStore.FIELD_TYPE.uri.toString();
    private static final String NORMURI_FLD = AbstractLuceneStore.FIELD_TYPE.normalized_uri.toString();
    private static final String CODE_FLD = AbstractLuceneStore.FIELD_TYPE.code.toString();
    private static final String DATE_FLD = AbstractLuceneStore.FIELD_TYPE.crawled_date.toString();
    private static final String CRAWL_SPACE_ID = "crawl_space_id";
    private static final String LEAF_FLAG = AbstractLuceneStore.FIELD_TYPE.doctype.toString();
    private static final String LEAF = AbstractLuceneStore.DOCUMENT_TYPE.LEAF.toString();

    public LuceneDocumentStatusManager(LuceneMetadataStoreManager manager) throws MetadataStoreException {
        this.manager = manager;
    }

    public CrawledDocumentStatus getCrawledDocumentStatus(String crawlSpaceId, String uriPattern, int max) throws ExtendedException {
        IndexSearcher searcher = null;
        LuceneCrawledDocumentStatus result = new LuceneCrawledDocumentStatus();
        LimittedClausesWildcardQuery uriQuery = new LimittedClausesWildcardQuery(new Term(NORMURI_FLD, uriPattern.toLowerCase()));
        TermQuery spaceIdQuery = new TermQuery(new Term(CRAWL_SPACE_ID, crawlSpaceId));
        TermQuery leafQuery = new TermQuery(new Term(LEAF_FLAG, LEAF));
        BooleanQuery bq = new BooleanQuery(true);
        bq.add((Query)spaceIdQuery, BooleanClause.Occur.MUST);
        bq.add((Query)uriQuery, BooleanClause.Occur.MUST);
        bq.add((Query)leafQuery, BooleanClause.Occur.MUST);
        try {
            searcher = this.manager.getSearcher();
            Hits hits = searcher.search((Query)bq);
            int counter = 0;
            for (int i = 0; i < hits.length(); ++i) {
                if (0 < max && max == counter) {
                    break;
                }
                Document document = hits.doc(i);
                String uri = document.getField(URI_FLD).stringValue().intern();
                String code = document.getField(CODE_FLD).stringValue().intern();
                String date = document.getField(DATE_FLD).stringValue().intern();
                result.add(uri, Integer.parseInt(code), Long.parseLong(date));
                ++counter;
            }
        }
        catch (IOException e) {
            throw new ExtendedException(e);
        }
        catch (MetadataStoreException e) {
            throw new ExtendedException(e);
        }
        finally {
            if (searcher != null) {
                try {
                    searcher.close();
                    searcher = null;
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    static class LuceneCrawledDocumentStatus
    implements CrawledDocumentStatus {
        private String uri = null;
        private int code = 0;
        private Date date = null;
        private List<String> uriList = new ArrayList<String>();
        private List<Integer> codeList = new ArrayList<Integer>();
        private List<Date> dateList = new ArrayList<Date>();
        private Iterator<String> uriItr = null;
        private Iterator<Integer> codeItr = null;
        private Iterator<Date> dateItr = null;

        public void add(String docUri, int returnCode, long crawledDate) {
            this.uriList.add(docUri);
            this.codeList.add(returnCode);
            this.dateList.add(new Date(crawledDate));
        }

        public String getURI() {
            return this.uri;
        }

        public int getCode() {
            return this.code;
        }

        public Date getDate() {
            return this.date;
        }

        public boolean next() {
            if (this.uriItr == null) {
                this.uriItr = this.uriList.iterator();
                this.codeItr = this.codeList.iterator();
                this.dateItr = this.dateList.iterator();
            }
            if (this.uriItr.hasNext()) {
                this.uri = this.uriItr.next();
                this.code = this.codeItr.next();
                this.date = this.dateItr.next();
                return true;
            }
            return false;
        }

        public String toString() {
            return "URI:" + this.uri + " CODE:" + this.code + " DATE:" + this.date;
        }
    }

    static class LimittedClausesTermEnum
    extends FilteredTermEnum {
        private FilteredTermEnum termEnum;
        private int count = 1;
        private final int CLAUSE_LIMIT = BooleanQuery.getMaxClauseCount();

        public LimittedClausesTermEnum(FilteredTermEnum termEnum) {
            this.termEnum = termEnum;
        }

        public Term term() {
            return this.termEnum.term();
        }

        public int docFreq() {
            return this.termEnum.docFreq();
        }

        public void close() throws IOException {
            this.termEnum.close();
        }

        public float difference() {
            return this.termEnum.difference();
        }

        protected boolean endEnum() {
            return this.count >= this.CLAUSE_LIMIT;
        }

        protected boolean termCompare(Term term) {
            return false;
        }

        public boolean next() throws IOException {
            if (this.count < this.CLAUSE_LIMIT && this.termEnum.next()) {
                ++this.count;
                return true;
            }
            return false;
        }
    }

    static class LimittedClausesWildcardQuery
    extends WildcardQuery {
        private static final long serialVersionUID = 1L;

        public LimittedClausesWildcardQuery(Term term) {
            super(term);
        }

        protected FilteredTermEnum getEnum(IndexReader reader) throws IOException {
            return new LimittedClausesTermEnum(super.getEnum(reader));
        }
    }
}

