/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr.lucene;

import com.ibm.es.nuvo.crawler.cdsr.MetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.StoreContext;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import java.io.IOException;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;

public abstract class AbstractLuceneStore
implements MetadataStore {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String id;
    public static final String KEY_CRAWLSPACE_ID = "crawl_space_id";
    protected static final int QUEUE_MAX = 1000;
    protected IndexWriter writer;
    protected IndexSearcher searcher;
    protected LuceneMetadataStoreManager manager;
    protected DocumentInfo rootDocument;
    protected LuceneMetadataStore.Context rootContext;
    protected static final boolean STORE_URI = true;

    public AbstractLuceneStore(LuceneMetadataStoreManager manager, String id) throws MetadataStoreException {
        this.id = id;
        this.writer = manager.getWriter();
        this.writer.setMaxBufferedDocs(1000);
        this.manager = manager;
        this.rootDocument = new DocumentInfo(this.id, null, false);
    }

    public void close() throws MetadataStoreException {
        if (this.searcher != null) {
            try {
                this.searcher.close();
                this.searcher = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.writer = null;
    }

    public boolean isClosed() {
        return this.writer == null;
    }

    public StoreContext getDefaultContext() {
        return this.rootContext;
    }

    protected class DocumentInfo {
        protected boolean touched;
        protected int code;
        protected Long hash;
        protected Long parent;
        protected String docid = "";
        protected int numChildren;
        protected boolean hadChildren;
        protected String uri;
        protected long crawledDate;
        protected long successfulCrawledDate;
        protected DOCUMENT_TYPE docType;
        private boolean isLoaded = false;

        protected DocumentInfo(String crawlSpaceId, Long urlHash, boolean isLeaf) {
            this.docid = crawlSpaceId + (urlHash == null ? "" : urlHash);
            this.docType = isLeaf ? DOCUMENT_TYPE.LEAF : DOCUMENT_TYPE.NODE;
        }

        Document toDocument(Long urlHash) {
            Document document = new Document();
            document.add((Fieldable)new Field(AbstractLuceneStore.KEY_CRAWLSPACE_ID, AbstractLuceneStore.this.id, Field.Store.NO, Field.Index.NO_NORMS));
            document.add((Fieldable)new Field(FIELD_TYPE.urlhash.toString(), urlHash != null ? String.valueOf(urlHash) : "root", Field.Store.YES, Field.Index.NO_NORMS));
            if (this.hash != null) {
                document.add((Fieldable)new Field(FIELD_TYPE.hash.toString(), String.valueOf(this.hash), Field.Store.YES, Field.Index.NO));
            }
            document.add((Fieldable)new Field(FIELD_TYPE.code.toString(), String.valueOf(this.code), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FIELD_TYPE.parent.toString(), this.parent != null ? String.valueOf(this.parent) : "root", Field.Store.YES, Field.Index.NO_NORMS));
            if (this.numChildren > 0 || this.hadChildren) {
                document.add((Fieldable)new Field(FIELD_TYPE.children.toString(), String.valueOf(this.numChildren), Field.Store.YES, Field.Index.NO));
            }
            if (this.uri != null) {
                document.add((Fieldable)new Field(FIELD_TYPE.uri.toString(), this.uri, Field.Store.YES, Field.Index.NO_NORMS));
            }
            if (this.uri != null) {
                document.add((Fieldable)new Field(FIELD_TYPE.normalized_uri.toString(), this.uri.toLowerCase(), Field.Store.NO, Field.Index.NO_NORMS));
            }
            document.add((Fieldable)new Field(FIELD_TYPE.crawled_date.toString(), String.valueOf(this.crawledDate), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FIELD_TYPE.successful_crawled_date.toString(), String.valueOf(this.successfulCrawledDate), Field.Store.YES, Field.Index.NO));
            document.add((Fieldable)new Field(FIELD_TYPE.docid.toString(), urlHash != null ? AbstractLuceneStore.this.id + String.valueOf(urlHash) : AbstractLuceneStore.this.id, Field.Store.NO, Field.Index.NO_NORMS));
            document.add((Fieldable)new Field(FIELD_TYPE.doctype.toString(), String.valueOf((Object)this.docType), Field.Store.YES, Field.Index.NO_NORMS));
            return document;
        }

        public void load(String dId, Document document) {
            this.docid = dId;
            Field field = document.getField(FIELD_TYPE.hash.toString());
            if (field != null) {
                this.hash = Long.parseLong(field.stringValue());
            }
            if ((field = document.getField(FIELD_TYPE.parent.toString())) != null && !"root".equals(field.stringValue())) {
                this.parent = Long.parseLong(field.stringValue());
            }
            if ((field = document.getField(FIELD_TYPE.children.toString())) != null) {
                this.numChildren = Integer.parseInt(field.stringValue());
                this.hadChildren = true;
            }
            if ((field = document.getField(FIELD_TYPE.code.toString())) != null) {
                this.code = Integer.parseInt(field.stringValue());
            }
            if ((field = document.getField(FIELD_TYPE.uri.toString())) != null) {
                this.uri = field.stringValue();
            }
            if ((field = document.getField(FIELD_TYPE.crawled_date.toString())) != null) {
                this.crawledDate = Long.parseLong(field.stringValue());
            }
            if ((field = document.getField(FIELD_TYPE.successful_crawled_date.toString())) != null) {
                this.successfulCrawledDate = Long.parseLong(field.stringValue());
            }
            if ((field = document.getField(FIELD_TYPE.doctype.toString())) != null) {
                String dType = field.stringValue();
                if (dType.equals(DOCUMENT_TYPE.NODE.toString())) {
                    this.docType = DOCUMENT_TYPE.NODE;
                } else if (dType.equals(DOCUMENT_TYPE.LEAF.toString())) {
                    this.docType = DOCUMENT_TYPE.LEAF;
                }
            }
            this.isLoaded = true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.uri);
            builder.append(this.hash == null ? "null" : this.hash);
            builder.append("-");
            builder.append(this.numChildren);
            builder.append(" Loaded:").append(this.isLoaded);
            return builder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DOCUMENT_TYPE {
        NODE,
        LEAF;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum FIELD_TYPE {
        urlhash,
        hash,
        parent,
        children,
        code,
        uri,
        crawled_date,
        successful_crawled_date,
        normalized_uri,
        docid,
        doctype;

    }
}

