/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr;

import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.StoreContext;
import com.ibm.es.nuvo.crawler.cdsr.StoreContextBroker;
import com.ibm.es.nuvo.logging.ExtendedLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleStoreContextBroker
implements StoreContextBroker {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final ExtendedLogger tracer = ExtendedLogger.getLogger("NuvoTracer." + SimpleStoreContextBroker.class.getName());
    private HashMap<Long, TreeElement> map = new HashMap();
    private Stack<TreeElement> stack = new Stack();
    private List<Long> ancestor = new ArrayList<Long>();
    private List<Long> unmodifiableAncestor = Collections.unmodifiableList(this.ancestor);

    @Override
    public void add(StoreContext context) throws MetadataStoreException {
        TreeElement pe;
        Long id = context.getId();
        StoreContext parent = context.getParent();
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Add " + id + " " + (parent == null ? "root" : parent.getId()));
        }
        TreeElement te = new TreeElement();
        TreeElement treeElement = pe = parent == null ? null : this.map.get(parent.getId());
        if (pe != null) {
            pe.children.add(te);
        }
        te.parent = pe;
        te.context = context;
        this.map.put(id, te);
        this.stack.push(te);
    }

    @Override
    public Iterator<StoreContext> exit(StoreContext context) throws MetadataStoreException {
        TreeElement element = this.map.get(context.getId());
        element.ref--;
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Exit " + context.getId());
        }
        if (element.ref == 0 && element.children.size() == 0) {
            ArrayList<StoreContext> list = new ArrayList<StoreContext>();
            while (element != null && element.ref == 0 && element.children.size() == 0) {
                if (element.parent != null) {
                    element.parent.children.remove(element);
                }
                this.map.remove(element.context.getId());
                list.add(element.context);
                element = element.parent;
            }
            if (tracer.isLoggable(Level.FINER)) {
                tracer.finer("Ready to close " + list);
            }
            return list.iterator();
        }
        return null;
    }

    @Override
    public StoreContext next() throws MetadataStoreException {
        TreeElement te = this.stack.size() == 0 ? null : this.stack.pop();
        StoreContext storeContext = null;
        if (te != null) {
            storeContext = te.context;
            te.ref++;
            storeContext.enter();
            this.ancestor.clear();
            while (te.parent != null && te != te.parent) {
                this.ancestor.add(te.context.getId());
                te = te.parent;
            }
        }
        if (tracer.isLoggable(Level.FINER)) {
            tracer.finer("Next " + storeContext);
        }
        return storeContext;
    }

    @Override
    @Deprecated
    public List<Long> getAncestor() {
        return this.unmodifiableAncestor;
    }

    private static class TreeElement {
        private StoreContext context;
        private TreeElement parent;
        private Set<TreeElement> children = new HashSet<TreeElement>();
        private int ref;

        private TreeElement() {
        }
    }
}

