/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr;

import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;

public abstract class SessionInfo {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String spaceName = "";
    protected long sessionId;
    protected long startTime;
    protected long finishTime;
    protected String crawlMode;
    protected String crawlStatus = "";
    protected long numOfTotalDoc;
    protected long numOfCrawledDoc;
    protected long numOfErrorDoc;
    protected long numOfInsertedDoc;
    protected long numOfUpdatedDoc;
    protected long numOfDeletedDoc;
    protected byte[] optionalData = new byte[0];
    protected long configHash;
    protected long maxLastModified;
    protected boolean isAllDocumentsUpToDate = true;
    protected long lastForceCrawled;

    protected SessionInfo() {
        this.sessionId = System.currentTimeMillis();
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public void start(String crawlmode) throws MetadataStoreException {
        this.crawlMode = crawlmode;
        this.saveAsStarted();
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void close() throws MetadataStoreException {
        this.saveAsFinished();
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    protected abstract void saveAsStarted() throws MetadataStoreException;

    protected abstract void saveAsFinished() throws MetadataStoreException;

    public boolean isFinished() {
        return this.finishTime > 0L;
    }

    public String getCrawlMode() {
        return this.crawlMode;
    }

    public void setStatus(String crawlStatus) {
        this.crawlStatus = crawlStatus;
    }

    public String getStatus() {
        return this.crawlStatus;
    }

    public long getConfigHash() {
        return this.configHash;
    }

    public void setConfigHash(long configHash) {
        this.configHash = configHash;
    }

    public long getMaxLastModified() {
        return this.maxLastModified;
    }

    public void setMaxLastModified(long maxLastModified) {
        this.maxLastModified = maxLastModified;
    }

    public long getNumOfCrawledDoc() {
        return this.numOfCrawledDoc;
    }

    public void setNumOfCrawledDoc(long numOfCrawledDoc) {
        this.numOfCrawledDoc = numOfCrawledDoc;
    }

    public long getNumOfDeletedDoc() {
        return this.numOfDeletedDoc;
    }

    public void setNumOfDeletedDoc(long numOfDeletedDoc) {
        this.numOfDeletedDoc = numOfDeletedDoc;
    }

    public long getNumOfErrorDoc() {
        return this.numOfErrorDoc;
    }

    public void setNumOfErrorDoc(long numOfErrorDoc) {
        this.numOfErrorDoc = numOfErrorDoc;
    }

    public long getNumOfInsertedDoc() {
        return this.numOfInsertedDoc;
    }

    public void setNumOfInsertedDoc(long numOfInsertedDoc) {
        this.numOfInsertedDoc = numOfInsertedDoc;
    }

    public long getNumOfTotalDoc() {
        return this.numOfTotalDoc;
    }

    public void setNumOfTotalDoc(long numOfTotalDoc) {
        this.numOfTotalDoc = numOfTotalDoc;
    }

    public long getNumOfUpdatedDoc() {
        return this.numOfUpdatedDoc;
    }

    public void setNumOfUpdatedDoc(long numOfUpdatedDoc) {
        this.numOfUpdatedDoc = numOfUpdatedDoc;
    }

    public byte[] getOptionalData() {
        return this.optionalData;
    }

    public void setOptionalData(byte[] optionalData) {
        this.optionalData = optionalData;
    }

    public String getSpaceName() {
        return this.spaceName;
    }

    public void setSpaceName(String spaceName) {
        this.spaceName = spaceName;
    }

    public boolean isAllDocumentsUpToDate() {
        return this.isAllDocumentsUpToDate;
    }

    public void allDocumentsIsUpToDate(boolean isConsistent) {
        this.isAllDocumentsUpToDate = isConsistent;
    }

    public void setLastForceCrawled(long time) {
        this.lastForceCrawled = time;
    }

    public long getLastForceCrawled() {
        return this.lastForceCrawled;
    }

    public String toString() {
        return String.valueOf(this.sessionId) + "," + (this.isFinished() ? "finished" : "running");
    }

    public String printInfo() {
        StringBuilder str = new StringBuilder(1024);
        str.append("sessionId:" + this.sessionId);
        str.append(" spaceName:" + this.spaceName);
        str.append(" crawlMode:" + this.crawlMode);
        str.append(" crawlStatus:" + this.crawlStatus);
        str.append(" startTime:" + this.startTime);
        str.append(" finishTime:" + this.finishTime);
        str.append(" numOfTotalDoc:" + this.numOfTotalDoc);
        str.append(" numOfCrawledDoc:" + this.numOfCrawledDoc);
        str.append(" numOfInsertedDoc:" + this.numOfInsertedDoc);
        str.append(" numOfUpdatedDoc:" + this.numOfUpdatedDoc);
        str.append(" numOfDeletedDoc:" + this.numOfDeletedDoc);
        str.append(" numOfErrorDoc:" + this.numOfErrorDoc);
        str.append(" maxLastModified:" + this.maxLastModified);
        return str.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DocumentStatus {
        CONSISTENT,
        INCONSISTENT;

    }
}

