/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.cdsr;

import com.ibm.es.nuvo.crawler.cdsr.DocumentStatusManager;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStore;
import com.ibm.es.nuvo.crawler.cdsr.MetadataStoreException;
import com.ibm.es.nuvo.crawler.cdsr.SessionInfoManager;
import com.ibm.es.nuvo.crawler.cdsr.lucene.LuceneMetadataStoreManager;
import java.util.ArrayList;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataStoreManager {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected int numRevision = 10;
    protected String location;
    private ArrayList<MetadataStore> stores = new ArrayList();

    public static MetadataStoreManager createMetadataStoreManager(String location) {
        return new LuceneMetadataStoreManager(location);
    }

    public MetadataStoreManager(String location) {
        this.location = location;
    }

    protected abstract MetadataStore createMetadataStore(String var1, String var2) throws MetadataStoreException;

    public abstract void drop(String var1) throws MetadataStoreException;

    public abstract void remove(Set<String> var1) throws MetadataStoreException;

    public abstract SessionInfoManager getSessionInfoManager() throws MetadataStoreException;

    public abstract DocumentStatusManager getDocumentStatusManager() throws MetadataStoreException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataStore getMetadataStore(String crawlSpaceId) throws MetadataStoreException {
        MetadataStore store = this.createMetadataStore(this.location, crawlSpaceId);
        if (store != null) {
            ArrayList<MetadataStore> arrayList = this.stores;
            synchronized (arrayList) {
                this.stores.add(store);
            }
        }
        return store;
    }

    public void setNumRevision(int numRevision) {
        this.numRevision = numRevision;
    }

    public int getNumRevision() {
        return this.numRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws MetadataStoreException {
        ArrayList<MetadataStore> arrayList = this.stores;
        synchronized (arrayList) {
            for (MetadataStore store : this.stores) {
                if (store == null) continue;
                store.close();
            }
            this.stores.clear();
        }
    }

    public String getLocation() {
        return this.location;
    }
}

