/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.admin.util;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcess;
import com.ibm.es.nuvo.crawler.util.fenced.WinSecurityProcessException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileCrawlerUtil {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static CrawlerConfiguration createNetworkConfig(CrawlerManager cManager, String crawlerName, String user, String passwd, String networkFolder) throws CrawlerConfigurationException {
        CrawlerConfiguration crawlerConfig = null;
        CrawlerType[] types = cManager.getAvailableCrawlerTypes();
        CrawlerType fileType = FileCrawlerUtil.getFileCrawlerType(types);
        List<Configuration> requiredConfigs = fileType.getRequiredConfigurations();
        FileCrawlerUtil.setInfoToConnectNetworkDrive(requiredConfigs, user, passwd, networkFolder);
        crawlerConfig = cManager.newCrawlerConfiguration(crawlerName, fileType, requiredConfigs, null);
        if (crawlerConfig.hasSubSpaces() && crawlerConfig.hasSubSpaces()) {
            crawlerConfig.open();
        }
        return crawlerConfig;
    }

    public static CrawlerType getFileCrawlerType(CrawlerType[] types) {
        CrawlerType fstype = null;
        for (CrawlerType t : types) {
            if (!t.getName().equals("com.ibm.es.nuvo.crawler.adapter.file")) continue;
            fstype = t;
        }
        return fstype;
    }

    private static void setInfoToConnectNetworkDrive(List<Configuration> configs, String user, String password, String networkFolder) {
        for (Configuration config : configs) {
            String name = config.getName();
            if (name.equals("network_user")) {
                config.setString(user);
                continue;
            }
            if (name.equals("network_password")) {
                config.setString(password);
                continue;
            }
            if (!name.equals("network_folder")) continue;
            config.setString(networkFolder);
        }
    }

    public static void disconnect(String networkPath) throws CrawlerConfigurationException {
        try {
            GlobalCrawlerManager gcm = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
            WinSecurityProcess wsp = gcm.getFencedWinSecurityProcess();
            wsp.netDisconnect(networkPath);
        }
        catch (WinSecurityProcessException wspe) {
            throw new CrawlerConfigurationException(wspe);
        }
    }
}

