/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.crawler.admin.util;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import java.util.Date;

public class CrawlerAdminUtil {
    private static final String COPYRIGHT = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static CrawlSpaceControl getCrawlSpaceControl(String collectionId, String crawlspaceId) throws CrawlerControlException {
        CrawlerManager manager;
        CrawlSpaceControl crawlSpace = null;
        GlobalCrawlerManager global = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        if (global != null && (manager = global.getCrawlerManager(collectionId)) != null) {
            String crawlerId;
            CrawlerControl[] ccArray = manager.getAvailableCrawlerControls();
            for (int i = 0; i < ccArray.length && (crawlSpace = manager.getCrawlSpaceControl(crawlerId = ccArray[i].getID(), crawlspaceId)) == null; ++i) {
            }
        }
        return crawlSpace;
    }

    public static boolean hasInitialCrawlingStarted(String collectionId, String crawlspaceId) throws CrawlerControlException {
        CrawlSpaceControl cc = CrawlerAdminUtil.getCrawlSpaceControl(collectionId, crawlspaceId);
        if (cc != null) {
            Date lastStartTime = cc.getCrawlSpaceStatus().getStartTime();
            if (lastStartTime == null) {
                return false;
            }
            return lastStartTime.after(new Date(0L));
        }
        return false;
    }
}

